/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.ant.BaseTask;
import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Jar;
import aQute.lib.io.IO;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.tools.ant.BuildException;

public class PackageTask
extends BaseTask {
    String runFilePath = null;
    File output = null;
    boolean keep = false;

    public void execute() throws BuildException {
        if (this.output == null) {
            throw new BuildException("Output file must be specified");
        }
        FileOutputStream outStream = null;
        try {
            Project packageProject;
            File baseDir = this.getProject().getBaseDir();
            Project baseProject = Workspace.getProject(baseDir);
            if (this.runFilePath == null || this.runFilePath.length() == 0 || ".".equals(this.runFilePath)) {
                packageProject = baseProject;
            } else {
                File runFile = new File(baseDir, this.runFilePath);
                if (!runFile.isFile()) {
                    throw new BuildException(String.format("Run file %s does not exist (or is not a file).", runFile.getAbsolutePath()));
                }
                packageProject = new Project(baseProject.getWorkspace(), baseDir, runFile);
                packageProject.setParent(baseProject);
            }
            packageProject.clear();
            ProjectLauncher launcher = packageProject.getProjectLauncher();
            launcher.setKeep(this.keep);
            Jar jar = launcher.executable();
            outStream = new FileOutputStream(this.output);
            jar.write(outStream);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                IO.close(outStream);
                throw throwable;
            }
        }
        IO.close(outStream);
    }

    public void setRunfile(String runFile) {
        this.runFilePath = runFile != null ? runFile.trim() : null;
    }

    public void setOutput(File output) {
        this.output = output;
    }
}

