/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.events.BaseDefaultLayoutPrototypesAction;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.wiki.model.WikiPage;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class AddDefaultLayoutPrototypesAction
extends BaseDefaultLayoutPrototypesAction {
    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(GetterUtil.getLong((String)ids[0]));
        }
        catch (Exception e2) {
            throw new ActionException((Throwable)e2);
        }
    }

    protected void addBlogPage(long companyId, long defaultUserId, List<LayoutPrototype> layoutPrototypes) throws Exception {
        Layout layout = this.addLayoutPrototype(companyId, defaultUserId, "Blog", "Create, edit, and view blogs from this page. Explore topics using tags, and connect with other members that blog.", "2_columns_iii", layoutPrototypes);
        if (layout == null) {
            return;
        }
        this.addPortletId(layout, "33", "column-1");
        String portletId = this.addPortletId(layout, "148", "column-2");
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("classNameId", String.valueOf(PortalUtil.getClassNameId(BlogsEntry.class)));
        preferences.put("showAssetCount", Boolean.TRUE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        this.addPortletId(layout, "114", "column-2");
    }

    protected Layout addLayoutPrototype(long companyId, long defaultUserId, String name, String description, String layouteTemplateId, List<LayoutPrototype> layoutPrototypes) throws Exception {
        for (LayoutPrototype layoutPrototype : layoutPrototypes) {
            String curName = layoutPrototype.getName(LocaleUtil.getDefault());
            String curDescription = layoutPrototype.getDescription();
            if (!name.equals(curName) || !description.equals(curDescription)) continue;
            return null;
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), name);
        LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.addLayoutPrototype((long)defaultUserId, (long)companyId, nameMap, (String)description, (boolean)true, (ServiceContext)new ServiceContext());
        Layout layout = layoutPrototype.getLayout();
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, layouteTemplateId, false);
        return layout;
    }

    protected void addWebContentPage(long companyId, long defaultUserId, List<LayoutPrototype> layoutPrototypes) throws Exception {
        Layout layout = this.addLayoutPrototype(companyId, defaultUserId, "Content Display Page", "Create, edit, and explore web content with this page. Search available content, explore related content with tags, and browse content categories.", "2_columns_ii", layoutPrototypes);
        if (layout == null) {
            return;
        }
        this.addPortletId(layout, "141", "column-1");
        this.addPortletId(layout, "122", "column-1");
        this.addPortletId(layout, "3", "column-2");
        String portletId = this.addPortletId(layout, "101", "column-2");
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("default-asset-publisher-portlet-id", portletId);
        layout = LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }

    protected void addWikiPage(long companyId, long defaultUserId, List<LayoutPrototype> layoutPrototypes) throws Exception {
        Layout layout = this.addLayoutPrototype(companyId, defaultUserId, "Wiki", "Collaborate with members through the wiki on this page. Discover related content through tags, and navigate quickly and easily with categories.", "2_columns_iii", layoutPrototypes);
        if (layout == null) {
            return;
        }
        this.addPortletId(layout, "36", "column-1");
        this.addPortletId(layout, "122", "column-2");
        String portletId = this.addPortletId(layout, "141", "column-2");
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("classNameId", String.valueOf(PortalUtil.getClassNameId(WikiPage.class)));
        preferences.put("showAssetCount", Boolean.TRUE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
    }

    protected void doRun(long companyId) throws Exception {
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        List layoutPrototypes = LayoutPrototypeLocalServiceUtil.search((long)companyId, null, (int)-1, (int)-1, null);
        this.addBlogPage(companyId, defaultUserId, layoutPrototypes);
        this.addWebContentPage(companyId, defaultUserId, layoutPrototypes);
        this.addWikiPage(companyId, defaultUserId, layoutPrototypes);
    }
}

