/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.search.lucene.RelevancyChecker;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWord;

public class StringDistanceRelevancyChecker
implements RelevancyChecker {
    private float _scoresThreshold;
    private StringDistance _stringDistance;
    private String _word;

    public StringDistanceRelevancyChecker(String word, float scoresThreshold, StringDistance stringDistance) {
        this._word = word;
        this._scoresThreshold = scoresThreshold;
        this._stringDistance = stringDistance;
    }

    @Override
    public boolean isRelevant(SuggestWord suggestWord) {
        String word = suggestWord.string;
        if (word.equals(this._word)) {
            return false;
        }
        suggestWord.score = this._stringDistance.getDistance(this._word, suggestWord.string);
        return !(suggestWord.score <= this._scoresThreshold);
    }
}

