/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.dao.jdbc.aop.DynamicDataSourceAdvice;
import com.liferay.portal.dao.jdbc.aop.DynamicDataSourceTargetSource;
import com.liferay.portal.kernel.spring.util.FactoryBean;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionExecutorFactory;
import com.liferay.portal.spring.transaction.TransactionInterceptor;
import org.aopalliance.intercept.MethodInterceptor;

public class TransactionInterceptorFactoryBean
implements FactoryBean<MethodInterceptor> {
    public MethodInterceptor create() {
        return new TransactionInterceptor();
    }

    public MethodInterceptor postProcessing(MethodInterceptor methodInterceptor) {
        TransactionInterceptor transactionInterceptor = (TransactionInterceptor)methodInterceptor;
        TransactionExecutor transactionExecutor = TransactionExecutorFactory.createTransactionExecutor(transactionInterceptor.platformTransactionManager, false);
        transactionInterceptor.setTransactionExecutor(transactionExecutor);
        DynamicDataSourceTargetSource dynamicDataSourceTargetSource = (DynamicDataSourceTargetSource)InfrastructureUtil.getDynamicDataSourceTargetSource();
        if (dynamicDataSourceTargetSource == null) {
            return methodInterceptor;
        }
        DynamicDataSourceAdvice dynamicDataSourceAdvice = new DynamicDataSourceAdvice();
        dynamicDataSourceAdvice.setDynamicDataSourceTargetSource(dynamicDataSourceTargetSource);
        dynamicDataSourceAdvice.setNextMethodInterceptor(methodInterceptor);
        dynamicDataSourceAdvice.setTransactionAttributeSource(transactionInterceptor.transactionAttributeSource);
        return dynamicDataSourceAdvice;
    }
}

