/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.RequiredStructureException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateElementException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateStructureKeyException;
import com.liferay.portlet.dynamicdatamapping.StructureNameException;
import com.liferay.portlet.dynamicdatamapping.StructureXsdException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMStructureLocalServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.util.DDMTemplateHelperUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DDMStructureLocalServiceImpl
extends DDMStructureLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DDMStructureLocalServiceImpl.class);

    public DDMStructure addStructure(long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, String storageType, int type, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        structureKey = Validator.isNull((String)structureKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)structureKey.trim());
        try {
            xsd = DDMXMLUtil.validateXML((String)xsd);
            xsd = DDMXMLUtil.formatXML((String)xsd);
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
        Date now = new Date();
        this.validate(groupId, parentStructureId, classNameId, structureKey, nameMap, xsd);
        long structureId = this.counterLocalService.increment();
        DDMStructure structure = this.ddmStructurePersistence.create(structureId);
        structure.setUuid(serviceContext.getUuid());
        structure.setGroupId(groupId);
        structure.setCompanyId(user.getCompanyId());
        structure.setUserId(user.getUserId());
        structure.setUserName(user.getFullName());
        structure.setCreateDate(serviceContext.getCreateDate(now));
        structure.setModifiedDate(serviceContext.getModifiedDate(now));
        structure.setParentStructureId(parentStructureId);
        structure.setClassNameId(classNameId);
        structure.setStructureKey(structureKey);
        structure.setNameMap(nameMap);
        structure.setDescriptionMap(descriptionMap);
        structure.setXsd(xsd);
        structure.setStorageType(storageType);
        structure.setType(type);
        this.ddmStructurePersistence.update((BaseModel)structure);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addStructureResources(structure, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addStructureResources(structure, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return structure;
    }

    public DDMStructure addStructure(long userId, long groupId, long classNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addStructure(userId, groupId, 0L, classNameId, null, nameMap, descriptionMap, xsd, PropsValues.DYNAMIC_DATA_LISTS_STORAGE_TYPE, 0, serviceContext);
    }

    public DDMStructure addStructure(long userId, long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, String storageType, int type, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure parentStructure = this.fetchStructure(groupId, classNameId, parentStructureKey);
        long parentStructureId = 0L;
        if (parentStructure != null) {
            parentStructureId = parentStructure.getStructureId();
        }
        return this.addStructure(userId, groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, xsd, storageType, type, serviceContext);
    }

    public void addStructureResources(DDMStructure structure, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), DDMStructure.class.getName(), structure.getStructureId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addStructureResources(DDMStructure structure, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), DDMStructure.class.getName(), structure.getStructureId(), groupPermissions, guestPermissions);
    }

    public DDMStructure copyStructure(long userId, long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.addStructure(userId, structure.getGroupId(), structure.getParentStructureId(), structure.getClassNameId(), null, nameMap, descriptionMap, structure.getXsd(), structure.getStorageType(), structure.getType(), serviceContext);
    }

    public DDMStructure copyStructure(long userId, long structureId, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.addStructure(userId, structure.getGroupId(), structure.getParentStructureId(), structure.getClassNameId(), null, (Map<Locale, String>)structure.getNameMap(), (Map<Locale, String>)structure.getDescriptionMap(), structure.getXsd(), structure.getStorageType(), structure.getType(), serviceContext);
    }

    @SystemEvent(type=1)
    public void deleteStructure(DDMStructure structure) throws PortalException, SystemException {
        if (!GroupThreadLocal.isDeleteInProcess()) {
            if (this.ddmStructureLinkPersistence.countByStructureId(structure.getStructureId()) > 0) {
                throw new RequiredStructureException(2);
            }
            if (this.ddmStructurePersistence.countByParentStructureId(structure.getStructureId()) > 0) {
                throw new RequiredStructureException(1);
            }
            long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
            if (this.ddmTemplatePersistence.countByG_C_C(structure.getGroupId(), classNameId, structure.getPrimaryKey()) > 0) {
                throw new RequiredStructureException(3);
            }
        }
        this.ddmStructurePersistence.remove((BaseModel)structure);
        this.resourceLocalService.deleteResource(structure.getCompanyId(), DDMStructure.class.getName(), 4, structure.getStructureId());
    }

    public void deleteStructure(long structureId) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        this.ddmStructureLocalService.deleteStructure(structure);
    }

    public void deleteStructure(long groupId, long classNameId, String structureKey) throws PortalException, SystemException {
        structureKey = this.getStructureKey(structureKey);
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        this.ddmStructureLocalService.deleteStructure(structure);
    }

    public void deleteStructures(long groupId) throws PortalException, SystemException {
        List structures = this.ddmStructurePersistence.findByGroupId(groupId);
        this.deleteStructures(structures);
    }

    public void deleteStructures(long groupId, long classNameId) throws PortalException, SystemException {
        List structures = this.ddmStructurePersistence.findByG_C(groupId, classNameId);
        this.deleteStructures(structures);
    }

    public DDMStructure fetchStructure(long structureId) throws SystemException {
        return this.ddmStructurePersistence.fetchByPrimaryKey(structureId);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey) throws SystemException {
        structureKey = this.getStructureKey(structureKey);
        return this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey, boolean includeGlobalStructures) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null || !includeGlobalStructures) {
            return structure;
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(group.getCompanyId());
        return this.ddmStructurePersistence.fetchByG_C_S(companyGroup.getGroupId(), classNameId, structureKey);
    }

    public List<DDMStructure> getClassStructures(long classNameId) throws SystemException {
        return this.ddmStructurePersistence.findByClassNameId(classNameId);
    }

    public List<DDMStructure> getClassStructures(long classNameId, int start, int end) throws SystemException {
        return this.ddmStructurePersistence.findByClassNameId(classNameId, start, end);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId) throws SystemException {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, int start, int end) throws SystemException {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId, start, end);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId, -1, -1, orderByComparator);
    }

    public List<DDMStructure> getClassStructures(long classNameId, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmStructurePersistence.findByClassNameId(classNameId, -1, -1, orderByComparator);
    }

    public List<DDMStructure> getDLFileEntryTypeStructures(long dlFileEntryTypeId) throws SystemException {
        return this.dlFileEntryTypePersistence.getDDMStructures(dlFileEntryTypeId);
    }

    public DDMStructure getStructure(long structureId) throws PortalException, SystemException {
        return this.ddmStructurePersistence.findByPrimaryKey(structureId);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey) throws PortalException, SystemException {
        structureKey = this.getStructureKey(structureKey);
        return this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey, boolean includeGlobalStructures) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null) {
            return structure;
        }
        if (!includeGlobalStructures) {
            throw new NoSuchStructureException("No DDMStructure exists with the structure key " + structureKey);
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(group.getCompanyId());
        return this.ddmStructurePersistence.findByG_C_S(companyGroup.getGroupId(), classNameId, structureKey);
    }

    public List<DDMStructure> getStructure(long groupId, String name, String description) throws SystemException {
        return this.ddmStructurePersistence.findByG_N_D(groupId, name, description);
    }

    public List<DDMStructure> getStructureEntries() throws SystemException {
        return this.getStructures();
    }

    public List<DDMStructure> getStructureEntries(long groupId) throws SystemException {
        return this.getStructures(groupId);
    }

    public List<DDMStructure> getStructureEntries(long groupId, int start, int end) throws SystemException {
        return this.getStructures(groupId, start, end);
    }

    public List<DDMStructure> getStructures() throws SystemException {
        return this.ddmStructurePersistence.findAll();
    }

    public List<DDMStructure> getStructures(long groupId) throws SystemException {
        return this.ddmStructurePersistence.findByGroupId(groupId);
    }

    public List<DDMStructure> getStructures(long groupId, int start, int end) throws SystemException {
        return this.ddmStructurePersistence.findByGroupId(groupId, start, end);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId) throws SystemException {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId, int start, int end) throws SystemException {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId, start, end);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId, start, end, orderByComparator);
    }

    public List<DDMStructure> getStructures(long groupId, String name, String description) throws SystemException {
        return this.ddmStructurePersistence.findByG_N_D(groupId, name, description);
    }

    public List<DDMStructure> getStructures(long[] groupIds) throws SystemException {
        return this.ddmStructurePersistence.findByGroupId(groupIds);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId) throws SystemException {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId, int start, int end) throws SystemException {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId, start, end);
    }

    public int getStructuresCount(long groupId) throws SystemException {
        return this.ddmStructurePersistence.countByGroupId(groupId);
    }

    public int getStructuresCount(long groupId, long classNameId) throws SystemException {
        return this.ddmStructurePersistence.countByG_C(groupId, classNameId);
    }

    public int getStructuresCount(long[] groupIds, long classNameId) throws SystemException {
        return this.ddmStructurePersistence.countByG_C(groupIds, classNameId);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long[] classNameIds, String keywords, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmStructureFinder.findByKeywords(companyId, groupIds, classNameIds, keywords, start, end, orderByComparator);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long[] classNameIds, String name, String description, String storageType, int type, boolean andOperator, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmStructureFinder.findByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, storageType, type, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, String keywords) throws SystemException {
        return this.ddmStructureFinder.countByKeywords(companyId, groupIds, classNameIds, keywords);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, String name, String description, String storageType, int type, boolean andOperator) throws SystemException {
        return this.ddmStructureFinder.countByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, storageType, type, andOperator);
    }

    public DDMStructure updateStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        structureKey = this.getStructureKey(structureKey);
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        return this.doUpdateStructure(parentStructureId, nameMap, descriptionMap, xsd, serviceContext, structure);
    }

    public DDMStructure updateStructure(long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.doUpdateStructure(parentStructureId, nameMap, descriptionMap, xsd, serviceContext, structure);
    }

    public DDMStructure updateXSD(long structureId, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.doUpdateStructure(structure.getParentStructureId(), structure.getNameMap(), structure.getDescriptionMap(), xsd, serviceContext, structure);
    }

    public void updateXSDFieldMetadata(long structureId, String fieldName, String metadataEntryName, String metadataEntryValue, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure ddmStructure = this.fetchDDMStructure(structureId);
        if (ddmStructure == null) {
            return;
        }
        String xsd = ddmStructure.getXsd();
        try {
            Document document = SAXReaderUtil.read((String)xsd);
            Element rootElement = document.getRootElement();
            List dynamicElementElements = rootElement.elements("dynamic-element");
            for (Element dynamicElementElement : dynamicElementElements) {
                String dynamicElementElementFieldName = GetterUtil.getString((String)dynamicElementElement.attributeValue("name"));
                if (!dynamicElementElementFieldName.equals(fieldName)) continue;
                List metadataElements = dynamicElementElement.elements("meta-data");
                for (Element metadataElement : metadataElements) {
                    List metadataEntryElements = metadataElement.elements();
                    for (Element metadataEntryElement : metadataEntryElements) {
                        String metadataEntryElementName = GetterUtil.getString((String)metadataEntryElement.attributeValue("name"));
                        if (!metadataEntryElementName.equals(metadataEntryName)) continue;
                        metadataEntryElement.setText(metadataEntryValue);
                    }
                }
            }
            this.updateXSD(structureId, document.asXML(), serviceContext);
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
    }

    protected void appendNewStructureRequiredFields(DDMStructure structure, Document templateDocument) {
        String xsd = structure.getXsd();
        Document structureDocument = null;
        try {
            structureDocument = SAXReaderUtil.read((String)xsd);
        }
        catch (DocumentException de) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)de, (Throwable)de);
            }
            return;
        }
        Element templateElement = templateDocument.getRootElement();
        XPath structureXPath = SAXReaderUtil.createXPath((String)"//dynamic-element[.//meta-data/entry[@name=\"required\"]=\"true\"]");
        List nodes = structureXPath.selectNodes((Object)structureDocument);
        for (Node node : nodes) {
            Element element = (Element)node;
            String name = element.attributeValue("name");
            XPath templateXPath = SAXReaderUtil.createXPath((String)("//dynamic-element[@name=" + (name = HtmlUtil.escapeXPathAttribute((String)name)) + "]"));
            if (templateXPath.booleanValueOf((Object)templateDocument)) continue;
            templateElement.add(element.createCopy());
        }
    }

    protected Set<Long> deleteStructures(List<DDMStructure> structures) throws PortalException, SystemException {
        HashSet<Long> deletedStructureIds = new HashSet<Long>();
        for (DDMStructure structure : structures) {
            if (deletedStructureIds.contains(structure.getStructureId())) continue;
            if (!GroupThreadLocal.isDeleteInProcess()) {
                List childDDMStructures = this.ddmStructurePersistence.findByParentStructureId(structure.getStructureId());
                deletedStructureIds.addAll(this.deleteStructures(childDDMStructures));
            }
            this.ddmStructureLocalService.deleteStructure(structure);
            deletedStructureIds.add(structure.getStructureId());
        }
        return deletedStructureIds;
    }

    protected DDMStructure doUpdateStructure(long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext, DDMStructure structure) throws PortalException, SystemException {
        try {
            xsd = DDMXMLUtil.validateXML((String)xsd);
            xsd = DDMXMLUtil.formatXML((String)xsd);
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
        String parentXsd = "";
        DDMStructure parentStructure = this.ddmStructurePersistence.fetchByPrimaryKey(parentStructureId);
        if (parentStructure != null) {
            parentXsd = parentStructure.getCompleteXsd();
        }
        this.validate(nameMap, parentXsd, xsd);
        structure.setModifiedDate(serviceContext.getModifiedDate(null));
        structure.setParentStructureId(parentStructureId);
        structure.setNameMap(nameMap);
        structure.setDescriptionMap(descriptionMap);
        structure.setXsd(xsd);
        this.ddmStructurePersistence.update((BaseModel)structure);
        this.syncStructureTemplatesFields(structure);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)structure.getClassName());
        List<Long> ddmStructureIds = this.getChildrenStructureIds(structure.getGroupId(), structure.getStructureId());
        indexer.reindexDDMStructures(ddmStructureIds);
        return structure;
    }

    protected void getChildrenStructureIds(List<Long> structureIds, long groupId, long parentStructureId) throws PortalException, SystemException {
        List structures = this.ddmStructurePersistence.findByG_P(groupId, parentStructureId);
        for (DDMStructure structure : structures) {
            structureIds.add(structure.getStructureId());
            this.getChildrenStructureIds(structureIds, structure.getGroupId(), structure.getStructureId());
        }
    }

    protected List<Long> getChildrenStructureIds(long groupId, long structureId) throws PortalException, SystemException {
        ArrayList<Long> structureIds = new ArrayList<Long>();
        this.getChildrenStructureIds(structureIds, groupId, structureId);
        structureIds.add(0, structureId);
        return structureIds;
    }

    protected Set<String> getElementNames(Document document) throws PortalException {
        HashSet<String> elementNames = new HashSet<String>();
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element");
        List nodes = xPathSelector.selectNodes((Object)document);
        for (Node node : nodes) {
            Element element = (Element)node;
            String name = StringUtil.toLowerCase((String)element.attributeValue("name"));
            elementNames.add(name);
        }
        return elementNames;
    }

    protected String getStructureKey(String structureKey) {
        if (structureKey != null) {
            structureKey = structureKey.trim();
            return StringUtil.toUpperCase((String)structureKey);
        }
        return "";
    }

    protected void syncStructureTemplatesFields(DDMStructure structure) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
        List templates = this.ddmTemplateLocalService.getTemplates(structure.getGroupId(), classNameId, structure.getStructureId(), "form");
        for (DDMTemplate template : templates) {
            String script = template.getScript();
            Document templateDocument = null;
            try {
                templateDocument = SAXReaderUtil.read((String)script);
            }
            catch (DocumentException de) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)de, (Throwable)de);
                continue;
            }
            Element templateRootElement = templateDocument.getRootElement();
            this.syncStructureTemplatesFields(template, templateRootElement);
            this.appendNewStructureRequiredFields(structure, templateDocument);
            try {
                script = DDMXMLUtil.formatXML((String)templateDocument.asXML());
            }
            catch (Exception exception) {
                throw new StructureXsdException();
            }
            template.setScript(script);
            this.ddmTemplatePersistence.update((BaseModel)template);
        }
    }

    protected void syncStructureTemplatesFields(DDMTemplate template, Element templateElement) throws PortalException, SystemException {
        DDMStructure structure = DDMTemplateHelperUtil.fetchStructure((DDMTemplate)template);
        List dynamicElementElements = templateElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            String dataType = dynamicElementElement.attributeValue("dataType");
            String fieldName = dynamicElementElement.attributeValue("name");
            if (Validator.isNull((String)dataType)) continue;
            if (!structure.hasField(fieldName)) {
                templateElement.remove(dynamicElementElement);
                continue;
            }
            String mode = template.getMode();
            if (mode.equals("create")) {
                boolean fieldRequired = structure.getFieldRequired(fieldName);
                List metadataElements = dynamicElementElement.elements("meta-data");
                for (Element metadataElement : metadataElements) {
                    for (Element metadataEntryElement : metadataElement.elements()) {
                        String attributeName = metadataEntryElement.attributeValue("name");
                        if (!fieldRequired || !attributeName.equals("required")) continue;
                        metadataEntryElement.setText("true");
                    }
                }
            }
            this.syncStructureTemplatesFields(template, dynamicElementElement);
        }
    }

    protected void validate(Document document) throws PortalException {
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element");
        List nodes = xPathSelector.selectNodes((Object)document);
        HashSet<String> elementNames = new HashSet<String>();
        for (Node node : nodes) {
            Element element = (Element)node;
            String name = StringUtil.toLowerCase((String)element.attributeValue("name"));
            if (name.startsWith("reserved")) {
                throw new StructureXsdException();
            }
            if (elementNames.contains(name)) {
                throw new StructureDuplicateElementException();
            }
            elementNames.add(name);
        }
    }

    protected void validate(Document parentDocument, Document childDocument) throws PortalException {
        Set<String> parentElementNames = this.getElementNames(parentDocument);
        for (String childElementName : this.getElementNames(childDocument)) {
            if (!parentElementNames.contains(childElementName)) continue;
            throw new StructureDuplicateElementException();
        }
    }

    protected void validate(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, String xsd) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null) {
            StructureDuplicateStructureKeyException sdske = new StructureDuplicateStructureKeyException();
            sdske.setStructureKey(structure.getStructureKey());
            throw sdske;
        }
        String parentXsd = "";
        DDMStructure parentStructure = this.ddmStructurePersistence.fetchByPrimaryKey(parentStructureId);
        if (parentStructure != null) {
            parentXsd = parentStructure.getCompleteXsd();
        }
        this.validate(nameMap, parentXsd, xsd);
    }

    protected void validate(Map<Locale, String> nameMap, Locale contentDefaultLocale) throws PortalException {
        String name = nameMap.get(contentDefaultLocale);
        if (Validator.isNull((String)name)) {
            throw new StructureNameException();
        }
        Object[] availableLocales = LanguageUtil.getAvailableLocales();
        if (!ArrayUtil.contains((Object[])availableLocales, (Object)contentDefaultLocale)) {
            Long companyId = CompanyThreadLocal.getCompanyId();
            LocaleException le = new LocaleException(3, "The locale " + contentDefaultLocale + " is not available in company " + companyId);
            le.setSourceAvailableLocales(new Locale[]{contentDefaultLocale});
            le.setTargetAvailableLocales((Locale[])availableLocales);
            throw le;
        }
    }

    protected void validate(Map<Locale, String> nameMap, String parentXsd, String childXsd) throws PortalException {
        try {
            Document document = SAXReaderUtil.read((String)childXsd);
            Element rootElement = document.getRootElement();
            Locale contentDefaultLocale = LocaleUtil.fromLanguageId((String)rootElement.attributeValue("default-locale"));
            this.validate(nameMap, contentDefaultLocale);
            this.validate(document);
            if (Validator.isNotNull((String)parentXsd)) {
                Document parentDocument = SAXReaderUtil.read((String)parentXsd);
                this.validate(parentDocument, document);
            }
        }
        catch (LocaleException le) {
            throw le;
        }
        catch (StructureDuplicateElementException sdee) {
            throw sdee;
        }
        catch (StructureNameException sne) {
            throw sne;
        }
        catch (StructureXsdException sxe) {
            throw sxe;
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
    }
}

