/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib;

import JOscarLib.DataContainer;
import JOscarLib.RawData;
import JOscarLib.Tlv;

public class Snac
extends DataContainer {
    private static final int SNAC_HEADER_SIZE = 10;
    private RawData familyId;
    private RawData subTypeId;
    private RawData flag0;
    private RawData flag1;
    private RawData requestId;
    private byte[] headerByteArray = new byte[10];

    private Snac() {
    }

    public Snac(int familyID, int subTypeID, int flag0, int flag1, int requestID) {
        this();
        this.familyId = new RawData(familyID, 2);
        this.subTypeId = new RawData(subTypeID, 2);
        this.flag0 = new RawData(flag0, 1);
        this.flag1 = new RawData(flag1, 1);
        this.requestId = new RawData(requestID, 4);
    }

    public Snac(byte[] array, int start) {
        this();
        byte[] famArray = new byte[2];
        byte[] subFamArray = new byte[2];
        byte[] requestArray = new byte[4];
        byte[] dataFieldArray = new byte[array.length - (start + 10)];
        System.arraycopy(array, start, famArray, 0, 2);
        this.familyId = new RawData(famArray);
        System.arraycopy(array, start + 2, subFamArray, 0, 2);
        this.subTypeId = new RawData(subFamArray);
        this.flag0 = new RawData(array[start + 4]);
        this.flag1 = new RawData(array[start + 5]);
        System.arraycopy(array, start + 6, requestArray, 0, 4);
        this.requestId = new RawData(requestArray);
        System.arraycopy(array, start + 10, dataFieldArray, 0, array.length - (start + 10));
        this.addRawDataToSnac(new RawData(dataFieldArray));
    }

    public int getFamilyId() {
        return this.familyId.getValue();
    }

    public int getSubTypeId() {
        return this.subTypeId.getValue();
    }

    public int getFlag0() {
        return this.flag0.getValue();
    }

    public int getFlag1() {
        return this.flag1.getValue();
    }

    public int getRequestId() {
        return this.requestId.getValue();
    }

    public void setRequestId(int requestId) {
        this.requestId = new RawData(requestId, 4);
        this.headerModified = true;
    }

    public void addTlvToSnac(Tlv tlv) {
        this.addDataField(tlv);
    }

    public void addRawDataToSnac(RawData rawData) {
        this.addDataField(rawData);
    }

    public byte[] getHeaderByteArray() {
        if (this.headerModified) {
            int position = 0;
            System.arraycopy(this.familyId.getByteArray(), 0, this.headerByteArray, position, this.familyId.getByteArray().length);
            System.arraycopy(this.subTypeId.getByteArray(), 0, this.headerByteArray, position += this.familyId.getByteArray().length, this.familyId.getByteArray().length);
            System.arraycopy(this.flag0.getByteArray(), 0, this.headerByteArray, position += this.familyId.getByteArray().length, this.flag0.getByteArray().length);
            System.arraycopy(this.flag1.getByteArray(), 0, this.headerByteArray, position += this.flag0.getByteArray().length, this.flag1.getByteArray().length);
            System.arraycopy(this.requestId.getByteArray(), 0, this.headerByteArray, position += this.flag1.getByteArray().length, this.requestId.getByteArray().length);
            this.headerModified = false;
        }
        return this.headerByteArray;
    }
}

