/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.impl.GeoFacetHandler;
import com.browseengine.bobo.util.BigFloatArray;
import com.browseengine.bobo.util.GeoMatchUtil;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;

public class GeoFacetFilter
extends RandomAccessFilter {
    private static final long serialVersionUID = 1L;
    private final FacetHandler<GeoFacetHandler.GeoFacetData> _handler;
    private final float _lat;
    private final float _lon;
    private final float _rad;
    private boolean _miles;

    public GeoFacetFilter(FacetHandler<GeoFacetHandler.GeoFacetData> facetHandler, float lat, float lon, float radius, boolean miles) {
        this._handler = facetHandler;
        this._lat = lat;
        this._lon = lon;
        this._rad = radius;
        this._miles = miles;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboIndexReader reader) throws IOException {
        int maxDoc = reader.maxDoc();
        GeoFacetHandler.GeoFacetData dataCache = this._handler.getFacetData(reader);
        return new GeoDocIdSet(dataCache.get_xValArray(), dataCache.get_yValArray(), dataCache.get_zValArray(), this._lat, this._lon, this._rad, maxDoc, this._miles);
    }

    public static boolean inCircle(float docX, float docY, float docZ, float targetX, float targetY, float targetZ, float radCosine) {
        if (docX == -1.0f && docY == -1.0f && docZ == -1.0f) {
            return false;
        }
        float dotProductCosine = docX * targetX + docY * targetY + docZ * targetZ;
        return radCosine <= dotProductCosine;
    }

    private static class GeoDocIdSetIterator
    extends DocIdSetIterator {
        private final BigFloatArray _xvals;
        private final BigFloatArray _yvals;
        private final BigFloatArray _zvals;
        private final float _radius;
        private final float _targetX;
        private final float _targetY;
        private final float _targetZ;
        private final float _delta;
        private final int _maxDoc;
        private int _doc;

        GeoDocIdSetIterator(BigFloatArray xvals, BigFloatArray yvals, BigFloatArray zvals, float targetX, float targetY, float targetZ, float delta, float radiusCosine, int maxdoc) {
            this._xvals = xvals;
            this._yvals = yvals;
            this._zvals = zvals;
            this._targetX = targetX;
            this._targetY = targetY;
            this._targetZ = targetZ;
            this._delta = delta;
            this._radius = radiusCosine;
            this._maxDoc = maxdoc;
            this._doc = -1;
        }

        public final int docID() {
            return this._doc;
        }

        public final int nextDoc() throws IOException {
            float x = this._targetX;
            float xu = x + this._delta;
            float xl = x - this._delta;
            float y = this._targetY;
            float yu = y + this._delta;
            float yl = y - this._delta;
            float z = this._targetZ;
            float zu = z + this._delta;
            float zl = z - this._delta;
            int docid = this._doc;
            while (docid < this._maxDoc) {
                float docZ;
                float docY;
                float docX;
                if ((docX = this._xvals.get(++docid)) > xu || docX < xl || (docY = this._yvals.get(docid)) > yu || docY < yl || (docZ = this._zvals.get(docid)) > zu || docZ < zl || !GeoFacetFilter.inCircle(docX, docY, docZ, this._targetX, this._targetY, this._targetZ, this._radius)) continue;
                this._doc = docid;
                return this._doc;
            }
            this._doc = Integer.MAX_VALUE;
            return this._doc;
        }

        public final int advance(int targetId) throws IOException {
            if (this._doc < targetId) {
                this._doc = targetId - 1;
            }
            float x = this._targetX;
            float xu = x + this._delta;
            float xl = x - this._delta;
            float y = this._targetY;
            float yu = y + this._delta;
            float yl = y - this._delta;
            float z = this._targetZ;
            float zu = z + this._delta;
            float zl = z - this._delta;
            int docid = this._doc;
            while (docid < this._maxDoc) {
                float docZ;
                float docY;
                float docX;
                if ((docX = this._xvals.get(++docid)) > xu || docX < xl || (docY = this._yvals.get(docid)) > yu || docY < yl || (docZ = this._zvals.get(docid)) > zu || docZ < zl || !GeoFacetFilter.inCircle(docX, docY, docZ, this._targetX, this._targetY, this._targetZ, this._radius)) continue;
                this._doc = docid;
                return this._doc;
            }
            this._doc = Integer.MAX_VALUE;
            return this._doc;
        }
    }

    private static final class GeoDocIdSet
    extends RandomAccessDocIdSet {
        private final BigFloatArray _xvals;
        private final BigFloatArray _yvals;
        private final BigFloatArray _zvals;
        private final float _radius;
        private final float _targetX;
        private final float _targetY;
        private final float _targetZ;
        private final float _delta;
        private final int _maxDoc;
        private boolean _miles;

        GeoDocIdSet(BigFloatArray xvals, BigFloatArray yvals, BigFloatArray zvals, float lat, float lon, float radius, int maxdoc, boolean miles) {
            this._xvals = xvals;
            this._yvals = yvals;
            this._zvals = zvals;
            this._miles = miles;
            this._radius = this._miles ? GeoMatchUtil.getMilesRadiusCosine(radius) : GeoMatchUtil.getKMRadiusCosine(radius);
            float[] coords = GeoMatchUtil.geoMatchCoordsFromDegrees(lat, lon);
            this._targetX = coords[0];
            this._targetY = coords[1];
            this._targetZ = coords[2];
            this._delta = this._miles ? radius / 3956.0f : radius / 6371.0f;
            this._maxDoc = maxdoc;
        }

        @Override
        public boolean get(int docid) {
            float docX = this._xvals.get(docid);
            float docY = this._yvals.get(docid);
            float docZ = this._zvals.get(docid);
            return GeoFacetFilter.inCircle(docX, docY, docZ, this._targetX, this._targetY, this._targetZ, this._radius);
        }

        public DocIdSetIterator iterator() {
            return new GeoDocIdSetIterator(this._xvals, this._yvals, this._zvals, this._targetX, this._targetY, this._targetZ, this._delta, this._radius, this._maxDoc);
        }
    }
}

