/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.vectorhighlight.BaseFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.FieldFragList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreOrderFragmentsBuilder
extends BaseFragmentsBuilder {
    public ScoreOrderFragmentsBuilder() {
    }

    public ScoreOrderFragmentsBuilder(String[] preTags, String[] postTags) {
        super(preTags, postTags);
    }

    public ScoreOrderFragmentsBuilder(BoundaryScanner bs) {
        super(bs);
    }

    public ScoreOrderFragmentsBuilder(String[] preTags, String[] postTags, BoundaryScanner bs) {
        super(preTags, postTags, bs);
    }

    @Override
    public List<FieldFragList.WeightedFragInfo> getWeightedFragInfoList(List<FieldFragList.WeightedFragInfo> src) {
        Collections.sort(src, new ScoreComparator());
        return src;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScoreComparator
    implements Comparator<FieldFragList.WeightedFragInfo> {
        @Override
        public int compare(FieldFragList.WeightedFragInfo o1, FieldFragList.WeightedFragInfo o2) {
            if (o1.totalBoost > o2.totalBoost) {
                return -1;
            }
            if (o1.totalBoost < o2.totalBoost) {
                return 1;
            }
            if (o1.startOffset < o2.startOffset) {
                return -1;
            }
            if (o1.startOffset > o2.startOffset) {
                return 1;
            }
            return 0;
        }
    }
}

