/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache.cluster;

import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterChannel;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEvent;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEventCoalesceComparator;
import com.liferay.portal.kernel.concurrent.CoalescedPipe;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class BasePortalCacheClusterChannel
implements PortalCacheClusterChannel,
Runnable {
    private static Log _log = LogFactoryUtil.getLog(BasePortalCacheClusterChannel.class);
    private static AtomicInteger _dispatchThreadCounter = new AtomicInteger(0);
    private volatile boolean _destroy = false;
    private final Thread _dispatchThread;
    private final CoalescedPipe<PortalCacheClusterEvent> _eventQueue;
    private final AtomicLong _sentEventCounter = new AtomicLong(0L);
    private volatile boolean _started = false;

    public BasePortalCacheClusterChannel() {
        this._dispatchThread = new Thread((Runnable)this, "PortalCacheClusterChannel dispatch thread-" + _dispatchThreadCounter.getAndIncrement());
        this._eventQueue = new CoalescedPipe<PortalCacheClusterEvent>(new PortalCacheClusterEventCoalesceComparator());
    }

    @Override
    public void destroy() {
        this._destroy = true;
        this._dispatchThread.interrupt();
    }

    public abstract void dispatchEvent(PortalCacheClusterEvent var1);

    @Override
    public long getCoalescedEventNumber() {
        return this._eventQueue.coalescedCount();
    }

    @Override
    public int getPendingEventNumber() {
        return this._eventQueue.pendingCount();
    }

    @Override
    public long getSentEventNumber() {
        return this._sentEventCounter.get();
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (true) {
                    if (this._destroy) {
                        Object[] events;
                        Object[] objectArray = events = this._eventQueue.takeSnapshot();
                        int n = events.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object event = objectArray[n2];
                            this.dispatchEvent((PortalCacheClusterEvent)event);
                            this._sentEventCounter.incrementAndGet();
                            ++n2;
                        }
                        break block4;
                    }
                    try {
                        PortalCacheClusterEvent portalCacheClusterEvent = this._eventQueue.take();
                        this.dispatchEvent(portalCacheClusterEvent);
                        this._sentEventCounter.incrementAndGet();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable t) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Please fix the unexpected throwable", t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendEvent(PortalCacheClusterEvent portalCacheClusterEvent) {
        if (!this._started) {
            BasePortalCacheClusterChannel basePortalCacheClusterChannel = this;
            synchronized (basePortalCacheClusterChannel) {
                if (!this._started) {
                    this._dispatchThread.start();
                    this._started = true;
                }
            }
        }
        if (this._destroy) {
            this.dispatchEvent(portalCacheClusterEvent);
        } else {
            try {
                this._eventQueue.put(portalCacheClusterEvent);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

