/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.Environment;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.WikiUser;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.jflex.JFlexLexer;
import org.jamwiki.parser.jflex.JFlexParserTag;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.utils.WikiLogger;

public class WikiSignatureTag
implements JFlexParserTag {
    private static final WikiLogger logger = WikiLogger.getLogger(WikiSignatureTag.class.getName());

    private String buildWikiSignature(JFlexLexer lexer, boolean includeUser, boolean includeDate) throws ParserException {
        String signature = "";
        if (includeUser) {
            signature = this.retrieveUserSignature(lexer.getParserInput());
            if (lexer.getMode() != 3) {
                try {
                    signature = JFlexParserUtil.parseFragment(lexer.getParserInput(), lexer.getParserOutput(), signature, lexer.getMode());
                }
                catch (ParserException e) {
                    logger.error("Failure while building wiki signature", e);
                    return "";
                }
            }
        }
        if (includeUser && includeDate) {
            signature = signature + " ";
        }
        if (includeDate) {
            SimpleDateFormat format = new SimpleDateFormat();
            format.applyPattern(Environment.getDatePatternValue("signature-date", true, true));
            signature = signature + format.format(new Date());
        }
        return signature;
    }

    public String parse(JFlexLexer lexer, String raw, Object ... args) throws ParserException {
        if (raw.equals("~~~")) {
            return this.buildWikiSignature(lexer, true, false);
        }
        if (raw.equals("~~~~")) {
            return this.buildWikiSignature(lexer, true, true);
        }
        if (raw.equals("~~~~~")) {
            return this.buildWikiSignature(lexer, false, true);
        }
        return raw;
    }

    private String retrieveUserSignature(ParserInput parserInput) {
        WikiUser user = parserInput.getWikiUser();
        if (user != null && !StringUtils.isBlank((String)user.getSignature())) {
            return user.getSignature();
        }
        String login = parserInput.getUserDisplay();
        String email = parserInput.getUserDisplay();
        String displayName = parserInput.getUserDisplay();
        String userId = "-1";
        if (user != null && !StringUtils.isBlank((String)user.getUsername())) {
            login = user.getUsername();
            displayName = !StringUtils.isBlank((String)user.getDisplayName()) ? user.getDisplayName() : login;
            email = user.getEmail();
            userId = Integer.toString(user.getUserId());
        }
        if (login == null || displayName == null) {
            logger.info("Signature tagged parsed without user information available, returning empty");
            return "";
        }
        MessageFormat formatter = new MessageFormat(Environment.getValue("signature-user"));
        Object[] params = new Object[]{Namespace.namespace(2).getLabel(parserInput.getVirtualWiki()) + ":" + login, Namespace.namespace(-1).getLabel(parserInput.getVirtualWiki()) + ":" + "Contributions?contributor=" + login, Namespace.namespace(3).getLabel(parserInput.getVirtualWiki()) + ":" + login, login, displayName, email != null ? email : "", userId};
        return formatter.format(params);
    }
}

