/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.BasicSpellCheckEvent;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordTokenizer;
import com.swabunga.util.VectorUtility;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class SpellChecker {
    public static final int SPELLCHECK_OK = -1;
    public static final int SPELLCHECK_CANCEL = -2;
    private Vector eventListeners = new Vector();
    private Vector dictionaries = new Vector();
    private SpellDictionary userdictionary;
    private Configuration config = Configuration.getConfiguration();
    private Vector ignoredWords = new Vector();
    private Hashtable autoReplaceWords = new Hashtable();

    public SpellChecker() {
        try {
            this.userdictionary = new SpellDictionaryHashMap();
        }
        catch (IOException iOException) {
            throw new RuntimeException("this exception should never happen because we are using null phonetic file");
        }
    }

    public SpellChecker(SpellDictionary spellDictionary) {
        this();
        this.addDictionary(spellDictionary);
    }

    public SpellChecker(SpellDictionary spellDictionary, int n) {
        this(spellDictionary);
        this.config.setInteger("SPELL_THRESHOLD", n);
    }

    public void addDictionary(SpellDictionary spellDictionary) {
        if (spellDictionary == null) {
            throw new IllegalArgumentException("dictionary must be non-null");
        }
        this.dictionaries.addElement(spellDictionary);
    }

    public void setUserDictionary(SpellDictionary spellDictionary) {
        this.userdictionary = spellDictionary;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void addSpellCheckListener(SpellCheckListener spellCheckListener) {
        this.eventListeners.addElement(spellCheckListener);
    }

    public void removeSpellCheckListener(SpellCheckListener spellCheckListener) {
        this.eventListeners.removeElement(spellCheckListener);
    }

    protected void fireSpellCheckEvent(SpellCheckEvent spellCheckEvent) {
        for (int i = this.eventListeners.size() - 1; i >= 0; --i) {
            ((SpellCheckListener)this.eventListeners.elementAt(i)).spellingError(spellCheckEvent);
        }
    }

    public void reset() {
        this.ignoredWords = new Vector();
        this.autoReplaceWords = new Hashtable();
    }

    public String checkString(String string) {
        StringWordTokenizer stringWordTokenizer = new StringWordTokenizer(string);
        this.checkSpelling(stringWordTokenizer);
        return stringWordTokenizer.getContext();
    }

    private static final boolean isDigitWord(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static final boolean isINETWord(String string) {
        String string2 = string.toLowerCase();
        return string2.startsWith("http://") || string2.startsWith("www.") || string2.startsWith("ftp://") || string2.startsWith("https://") || string2.startsWith("ftps://");
    }

    private static final boolean isUpperCaseWord(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (!Character.isLowerCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final boolean isMixedCaseWord(String string, boolean bl) {
        int n = string.length();
        boolean bl2 = Character.isUpperCase(string.charAt(0));
        if (bl && bl2 && n > 1) {
            bl2 = Character.isUpperCase(string.charAt(1));
        }
        if (bl2) {
            for (int i = string.length() - 1; i > 0; --i) {
                if (!Character.isLowerCase(string.charAt(i))) continue;
                return true;
            }
        } else {
            for (int i = string.length() - 1; i > 0; --i) {
                if (!Character.isUpperCase(string.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean fireAndHandleEvent(WordTokenizer wordTokenizer, SpellCheckEvent spellCheckEvent) {
        this.fireSpellCheckEvent(spellCheckEvent);
        String string = spellCheckEvent.getInvalidWord();
        switch (spellCheckEvent.getAction()) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                if (this.ignoredWords.contains(string)) break;
                this.ignoredWords.addElement(string);
                break;
            }
            case 2: {
                wordTokenizer.replaceWord(spellCheckEvent.getReplaceWord());
                break;
            }
            case 3: {
                String string2 = spellCheckEvent.getReplaceWord();
                if (!this.autoReplaceWords.containsKey(string)) {
                    this.autoReplaceWords.put(string, string2);
                }
                wordTokenizer.replaceWord(string2);
                break;
            }
            case 4: {
                String string3 = spellCheckEvent.getReplaceWord();
                if (!string3.equals(string)) {
                    wordTokenizer.replaceWord(string3);
                }
                this.userdictionary.addWord(string3);
                break;
            }
            case 5: {
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unhandled case.");
            }
        }
        return false;
    }

    private boolean isCorrect(String string) {
        if (this.userdictionary.isCorrect(string)) {
            return true;
        }
        Enumeration enumeration = this.dictionaries.elements();
        while (enumeration.hasMoreElements()) {
            SpellDictionary spellDictionary = (SpellDictionary)enumeration.nextElement();
            if (!spellDictionary.isCorrect(string)) continue;
            return true;
        }
        return false;
    }

    public List getSuggestions(String string, int n) {
        List list = this.userdictionary.getSuggestions(string, n);
        Enumeration enumeration = this.dictionaries.elements();
        while (enumeration.hasMoreElements()) {
            SpellDictionary spellDictionary = (SpellDictionary)enumeration.nextElement();
            VectorUtility.addAll(list, spellDictionary.getSuggestions(string, n), false);
        }
        return list;
    }

    public final int checkSpelling(WordTokenizer wordTokenizer) {
        int n = 0;
        boolean bl = false;
        while (wordTokenizer.hasMoreWords() && !bl) {
            Object object;
            String string = wordTokenizer.nextWord();
            if (!this.isCorrect(string)) {
                if (this.config.getBoolean("SPELL_IGNOREMIXEDCASE") && SpellChecker.isMixedCaseWord(string, wordTokenizer.isNewSentence()) || this.config.getBoolean("SPELL_IGNOREUPPERCASE") && SpellChecker.isUpperCaseWord(string) || this.config.getBoolean("SPELL_IGNOREDIGITWORDS") && SpellChecker.isDigitWord(string) || this.config.getBoolean("SPELL_IGNOREINTERNETADDRESS") && SpellChecker.isINETWord(string) || this.ignoredWords.contains(string)) continue;
                ++n;
                if (this.autoReplaceWords.containsKey(string)) {
                    wordTokenizer.replaceWord((String)this.autoReplaceWords.get(string));
                    continue;
                }
                object = new BasicSpellCheckEvent(string, this.getSuggestions(string, this.config.getInteger("SPELL_THRESHOLD")), wordTokenizer);
                bl = this.fireAndHandleEvent(wordTokenizer, (SpellCheckEvent)object);
                continue;
            }
            if (this.config.getBoolean("SPELL_IGNORESENTENCECAPTILIZATION") || !wordTokenizer.isNewSentence() || !Character.isLowerCase(string.charAt(0))) continue;
            ++n;
            object = new StringBuffer(string);
            ((StringBuffer)object).setCharAt(0, Character.toUpperCase(string.charAt(0)));
            Vector<Word> vector = new Vector<Word>();
            vector.addElement(new Word(((StringBuffer)object).toString(), 0));
            BasicSpellCheckEvent basicSpellCheckEvent = new BasicSpellCheckEvent(string, vector, wordTokenizer);
            bl = this.fireAndHandleEvent(wordTokenizer, basicSpellCheckEvent);
        }
        if (bl) {
            return -2;
        }
        if (n == 0) {
            return -1;
        }
        return n;
    }
}

