/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import jodd.bean.BeanUtil;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.Getter;
import jodd.introspector.Introspector;
import jodd.introspector.PropertyDescriptor;
import jodd.introspector.Setter;

class BeanProperty {
    final String fullName;
    final Introspector introspector = BeanUtil.getBeanUtilBean().getIntrospector();
    Object bean;
    private ClassDescriptor cd;
    String name;
    boolean last;
    boolean first;
    final boolean forced;
    final boolean declared;
    final boolean silent;
    private boolean updateProperty = true;
    private PropertyDescriptor propertyDescriptor;
    String index;

    BeanProperty(Object bean, String propertyName, boolean declared, boolean forced) {
        this(bean, propertyName, declared, forced, false);
    }

    BeanProperty(Object bean, String propertyName, boolean declared, boolean forced, boolean silent) {
        this.setName(propertyName);
        this.setBean(bean);
        this.last = true;
        this.first = true;
        this.forced = forced;
        this.declared = declared;
        this.silent = silent;
        this.fullName = bean.getClass().getSimpleName() + '#' + propertyName;
    }

    public void setName(String name) {
        this.name = name;
        this.updateProperty = true;
    }

    public void setBean(Object bean) {
        this.bean = bean;
        this.cd = bean == null ? null : this.introspector.lookup(bean.getClass());
        this.first = false;
        this.updateProperty = true;
    }

    private void loadPropertyDescriptor() {
        if (this.updateProperty) {
            this.propertyDescriptor = this.cd == null ? null : this.cd.getPropertyDescriptor(this.name, true);
            this.updateProperty = false;
        }
    }

    public Getter getGetter(boolean declared) {
        this.loadPropertyDescriptor();
        return this.propertyDescriptor != null ? this.propertyDescriptor.getGetter(declared) : null;
    }

    public Setter getSetter(boolean declared) {
        this.loadPropertyDescriptor();
        return this.propertyDescriptor != null ? this.propertyDescriptor.getSetter(declared) : null;
    }

    public boolean isMap() {
        return this.cd != null && this.cd.isMap();
    }

    public String toString() {
        return this.fullName + " (" + (this.bean != null ? this.bean.getClass().getSimpleName() : "?") + '#' + this.name + ", forced=" + this.forced + ')';
    }
}

