/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.io.delta;

import com.liferay.io.delta.ByteChannelReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class Patcher {
    private static final int _NATIVE_TRANSFER_THRESHOLD = 1000000;
    private final ByteBuffer _transferByteBuffer = ByteBuffer.allocate(1000000);

    public void patch(FileChannel originalFileChannel, WritableByteChannel patchedWritableByteChannel, ByteChannelReader deltaByteChannelReader) throws IOException {
        byte key;
        deltaByteChannelReader.resizeBuffer(5);
        ByteBuffer deltaByteBuffer = deltaByteChannelReader.getBuffer();
        deltaByteChannelReader.ensureData(5);
        if (1 != deltaByteBuffer.get()) {
            throw new IOException("Unknown protocol version");
        }
        int blockLength = deltaByteBuffer.getInt();
        deltaByteChannelReader.resizeBuffer(blockLength * 16 + 5);
        deltaByteBuffer = deltaByteChannelReader.getBuffer();
        while (true) {
            deltaByteChannelReader.ensureData(1);
            key = deltaByteBuffer.get();
            if (key == 3) {
                deltaByteChannelReader.ensureData(9);
                int firstBlockNumber = deltaByteBuffer.getInt();
                int lastBlockNumber = deltaByteBuffer.getInt();
                long position = (long)firstBlockNumber * (long)blockLength;
                long length = (long)(lastBlockNumber - firstBlockNumber + 1) * (long)blockLength;
                this.transfer(originalFileChannel, patchedWritableByteChannel, position, length);
                continue;
            }
            if (key == 2) {
                deltaByteChannelReader.ensureData(4);
                int blockNumber = deltaByteBuffer.getInt();
                long position = (long)blockNumber * (long)blockLength;
                this.transfer(originalFileChannel, patchedWritableByteChannel, position, blockLength);
                continue;
            }
            if (key != 1) break;
            deltaByteChannelReader.ensureData(4);
            int length = deltaByteBuffer.getInt();
            deltaByteChannelReader.ensureData(length);
            int oldLimit = deltaByteBuffer.limit();
            deltaByteBuffer.limit(deltaByteBuffer.position() + length);
            patchedWritableByteChannel.write(deltaByteBuffer);
            deltaByteBuffer.limit(oldLimit);
        }
        if (key == 0) {
            return;
        }
        throw new IOException("Invalid key");
    }

    protected void transfer(FileChannel source, WritableByteChannel destination, long position, long length) throws IOException {
        if (length > 1000000L) {
            source.transferTo(position, length, destination);
        } else {
            this._transferByteBuffer.clear();
            this._transferByteBuffer.limit((int)length);
            source.read(this._transferByteBuffer, position);
            this._transferByteBuffer.flip();
            destination.write(this._transferByteBuffer);
        }
    }
}

