/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similar;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimilarityQueries {
    private SimilarityQueries() {
    }

    public static Query formSimilarQuery(String body, Analyzer a, String field, Set<?> stop) throws IOException {
        TokenStream ts = a.reusableTokenStream(field, (Reader)new StringReader(body));
        CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        BooleanQuery tmp = new BooleanQuery();
        HashSet<String> already = new HashSet<String>();
        while (ts.incrementToken()) {
            String word = termAtt.toString();
            if (stop != null && stop.contains(word) || !already.add(word)) continue;
            TermQuery tq = new TermQuery(new Term(field, word));
            try {
                tmp.add((Query)tq, BooleanClause.Occur.SHOULD);
            }
            catch (BooleanQuery.TooManyClauses too) {
                break;
            }
        }
        return tmp;
    }
}

