/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jodd.mail.EmailMessage;
import jodd.util.StringPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonEmail {
    public static final String X_PRIORITY = "X-Priority";
    public static final int PRIORITY_HIGHEST = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 3;
    public static final int PRIORITY_LOW = 4;
    public static final int PRIORITY_LOWEST = 5;
    protected String from;
    protected String[] to = StringPool.EMPTY_ARRAY;
    protected String[] replyTo = StringPool.EMPTY_ARRAY;
    protected String[] cc = StringPool.EMPTY_ARRAY;
    protected String[] bcc = StringPool.EMPTY_ARRAY;
    protected String subject;
    protected LinkedList<EmailMessage> messages = new LinkedList();
    protected Map<String, String> headers;
    protected Date sentDate;

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setTo(String ... tos) {
        if (tos == null) {
            tos = StringPool.EMPTY_ARRAY;
        }
        this.to = tos;
    }

    public String[] getTo() {
        return this.to;
    }

    public void setReplyTo(String ... replyTo) {
        if (replyTo == null) {
            replyTo = StringPool.EMPTY_ARRAY;
        }
        this.replyTo = replyTo;
    }

    public String[] getReplyTo() {
        return this.replyTo;
    }

    public void setCc(String ... ccs) {
        if (ccs == null) {
            ccs = StringPool.EMPTY_ARRAY;
        }
        this.cc = ccs;
    }

    public String[] getCc() {
        return this.cc;
    }

    public void setBcc(String ... bccs) {
        if (bccs == null) {
            bccs = StringPool.EMPTY_ARRAY;
        }
        this.bcc = bccs;
    }

    public String[] getBcc() {
        return this.bcc;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public LinkedList<EmailMessage> getAllMessages() {
        return this.messages;
    }

    public void addMessage(EmailMessage emailMessage) {
        this.messages.add(emailMessage);
    }

    public void addMessage(String text, String mimeType, String encoding) {
        this.messages.add(new EmailMessage(text, mimeType, encoding));
    }

    public void addMessage(String text, String mimeType) {
        this.messages.add(new EmailMessage(text, mimeType));
    }

    protected Map<String, String> getAllHeaders() {
        return this.headers;
    }

    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    public void setPriority(int priority) {
        this.setHeader(X_PRIORITY, String.valueOf(priority));
    }

    public int getPriority() {
        if (this.headers == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.headers.get(X_PRIORITY));
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    public void setSentDate(Date date) {
        this.sentDate = date;
    }

    public Date getSentDate() {
        return this.sentDate;
    }
}

