/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.cluster.BaseReceiver;
import com.liferay.portal.cluster.ClusterBase;
import com.liferay.portal.cluster.ClusterForwardReceiver;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.cluster.messaging.ClusterForwardMessageListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jgroups.JChannel;

@DoPrivileged
public class ClusterLinkImpl
extends ClusterBase
implements ClusterLink {
    private static Log _log = LogFactoryUtil.getLog(ClusterLinkImpl.class);
    private int _channelCount;
    private ClusterForwardMessageListener _clusterForwardMessageListener;
    private List<org.jgroups.Address> _localTransportAddresses;
    private List<JChannel> _transportChannels;

    @Override
    public void destroy() {
        if (!this.isEnabled()) {
            return;
        }
        for (JChannel jChannel : this._transportChannels) {
            jChannel.close();
        }
    }

    public InetAddress getBindInetAddress() {
        return bindInetAddress;
    }

    public List<Address> getLocalTransportAddresses() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        ArrayList<Address> addresses = new ArrayList<Address>(this._localTransportAddresses.size());
        for (org.jgroups.Address address : this._localTransportAddresses) {
            addresses.add(new AddressImpl(address));
        }
        return addresses;
    }

    public List<Address> getTransportAddresses(Priority priority) {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        JChannel jChannel = this.getChannel(priority);
        return this.getAddresses(jChannel);
    }

    public void initialize() {
        if (!this.isEnabled()) {
            return;
        }
        for (JChannel jChannel : this._transportChannels) {
            BaseReceiver baseReceiver = (BaseReceiver)jChannel.getReceiver();
            baseReceiver.openLatch();
        }
    }

    public void sendMulticastMessage(Message message, Priority priority) {
        if (!this.isEnabled()) {
            return;
        }
        JChannel jChannel = this.getChannel(priority);
        try {
            this.sendJGroupsMessage(jChannel, null, (Serializable)message);
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to send multicast message " + message), (Throwable)e2);
        }
    }

    public void sendUnicastMessage(Address address, Message message, Priority priority) {
        if (!this.isEnabled()) {
            return;
        }
        org.jgroups.Address jGroupsAddress = (org.jgroups.Address)address.getRealAddress();
        JChannel jChannel = this.getChannel(priority);
        try {
            this.sendJGroupsMessage(jChannel, jGroupsAddress, (Serializable)message);
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to send unicast message " + message), (Throwable)e2);
        }
    }

    public void setClusterForwardMessageListener(ClusterForwardMessageListener clusterForwardMessageListener) {
        this._clusterForwardMessageListener = clusterForwardMessageListener;
    }

    protected JChannel getChannel(Priority priority) {
        int channelIndex = priority.ordinal() * this._channelCount / MAX_CHANNEL_COUNT;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Select channel number " + channelIndex + " for priority " + priority));
        }
        return this._transportChannels.get(channelIndex);
    }

    @Override
    protected void initChannels() throws Exception {
        Properties channelNameProperties = PropsUtil.getProperties("cluster.link.channel.name.transport", true);
        Properties transportProperties = PropsUtil.getProperties("cluster.link.channel.properties.transport", true);
        this._channelCount = transportProperties.size();
        if (this._channelCount <= 0 || this._channelCount > MAX_CHANNEL_COUNT) {
            throw new IllegalArgumentException("Channel count must be between 1 and " + MAX_CHANNEL_COUNT);
        }
        this._localTransportAddresses = new ArrayList<org.jgroups.Address>(this._channelCount);
        this._transportChannels = new ArrayList<JChannel>(this._channelCount);
        ArrayList<String> keys = new ArrayList<String>(this._channelCount);
        for (Object key : transportProperties.keySet()) {
            keys.add((String)key);
        }
        Collections.sort(keys);
        for (String customName : keys) {
            String channelName = channelNameProperties.getProperty(customName);
            String value = transportProperties.getProperty(customName);
            if (Validator.isNull((String)value) || Validator.isNull((String)channelName)) continue;
            JChannel jChannel = this.createJChannel(value, new ClusterForwardReceiver(this._localTransportAddresses, this._clusterForwardMessageListener), channelName);
            this._localTransportAddresses.add(jChannel.getAddress());
            this._transportChannels.add(jChannel);
        }
    }
}

