/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.portal.image.ImageMagickImpl;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageMagick;
import com.liferay.portal.kernel.image.ImageTool;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncoder;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.imageio.ImageIO;
import javax.media.jai.RenderedImageAdapter;
import net.jmge.gif.Gif89Encoder;
import org.im4java.core.IMOperation;

@DoPrivileged
public class ImageToolImpl
implements ImageTool {
    private static Log _log = LogFactoryUtil.getLog(ImageToolImpl.class);
    private static ImageTool _instance = new ImageToolImpl();
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private static ImageMagick _imageMagick;
    private Image _defaultCompanyLogo;
    private Image _defaultOrganizationLogo;
    private Image _defaultSpacer;
    private Image _defaultUserFemalePortrait;
    private Image _defaultUserMalePortrait;

    public static ImageTool getInstance() {
        return _instance;
    }

    public void afterPropertiesSet() {
        InputStream is;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.spacer"));
            if (is == null) {
                _log.error((Object)"Default spacer is not available");
            }
            this._defaultSpacer = this.getImage(is);
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to configure the default spacer: " + e2.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.company.logo"));
            if (is == null) {
                _log.error((Object)"Default company logo is not available");
            }
            this._defaultCompanyLogo = this.getImage(is);
        }
        catch (Exception e3) {
            _log.error((Object)("Unable to configure the default company logo: " + e3.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.organization.logo"));
            if (is == null) {
                _log.error((Object)"Default organization logo is not available");
            }
            this._defaultOrganizationLogo = this.getImage(is);
        }
        catch (Exception e4) {
            _log.error((Object)("Unable to configure the default organization logo: " + e4.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.female.portrait"));
            if (is == null) {
                _log.error((Object)"Default user female portrait is not available");
            }
            this._defaultUserFemalePortrait = this.getImage(is);
        }
        catch (Exception e5) {
            _log.error((Object)("Unable to configure the default user female portrait: " + e5.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.male.portrait"));
            if (is == null) {
                _log.error((Object)"Default user male portrait is not available");
            }
            this._defaultUserMalePortrait = this.getImage(is);
        }
        catch (Exception e6) {
            _log.error((Object)("Unable to configure the default user male portrait: " + e6.getMessage()));
        }
    }

    public Future<RenderedImage> convertCMYKtoRGB(byte[] bytes, String type) {
        ImageMagick imageMagick = this.getImageMagick();
        if (!imageMagick.isEnabled()) {
            return null;
        }
        File inputFile = _fileUtil.createTempFile(type);
        File outputFile = _fileUtil.createTempFile(type);
        try {
            _fileUtil.write(inputFile, bytes);
            IMOperation imOperation = new IMOperation();
            imOperation.addRawArgs(new String[]{"-format", "%[colorspace]"});
            imOperation.addImage(new String[]{inputFile.getPath()});
            String[] output = imageMagick.identify((List)imOperation.getCmdArgs());
            if (output.length == 1 && StringUtil.equalsIgnoreCase((String)output[0], (String)"CMYK")) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"The image is in the CMYK colorspace");
                }
                imOperation = new IMOperation();
                imOperation.addRawArgs(new String[]{"-colorspace", "RGB"});
                imOperation.addImage(new String[]{inputFile.getPath()});
                imOperation.addImage(new String[]{outputFile.getPath()});
                Future future = imageMagick.convert((List)imOperation.getCmdArgs());
                RenderedImageFuture renderedImageFuture = new RenderedImageFuture(future, outputFile, type);
                return renderedImageFuture;
            }
        }
        catch (Exception e2) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        finally {
            _fileUtil.delete(inputFile);
            _fileUtil.delete(outputFile);
        }
        return null;
    }

    public BufferedImage convertImageType(BufferedImage sourceImage, int type) {
        BufferedImage targetImage = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), type);
        Graphics2D graphics = targetImage.createGraphics();
        graphics.drawRenderedImage(sourceImage, null);
        graphics.dispose();
        return targetImage;
    }

    public void encodeGIF(RenderedImage renderedImage, OutputStream os) throws IOException {
        if (JavaDetector.isJDK6()) {
            ImageIO.write(renderedImage, "gif", os);
        } else {
            BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
            if (!(bufferedImage.getColorModel() instanceof IndexColorModel)) {
                bufferedImage = this.convertImageType(bufferedImage, 13);
            }
            Gif89Encoder encoder = new Gif89Encoder((java.awt.Image)bufferedImage);
            encoder.encode(os);
        }
    }

    public void encodeWBMP(RenderedImage renderedImage, OutputStream os) throws IOException {
        BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
        SampleModel sampleModel = bufferedImage.getSampleModel();
        int type = sampleModel.getDataType();
        if (bufferedImage.getType() != 12 || type < 0 || type > 3 || sampleModel.getNumBands() != 1 || sampleModel.getSampleSize(0) != 1) {
            BufferedImage binaryImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12);
            Graphics graphics = binaryImage.getGraphics();
            graphics.drawImage(bufferedImage, 0, 0, null);
            renderedImage = binaryImage;
        }
        if (!ImageIO.write(renderedImage, "wbmp", os)) {
            os.write(0);
            os.write(0);
            os.write(this.toMultiByte(bufferedImage.getWidth()));
            os.write(this.toMultiByte(bufferedImage.getHeight()));
            DataBuffer dataBuffer = bufferedImage.getData().getDataBuffer();
            int size = dataBuffer.getSize();
            int i2 = 0;
            while (i2 < size) {
                os.write((byte)dataBuffer.getElem(i2));
                ++i2;
            }
        }
    }

    public BufferedImage getBufferedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        RenderedImageAdapter adapter = new RenderedImageAdapter(renderedImage);
        return adapter.getAsBufferedImage();
    }

    public byte[] getBytes(RenderedImage renderedImage, String contentType) throws IOException {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        this.write(renderedImage, contentType, (OutputStream)baos);
        return baos.toByteArray();
    }

    public Image getDefaultCompanyLogo() {
        return this._defaultCompanyLogo;
    }

    public Image getDefaultOrganizationLogo() {
        return this._defaultOrganizationLogo;
    }

    public Image getDefaultSpacer() {
        return this._defaultSpacer;
    }

    public Image getDefaultUserFemalePortrait() {
        return this._defaultUserFemalePortrait;
    }

    public Image getDefaultUserMalePortrait() {
        return this._defaultUserMalePortrait;
    }

    public Image getImage(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        ImageBag imageBag = this.read(bytes);
        RenderedImage renderedImage = imageBag.getRenderedImage();
        if (renderedImage == null) {
            throw new IOException("Unable to decode image");
        }
        String type = imageBag.getType();
        int height = renderedImage.getHeight();
        int width = renderedImage.getWidth();
        int size = bytes.length;
        ImageImpl image = new ImageImpl();
        image.setTextObj(bytes);
        image.setType(type);
        image.setHeight(height);
        image.setWidth(width);
        image.setSize(size);
        return image;
    }

    public Image getImage(File file) throws IOException {
        byte[] bytes = _fileUtil.getBytes(file);
        return this.getImage(bytes);
    }

    public Image getImage(InputStream is) throws IOException {
        byte[] bytes = _fileUtil.getBytes(is, -1, true);
        return this.getImage(bytes);
    }

    public Image getImage(InputStream is, boolean cleanUpStream) throws IOException {
        byte[] bytes = _fileUtil.getBytes(is, -1, cleanUpStream);
        return this.getImage(bytes);
    }

    public boolean isNullOrDefaultSpacer(byte[] bytes) {
        return ArrayUtil.isEmpty((byte[])bytes) || Arrays.equals(bytes, this.getDefaultSpacer().getTextObj());
    }

    public ImageBag read(byte[] bytes) {
        RenderedImage renderedImage = null;
        String type = "na";
        Enumeration enu = ImageCodec.getCodecs();
        while (enu.hasMoreElements()) {
            ImageCodec codec = (ImageCodec)enu.nextElement();
            if (!codec.isFormatRecognized(bytes)) continue;
            type = codec.getFormatName();
            renderedImage = this.read(bytes, type);
            break;
        }
        if (type.equals("jpeg")) {
            type = "jpg";
        }
        return new ImageBag(renderedImage, type);
    }

    public ImageBag read(File file) throws IOException {
        return this.read(_fileUtil.getBytes(file));
    }

    public ImageBag read(InputStream inputStream) throws IOException {
        return this.read(_fileUtil.getBytes(inputStream));
    }

    public RenderedImage scale(RenderedImage renderedImage, int width) {
        if (width <= 0) {
            return renderedImage;
        }
        int imageHeight = renderedImage.getHeight();
        int imageWidth = renderedImage.getWidth();
        double factor = (double)width / (double)imageWidth;
        int scaledHeight = (int)Math.round(factor * (double)imageHeight);
        int scaledWidth = width;
        return this.doScale(renderedImage, scaledHeight, scaledWidth);
    }

    public RenderedImage scale(RenderedImage renderedImage, int maxHeight, int maxWidth) {
        int imageHeight = renderedImage.getHeight();
        int imageWidth = renderedImage.getWidth();
        if (maxHeight == 0) {
            maxHeight = imageHeight;
        }
        if (maxWidth == 0) {
            maxWidth = imageWidth;
        }
        if (imageHeight <= maxHeight && imageWidth <= maxWidth) {
            return renderedImage;
        }
        double factor = Math.min((double)maxHeight / (double)imageHeight, (double)maxWidth / (double)imageWidth);
        int scaledHeight = Math.max(1, (int)Math.round(factor * (double)imageHeight));
        int scaledWidth = Math.max(1, (int)Math.round(factor * (double)imageWidth));
        return this.doScale(renderedImage, scaledHeight, scaledWidth);
    }

    public void write(RenderedImage renderedImage, String contentType, OutputStream os) throws IOException {
        if (contentType.contains("bmp")) {
            ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"bmp", (OutputStream)os, null);
            imageEncoder.encode(renderedImage);
        } else if (contentType.contains("gif")) {
            this.encodeGIF(renderedImage, os);
        } else if (contentType.contains("jpg") || contentType.contains("jpeg")) {
            ImageIO.write(renderedImage, "jpeg", os);
        } else if (contentType.contains("png")) {
            ImageIO.write(renderedImage, "png", os);
        } else if (contentType.contains("tiff") || contentType.contains("tif")) {
            ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"tiff", (OutputStream)os, null);
            imageEncoder.encode(renderedImage);
        }
    }

    protected RenderedImage doScale(RenderedImage renderedImage, int scaledHeight, int scaledWidth) {
        BufferedImage originalBufferedImage = this.getBufferedImage(renderedImage);
        ColorModel originalColorModel = originalBufferedImage.getColorModel();
        Graphics2D originalGraphics2D = originalBufferedImage.createGraphics();
        if (originalColorModel.hasAlpha()) {
            originalGraphics2D.setComposite(AlphaComposite.Src);
        }
        GraphicsConfiguration originalGraphicsConfiguration = originalGraphics2D.getDeviceConfiguration();
        BufferedImage scaledBufferedImage = originalGraphicsConfiguration.createCompatibleImage(scaledWidth, scaledHeight, originalBufferedImage.getTransparency());
        Graphics scaledGraphics = scaledBufferedImage.getGraphics();
        scaledGraphics.drawImage(originalBufferedImage.getScaledInstance(scaledWidth, scaledHeight, 4), 0, 0, null);
        originalGraphics2D.dispose();
        return scaledBufferedImage;
    }

    protected ImageMagick getImageMagick() {
        if (_imageMagick == null) {
            _imageMagick = ImageMagickImpl.getInstance();
            _imageMagick.reset();
        }
        return _imageMagick;
    }

    protected RenderedImage read(byte[] bytes, String type) {
        RenderedImage renderedImage;
        block3: {
            renderedImage = null;
            try {
                if (type.equals("jpg")) {
                    type = "jpeg";
                }
                ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)type, (InputStream)new UnsyncByteArrayInputStream(bytes), null);
                renderedImage = imageDecoder.decodeAsRenderedImage();
            }
            catch (IOException ioe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)(String.valueOf(type) + ": " + ioe.getMessage()));
            }
        }
        return renderedImage;
    }

    protected byte[] toMultiByte(int intValue) {
        int numBits = 32;
        int mask = Integer.MIN_VALUE;
        while (mask != 0 && (intValue & mask) == 0) {
            --numBits;
            mask >>>= 1;
        }
        int numBitsLeft = numBits;
        byte[] multiBytes = new byte[(numBitsLeft + 6) / 7];
        int maxIndex = multiBytes.length - 1;
        int b2 = 0;
        while (b2 <= maxIndex) {
            multiBytes[b2] = (byte)(intValue >>> (maxIndex - b2) * 7 & 0x7F);
            if (b2 != maxIndex) {
                int n = b2;
                multiBytes[n] = (byte)(multiBytes[n] | 0xFFFFFF80);
            }
            ++b2;
        }
        return multiBytes;
    }

    private ImageToolImpl() {
        ImageIO.setUseCache(PropsValues.IMAGE_IO_USE_DISK_CACHE);
    }

    private class RenderedImageFuture
    implements Future<RenderedImage> {
        private final Future<?> _future;
        private final File _outputFile;
        private final String _type;

        public RenderedImageFuture(Future<?> future, File outputFile, String type) {
            this._future = future;
            this._outputFile = outputFile;
            this._type = type;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this._future.isCancelled() || this._future.isDone()) {
                return false;
            }
            this._future.cancel(true);
            return true;
        }

        @Override
        public RenderedImage get() throws ExecutionException, InterruptedException {
            this._future.get();
            byte[] bytes = new byte[]{};
            try {
                bytes = _fileUtil.getBytes(this._outputFile);
            }
            catch (IOException ioe) {
                throw new ExecutionException(ioe);
            }
            ImageBag imageBag = ImageToolImpl.this.read(bytes);
            return imageBag.getRenderedImage();
        }

        @Override
        public RenderedImage get(long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
            this._future.get(timeout, timeUnit);
            byte[] bytes = new byte[]{};
            try {
                bytes = _fileUtil.getBytes(this._outputFile);
            }
            catch (IOException ioe) {
                throw new ExecutionException(ioe);
            }
            ImageBag imageBag = ImageToolImpl.this.read(bytes);
            return imageBag.getRenderedImage();
        }

        @Override
        public boolean isCancelled() {
            return this._future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this._future.isDone();
        }
    }
}

