/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONIncludesManagerUtil;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jodd.bean.BeanCopy;
import jodd.bean.BeanUtil;
import jodd.servlet.ServletUtil;
import jodd.util.NameValue;

public class JSONWebServiceInvokerAction
implements JSONWebServiceAction {
    private String _command;
    private List<String> _includes;
    private HttpServletRequest _request;
    private List<Statement> _statements = new ArrayList<Statement>();

    public JSONWebServiceInvokerAction(HttpServletRequest request) {
        this._request = request;
        this._command = request.getParameter("cmd");
        if (this._command == null) {
            try {
                this._command = ServletUtil.readRequestBody((HttpServletRequest)request);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping() {
        return null;
    }

    public Object invoke() throws Exception {
        Object command = JSONFactoryUtil.looseDeserializeSafe((String)this._command);
        ArrayList<Object> list = null;
        boolean batchMode = false;
        if (command instanceof List) {
            list = (ArrayList<Object>)command;
            batchMode = true;
        } else if (command instanceof Map) {
            list = new ArrayList<Object>(1);
            list.add(command);
            batchMode = false;
        } else {
            throw new IllegalArgumentException();
        }
        int i2 = 0;
        while (i2 < list.size()) {
            Map map = (Map)list.get(i2);
            if (map.isEmpty()) {
                throw new IllegalArgumentException();
            }
            Set entrySet = map.entrySet();
            Iterator iterator = entrySet.iterator();
            Map.Entry entry = iterator.next();
            Statement statement = this._parseStatement(null, (String)entry.getKey(), (Map)entry.getValue());
            Object result = this._executeStatement(statement);
            list.set(i2, result);
            ++i2;
        }
        ArrayList<Object> result = null;
        result = !batchMode ? list.get(0) : list;
        return new InvokerResult(result);
    }

    private void _addInclude(Statement statement, String name) {
        if (this._includes == null) {
            this._includes = new ArrayList<String>();
        }
        StringBuilder sb = new StringBuilder();
        while (statement._parentStatement != null) {
            String statementName = statement.getName().substring(1);
            sb.insert(0, String.valueOf(statementName) + ".");
            statement = statement._parentStatement;
        }
        sb.append(name);
        this._includes.add(sb.toString());
    }

    private Object _addVariableStatement(Statement variableStatement, Object result) throws Exception {
        Statement statement = variableStatement.getParentStatement();
        result = this._populateFlags(statement, result);
        String name = variableStatement.getName();
        Object variableResult = this._executeStatement(variableStatement);
        Map<String, Object> map = this._convertObjectToMap(statement, result, null);
        if (!variableStatement.isInner()) {
            map.put(name.substring(1), variableResult);
            return map;
        }
        int index = name.indexOf(".$");
        String innerObjectName = name.substring(0, index);
        if (innerObjectName.contains(".")) {
            throw new IllegalArgumentException("Inner properties with more than 1 level are not supported");
        }
        Object innerObject = map.get(innerObjectName);
        String innerPropertyName = name.substring(index + 2);
        if (innerObject instanceof List) {
            List innerList = (List)innerObject;
            ArrayList<Map<String, Object>> newInnerList = new ArrayList<Map<String, Object>>(innerList.size());
            for (Object innerListElement : innerList) {
                Map<String, Object> newInnerListElement = this._convertObjectToMap(statement, innerListElement, innerObjectName);
                newInnerListElement.put(innerPropertyName, variableResult);
                newInnerList.add(newInnerListElement);
            }
            map.put(innerObjectName, newInnerList);
        } else {
            Map<String, Object> innerMap = this._convertObjectToMap(statement, innerObject, innerObjectName);
            innerMap.put(innerPropertyName, variableResult);
            map.put(innerObjectName, innerMap);
        }
        return map;
    }

    private Object _addVariableStatementList(Statement variableStatement, List<Object> resultList, List<Object> results) throws Exception {
        for (Object object : resultList) {
            Object value;
            List<Object> listObject = this._convertObjectToList(object);
            if (listObject != null) {
                value = this._addVariableStatementList(variableStatement, listObject, results);
                results.add(value);
                continue;
            }
            value = this._addVariableStatement(variableStatement, object);
            results.add(value);
        }
        return results;
    }

    private void _checkJSONSerializerIncludeName(String includeName) {
        if (includeName.contains("*")) {
            throw new IllegalArgumentException(String.valueOf(includeName) + " has special characters");
        }
    }

    private List<Object> _convertObjectToList(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            return (List)object;
        }
        if (object instanceof Iterable) {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterable iterable = (Iterable)object;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            return list;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        Class<?> componentType = clazz.getComponentType();
        if (!componentType.isPrimitive()) {
            return ListUtil.toList((Object[])((Object[])object));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < Array.getLength(object)) {
            list.add(Array.get(object, i2));
            ++i2;
        }
        return list;
    }

    private Map<String, Object> _convertObjectToMap(Statement statement, Object object, String prefix) {
        String[] includes;
        if (object instanceof Map) {
            return object;
        }
        Class<?> clazz = object.getClass();
        HashMap destinationMap = new HashMap();
        BeanCopy beanCopy = BeanCopy.beans((Object)object, destinationMap);
        beanCopy.exclude(JSONIncludesManagerUtil.lookupExcludes(clazz));
        beanCopy.copy();
        object = destinationMap;
        String[] stringArray = includes = JSONIncludesManagerUtil.lookupIncludes(clazz);
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            String include = stringArray[n2];
            if (Validator.isNotNull((String)prefix)) {
                include = String.valueOf(prefix) + "." + include;
            }
            this._addInclude(statement, include);
            ++n2;
        }
        return object;
    }

    private Object _executeStatement(Statement statement) throws Exception {
        JSONWebServiceAction jsonWebServiceAction = JSONWebServiceActionsManagerUtil.getJSONWebServiceAction((HttpServletRequest)this._request, (String)statement.getMethod(), null, statement.getParameterMap());
        Object result = jsonWebServiceAction.invoke();
        result = this._filterResult(statement, result);
        List<Statement> variableStatements = statement.getVariableStatements();
        if (variableStatements == null) {
            return result;
        }
        for (Statement variableStatement : variableStatements) {
            List<Object> resultList;
            boolean innerStatement = variableStatement.isInner();
            if (innerStatement) {
                result = variableStatement.push(result);
            }
            if ((resultList = this._convertObjectToList(result)) != null) {
                result = this._addVariableStatementList(variableStatement, resultList, new ArrayList<Object>());
                variableStatement.setExecuted(true);
                if (!innerStatement) continue;
                result = variableStatement.pop(result);
                continue;
            }
            if (innerStatement) {
                result = variableStatement.pop(result);
            }
            result = this._addVariableStatement(variableStatement, result);
            variableStatement.setExecuted(true);
        }
        return result;
    }

    private Object _filterResult(Statement statement, Object result) {
        List<Object> resultList = this._convertObjectToList(result);
        result = resultList != null ? this._filterResultList(statement, resultList, new ArrayList<Object>()) : this._filterResultObject(statement, result);
        return result;
    }

    private Object _filterResultList(Statement statement, List<Object> resultList, List<Object> results) {
        for (Object object : resultList) {
            Object value = this._filterResultObject(statement, object);
            results.add(value);
        }
        return results;
    }

    private Object _filterResultObject(Statement statement, Object result) {
        if (result == null) {
            return result;
        }
        String[] whitelist = statement.getWhitelist();
        if (whitelist == null) {
            return result;
        }
        Map<String, Object> map = this._convertObjectToMap(statement, result, null);
        HashMap<String, Object> whitelistMap = new HashMap<String, Object>(whitelist.length);
        String[] stringArray = whitelist;
        int n = whitelist.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Object value = map.get(key);
            whitelistMap.put(key, value);
            ++n2;
        }
        return whitelistMap;
    }

    private Statement _parseStatement(Statement parentStatement, String assignment, Map<String, Object> statementBody) {
        Statement statement = new Statement(parentStatement);
        this._statements.add(statement);
        int x = assignment.indexOf("=");
        if (x == -1) {
            statement.setMethod(assignment.trim());
        } else {
            String name = assignment.substring(0, x).trim();
            int y = name.indexOf("[");
            if (y != -1) {
                String whitelistString = name.substring(y + 1, name.length() - 1);
                String[] whiteList = StringUtil.split((String)whitelistString);
                int i2 = 0;
                while (i2 < whiteList.length) {
                    whiteList[i2] = whiteList[i2].trim();
                    ++i2;
                }
                statement.setWhitelist(whiteList);
                name = name.substring(0, y);
            }
            statement.setName(name);
            statement.setMethod(assignment.substring(x + 1).trim());
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(statementBody.size());
        statement.setParameterMap(parameterMap);
        for (String key : statementBody.keySet()) {
            Object value;
            if (key.startsWith("@")) {
                value = (String)statementBody.get(key);
                List<Flag> flags = statement.getFlags();
                if (flags == null) {
                    flags = new ArrayList<Flag>();
                    statement.setFlags(flags);
                }
                Flag flag = new Flag();
                flag.setName(key.substring(1));
                flag.setValue(value);
                flags.add(flag);
                continue;
            }
            if (key.startsWith("$") || key.contains(".$")) {
                Map map = (Map)statementBody.get(key);
                List<Statement> variableStatements = statement.getVariableStatements();
                if (variableStatements == null) {
                    variableStatements = new ArrayList<Statement>();
                    statement.setVariableStatements(variableStatements);
                }
                Statement variableStatement = this._parseStatement(statement, key, map);
                variableStatements.add(variableStatement);
                continue;
            }
            value = statementBody.get(key);
            parameterMap.put(CamelCaseUtil.normalizeCamelCase((String)key), value);
        }
        return statement;
    }

    private Object _populateFlags(Statement statement, Object result) {
        List<Object> listResult = this._convertObjectToList(result);
        if (listResult != null) {
            result = this._populateFlagsList(statement.getName(), listResult, new ArrayList<Object>());
        } else {
            this._populateFlagsObject(statement.getName(), result);
        }
        return result;
    }

    private List<Object> _populateFlagsList(String name, List<Object> list, List<Object> results) {
        for (Object object : list) {
            List<Object> listObject = this._convertObjectToList(object);
            if (listObject != null) {
                List<Object> value = this._populateFlagsList(name, listObject, results);
                results.add(value);
                continue;
            }
            this._populateFlagsObject(name, object);
            results.add(object);
        }
        return results;
    }

    private void _populateFlagsObject(String name, Object object) {
        if (name == null) {
            return;
        }
        String pushedName = null;
        int index = name.indexOf(46);
        if (index != -1) {
            pushedName = name.substring(0, index + 1);
        }
        name = name.concat(".");
        for (Statement statement : this._statements) {
            List<Flag> flags;
            if (statement.isExecuted() || (flags = statement.getFlags()) == null) continue;
            for (Flag flag : flags) {
                Object propertyValue;
                Map<String, Object> parameterMap;
                String value = (String)flag.getValue();
                if (value == null) continue;
                if (value.startsWith(name)) {
                    parameterMap = statement.getParameterMap();
                    propertyValue = BeanUtil.getDeclaredProperty((Object)object, (String)value.substring(name.length()));
                    parameterMap.put((String)flag.getName(), propertyValue);
                    continue;
                }
                if (!statement.isPushed() || !value.startsWith(pushedName)) continue;
                parameterMap = statement.getParameterMap();
                propertyValue = BeanUtil.getDeclaredProperty((Object)statement._pushTarget, (String)value.substring(pushedName.length()));
                parameterMap.put((String)flag.getName(), propertyValue);
            }
        }
    }

    private class Flag
    extends NameValue<String, String> {
        private Flag() {
        }
    }

    public class InvokerResult
    implements JSONSerializable {
        private Object _result;

        public JSONWebServiceInvokerAction getJSONWebServiceInvokerAction() {
            return JSONWebServiceInvokerAction.this;
        }

        public String toJSONString() {
            if (this._result == null) {
                return JSONFactoryUtil.getNullJSON();
            }
            JSONSerializer jsonSerializer = this.createJSONSerializer();
            for (Statement statement : JSONWebServiceInvokerAction.this._statements) {
                String name;
                if (JSONWebServiceInvokerAction.this._includes != null) {
                    for (String include : JSONWebServiceInvokerAction.this._includes) {
                        jsonSerializer.include(new String[]{include});
                    }
                }
                if ((name = statement.getName()) == null) continue;
                String includeName = name.substring(1);
                JSONWebServiceInvokerAction.this._checkJSONSerializerIncludeName(includeName);
                jsonSerializer.include(new String[]{includeName});
            }
            return jsonSerializer.serialize(this._result);
        }

        public Object getResult() {
            return this._result;
        }

        public InvokerResult(Object result) {
            this._result = result;
        }

        protected JSONSerializer createJSONSerializer() {
            JSONSerializer jsonSerializer = JSONFactoryUtil.createJSONSerializer();
            jsonSerializer.exclude(new String[]{"*.class"});
            return jsonSerializer;
        }
    }

    private class Statement {
        private boolean _executed;
        private List<Flag> _flags;
        private boolean _inner;
        private String _method;
        private String _name;
        private Map<String, Object> _parameterMap;
        private Statement _parentStatement;
        private Object _pushTarget;
        private List<Statement> _variableStatements;
        private String[] _whitelist;

        public List<Flag> getFlags() {
            return this._flags;
        }

        public String getMethod() {
            return this._method;
        }

        public String getName() {
            return this._name;
        }

        public Map<String, Object> getParameterMap() {
            return this._parameterMap;
        }

        public Statement getParentStatement() {
            return this._parentStatement;
        }

        public List<Statement> getVariableStatements() {
            return this._variableStatements;
        }

        public String[] getWhitelist() {
            return this._whitelist;
        }

        public boolean isExecuted() {
            return this._executed;
        }

        public boolean isInner() {
            return this._inner;
        }

        public boolean isPushed() {
            return this._pushTarget != null;
        }

        public Object push(Object result) {
            if (this._parentStatement == null) {
                return null;
            }
            this._pushTarget = result;
            Statement statement = this.getParentStatement();
            String variableName = this.getName();
            int index = variableName.indexOf(".$");
            String beanName = variableName.substring(0, index);
            result = BeanUtil.getDeclaredProperty((Object)result, (String)beanName);
            statement.setName(String.valueOf(statement.getName()) + "." + beanName);
            variableName = variableName.substring(index + 1);
            this.setName(variableName);
            return result;
        }

        public Object pop(Object result) {
            if (this._pushTarget == null) {
                return null;
            }
            Statement statement = this.getParentStatement();
            String statementName = statement.getName();
            int index = statementName.lastIndexOf(46);
            String beanName = statementName.substring(index + 1);
            statementName = statementName.substring(0, index);
            statement.setName(statementName);
            this.setName(String.valueOf(beanName) + "." + this.getName());
            BeanUtil.setDeclaredProperty((Object)this._pushTarget, (String)beanName, (Object)result);
            result = this._pushTarget;
            this._pushTarget = null;
            return result;
        }

        public void setExecuted(boolean executed) {
            this._executed = executed;
        }

        public void setFlags(List<Flag> flags) {
            this._flags = flags;
        }

        public void setMethod(String method) {
            this._method = method;
        }

        public void setName(String name) {
            this._inner = name.contains(".$");
            this._name = name;
        }

        public void setParameterMap(Map<String, Object> parameterMap) {
            this._parameterMap = parameterMap;
        }

        public void setVariableStatements(List<Statement> variableStatements) {
            this._variableStatements = variableStatements;
        }

        public void setWhitelist(String[] whitelist) {
            this._whitelist = whitelist;
        }

        private Statement(Statement parentStatement) {
            this._parentStatement = parentStatement;
        }
    }
}

