/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class TunnelUtil {
    private static final boolean _VERIFY_SSL_HOSTNAME = GetterUtil.getBoolean((String)PropsUtil.get((String)(String.valueOf(TunnelUtil.class.getName()) + ".verify.ssl.hostname")));
    private static Log _log = LogFactoryUtil.getLog(TunnelUtil.class);

    public static Key getSharedSecretKey() throws AuthException {
        String sharedSecret = PropsValues.TUNNELING_SERVLET_SHARED_SECRET;
        boolean sharedSecretHex = PropsValues.TUNNELING_SERVLET_SHARED_SECRET_HEX;
        if (Validator.isNull((String)sharedSecret)) {
            AuthException authException = new AuthException();
            authException.setType(3);
            throw authException;
        }
        byte[] key = null;
        if (sharedSecretHex) {
            try {
                key = Hex.decodeHex((char[])sharedSecret.toCharArray());
            }
            catch (DecoderException e2) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e2, (Throwable)e2);
                }
                AuthException authException = new AuthException();
                authException.setType(2);
                throw authException;
            }
        } else {
            key = sharedSecret.getBytes();
        }
        if (key.length < 8) {
            AuthException authException = new AuthException();
            authException.setType(2);
            throw authException;
        }
        return new SecretKeySpec(key, PropsValues.TUNNELING_SERVLET_ENCRYPTION_ALGORITHM);
    }

    public static Object invoke(HttpPrincipal httpPrincipal, MethodHandler methodHandler) throws Exception {
        String password = Encryptor.encrypt((Key)TunnelUtil.getSharedSecretKey(), (String)httpPrincipal.getLogin());
        httpPrincipal.setPassword(password);
        HttpURLConnection httpURLConnection = TunnelUtil._getConnection(httpPrincipal);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(httpURLConnection.getOutputStream());
        objectOutputStream.writeObject(new ObjectValuePair((Object)httpPrincipal, (Object)methodHandler));
        objectOutputStream.flush();
        objectOutputStream.close();
        Object returnObject = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(httpURLConnection.getInputStream());
            returnObject = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (EOFException eofe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read object", (Throwable)eofe);
            }
        }
        catch (IOException ioe) {
            String ioeMessage = ioe.getMessage();
            if (ioeMessage != null && ioeMessage.contains("HTTP response code: 401")) {
                throw new PrincipalException(ioeMessage);
            }
            throw ioe;
        }
        if (returnObject != null && returnObject instanceof Exception) {
            throw (Exception)returnObject;
        }
        return returnObject;
    }

    private static HttpURLConnection _getConnection(HttpPrincipal httpPrincipal) throws IOException {
        if (httpPrincipal == null || httpPrincipal.getUrl() == null) {
            return null;
        }
        URL url = new URL(String.valueOf(httpPrincipal.getUrl()) + "/api/liferay/do");
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        if (!_VERIFY_SSL_HOSTNAME && httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        httpURLConnection.setRequestProperty("Content-Type", "application/x-java-serialized-object");
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("POST");
        if (Validator.isNotNull((String)httpPrincipal.getLogin()) && Validator.isNotNull((String)httpPrincipal.getPassword())) {
            String userNameAndPassword = String.valueOf(httpPrincipal.getLogin()) + ":" + httpPrincipal.getPassword();
            httpURLConnection.setRequestProperty("Authorization", "BASIC " + Base64.encode((byte[])userNameAndPassword.getBytes()));
        }
        return httpURLConnection;
    }
}

