/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.concurrent.LockRegistry;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.PortalPreferences;
import com.liferay.portal.service.base.PortalPreferencesLocalServiceBaseImpl;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import com.liferay.portlet.PortalPreferencesWrapperCacheUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.util.concurrent.locks.ReentrantLock;
import javax.portlet.PortletPreferences;

public class PortalPreferencesLocalServiceImpl
extends PortalPreferencesLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(PortalPreferencesLocalServiceImpl.class);

    public PortalPreferences addPortalPreferences(long ownerId, int ownerType, String defaultPreferences) throws SystemException {
        PortalPreferences portalPreferences;
        block4: {
            PortalPreferencesWrapperCacheUtil.remove(ownerId, ownerType);
            long portalPreferencesId = this.counterLocalService.increment();
            portalPreferences = this.portalPreferencesPersistence.create(portalPreferencesId);
            portalPreferences.setOwnerId(ownerId);
            portalPreferences.setOwnerType(ownerType);
            if (Validator.isNull((String)defaultPreferences)) {
                defaultPreferences = "<portlet-preferences />";
            }
            portalPreferences.setPreferences(defaultPreferences);
            try {
                this.portalPreferencesPersistence.update((BaseModel)portalPreferences);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {ownerId=" + ownerId + ", ownerType=" + ownerType + "}"));
                }
                if ((portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType, false)) != null) break block4;
                throw se;
            }
        }
        return portalPreferences;
    }

    public PortalPreferences addPortalPreferences(long companyId, long ownerId, int ownerType, String defaultPreferences) throws SystemException {
        return this.addPortalPreferences(ownerId, ownerType, defaultPreferences);
    }

    public PortletPreferences getPreferences(long ownerId, int ownerType) throws SystemException {
        return this.getPreferences(ownerId, ownerType, null);
    }

    public PortletPreferences getPreferences(long ownerId, int ownerType, String defaultPreferences) throws SystemException {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("hypersonic")) {
            return this.doGetPreferences(ownerId, ownerType, defaultPreferences);
        }
        StringBundler sb = new StringBundler(4);
        sb.append(ownerId);
        sb.append("#");
        sb.append(ownerType);
        sb.append("#");
        String groupName = ((Object)((Object)this)).getClass().getName();
        String key = sb.toString();
        ReentrantLock lock = LockRegistry.allocateLock((String)groupName, (String)key);
        lock.lock();
        try {
            PortletPreferences portletPreferences = this.doGetPreferences(ownerId, ownerType, defaultPreferences);
            return portletPreferences;
        }
        finally {
            lock.unlock();
            LockRegistry.freeLock((String)groupName, (String)key);
        }
    }

    public PortletPreferences getPreferences(long companyId, long ownerId, int ownerType) throws SystemException {
        return this.getPreferences(ownerId, ownerType);
    }

    public PortletPreferences getPreferences(long companyId, long ownerId, int ownerType, String defaultPreferences) throws SystemException {
        return this.getPreferences(ownerId, ownerType, defaultPreferences);
    }

    public PortalPreferences updatePreferences(long ownerId, int ownerType, com.liferay.portlet.PortalPreferences portalPreferences) throws SystemException {
        String xml = PortletPreferencesFactoryUtil.toXML((com.liferay.portlet.PortalPreferences)portalPreferences);
        return this.updatePreferences(ownerId, ownerType, xml);
    }

    public PortalPreferences updatePreferences(long ownerId, int ownerType, String xml) throws SystemException {
        PortalPreferencesWrapperCacheUtil.remove(ownerId, ownerType);
        PortalPreferences portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType);
        if (portalPreferences == null) {
            long portalPreferencesId = this.counterLocalService.increment();
            portalPreferences = this.portalPreferencesPersistence.create(portalPreferencesId);
            portalPreferences.setOwnerId(ownerId);
            portalPreferences.setOwnerType(ownerType);
        }
        portalPreferences.setPreferences(xml);
        this.portalPreferencesPersistence.update((BaseModel)portalPreferences);
        return portalPreferences;
    }

    protected PortletPreferences doGetPreferences(long ownerId, int ownerType, String defaultPreferences) throws SystemException {
        PortalPreferencesWrapper portalPreferencesWrapper = PortalPreferencesWrapperCacheUtil.get(ownerId, ownerType);
        if (portalPreferencesWrapper != null) {
            return portalPreferencesWrapper.clone();
        }
        PortalPreferences portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType);
        if (portalPreferences == null) {
            portalPreferences = this.portalPreferencesLocalService.addPortalPreferences(ownerId, ownerType, defaultPreferences);
        }
        PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)ownerId, (int)ownerType, (String)portalPreferences.getPreferences());
        portalPreferencesWrapper = new PortalPreferencesWrapper(portalPreferencesImpl);
        PortalPreferencesWrapperCacheUtil.put(ownerId, ownerType, portalPreferencesWrapper);
        return portalPreferencesWrapper.clone();
    }
}

