/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.PortletPreferences;
import com.liferay.portal.model.impl.PortletPreferencesImpl;
import com.liferay.portal.model.impl.PortletPreferencesModelImpl;
import com.liferay.portal.service.persistence.PortletPreferencesFinder;
import com.liferay.portal.service.persistence.PortletPreferencesPersistenceImpl;
import com.liferay.portal.service.persistence.PortletPreferencesUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

public class PortletPreferencesFinderImpl
extends BasePersistenceImpl<PortletPreferences>
implements PortletPreferencesFinder {
    public static final String COUNT_BY_O_O_P = String.valueOf(PortletPreferencesFinder.class.getName()) + ".countByO_O_P";
    public static final String COUNT_BY_O_O_P_P_P = String.valueOf(PortletPreferencesFinder.class.getName()) + ".countByO_O_P_P_P";
    public static final String FIND_BY_PORTLET_ID = String.valueOf(PortletPreferencesFinder.class.getName()) + ".findByPortletId";
    public static final String FIND_BY_C_G_O_O_P_P = String.valueOf(PortletPreferencesFinder.class.getName()) + ".findByC_G_O_O_P_P";
    public static final FinderPath FINDER_PATH_FIND_BY_C_G_O_O_P_P = new FinderPath(PortletPreferencesModelImpl.ENTITY_CACHE_ENABLED, PortletPreferencesModelImpl.FINDER_CACHE_ENABLED, PortletPreferencesImpl.class, PortletPreferencesPersistenceImpl.FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_G_O_O_P_P", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName(), String.class.getName(), Boolean.class.getName()});
    private static final String _OWNER_ID_SQL = "(PortletPreferences.ownerId = ?) AND";
    private static final String _PLID_SQL = "AND (PortletPreferences.plid = ?)";
    private static final String _PORTLET_ID_INSTANCE_SQL = "OR (PortletPreferences.portletId LIKE ?)";
    private static final String _PREFERENCES_SQL = "AND (PortletPreferences.preferences != '[$PORTLET_PREFERENCES_PREFERENCES_DEFAULT$]')";

    public long countByO_O_P(long ownerId, int ownerType, String portletId, boolean excludeDefaultPreferences) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_O_O_P);
            if (ownerId == -1L) {
                sql = StringUtil.replace((String)sql, (String)_OWNER_ID_SQL, (String)"");
            }
            if (!excludeDefaultPreferences) {
                sql = StringUtil.replace((String)sql, (String)_PREFERENCES_SQL, (String)"");
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (ownerId != -1L) {
                qPos.add(ownerId);
            }
            qPos.add(ownerType);
            qPos.add(portletId);
            qPos.add(portletId.concat("%_INSTANCE_%"));
            int count = 0;
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Long l = (Long)itr.next();
                if (l == null) continue;
                count += l.intValue();
            }
            long l = count;
            return l;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public long countByO_O_P_P_P(long ownerId, int ownerType, long plid, String portletId, boolean excludeDefaultPreferences) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_O_O_P_P_P);
            if (ownerId == -1L) {
                sql = StringUtil.replace((String)sql, (String)_OWNER_ID_SQL, (String)"");
            }
            sql = plid == -1L ? StringUtil.replace((String)sql, (String)_PLID_SQL, (String)"") : StringUtil.replace((String)sql, (String)_PORTLET_ID_INSTANCE_SQL, (String)"");
            sql = excludeDefaultPreferences ? StringUtil.replace((String)sql, (String)"[$PORTLET_PREFERENCES_PREFERENCES_DEFAULT$]", (String)"<portlet-preferences />") : StringUtil.replace((String)sql, (String)_PREFERENCES_SQL, (String)"");
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (ownerId != -1L) {
                qPos.add(ownerId);
            }
            qPos.add(ownerType);
            qPos.add(portletId);
            if (plid != -1L) {
                qPos.add(plid);
            } else {
                qPos.add(portletId.concat("%_INSTANCE_%"));
            }
            int count = 0;
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Long l = (Long)itr.next();
                if (l == null) continue;
                count += l.intValue();
            }
            long l = count;
            return l;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<PortletPreferences> findByPortletId(String portletId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_PORTLET_ID);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("PortletPreferences", PortletPreferencesImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(portletId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<PortletPreferences> findByC_G_O_O_P_P(long companyId, long groupId, long ownerId, int ownerType, String portletId, boolean privateLayout) throws SystemException {
        Object[] finderArgs = new Object[]{companyId, groupId, ownerId, ownerType, portletId, privateLayout};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_C_G_O_O_P_P, (Object[])finderArgs, (SessionFactory)this);
        if (list != null && !list.isEmpty()) {
            for (PortletPreferences portletPreferences : list) {
                if (ownerId == portletPreferences.getOwnerId() && ownerType == portletPreferences.getOwnerType() && this.isInstanceOf(portletPreferences.getPortletId(), portletId)) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    String sql = CustomSQLUtil.get((String)FIND_BY_C_G_O_O_P_P);
                    SQLQuery q = session.createSQLQuery(sql);
                    q.addEntity("PortletPreferences", PortletPreferencesImpl.class);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(companyId);
                    qPos.add(groupId);
                    qPos.add(ownerId);
                    qPos.add(ownerType);
                    qPos.add(portletId);
                    qPos.add(portletId.concat("_INSTANCE_%"));
                    qPos.add(privateLayout);
                    list = q.list(true);
                    PortletPreferencesUtil.cacheResult((List)list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_C_G_O_O_P_P, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_BY_C_G_O_O_P_P, (Object[])finderArgs);
                    throw new SystemException((Throwable)e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    protected boolean isInstanceOf(String portletPreferencesPortletId, String portletId) {
        if ((portletPreferencesPortletId = GetterUtil.getString((String)portletPreferencesPortletId)).equals(portletId = GetterUtil.getString((String)portletId))) {
            return true;
        }
        return portletPreferencesPortletId.startsWith(portletId.concat("_INSTANCE_"));
    }
}

