/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.spring.transaction.TransactionExecutor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class TransactionInterceptor
implements MethodInterceptor {
    protected PlatformTransactionManager platformTransactionManager;
    protected TransactionAttributeSource transactionAttributeSource;
    protected TransactionExecutor transactionExecutor;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        TransactionAttribute transactionAttribute;
        Method method = methodInvocation.getMethod();
        Class<?> targetClass = null;
        Object targetBean = methodInvocation.getThis();
        if (targetBean != null) {
            targetClass = targetBean.getClass();
        }
        if ((transactionAttribute = this.transactionAttributeSource.getTransactionAttribute(method, targetClass)) == null) {
            return methodInvocation.proceed();
        }
        return this.transactionExecutor.execute(this.platformTransactionManager, transactionAttribute, methodInvocation);
    }

    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this.transactionAttributeSource = transactionAttributeSource;
    }

    public void setTransactionExecutor(TransactionExecutor transactionExecutor) {
        this.transactionExecutor = transactionExecutor;
    }

    public void setTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.setPlatformTransactionManager(platformTransactionManager);
    }
}

