/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.portal.dao.db.MySQLDB;
import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.io.CharPipe;
import com.liferay.portal.kernel.io.OutputStreamWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncTeeWriter;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.samplesqlbuilder.DataFactory;
import com.liferay.portal.tools.samplesqlbuilder.SampleMySQLDB;
import com.liferay.portal.util.InitUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SampleSQLBuilder {
    private static final int _PIPE_BUFFER_SIZE = 0x1000000;
    private static final int _WRITER_BUFFER_SIZE = 16384;
    private String[] _csvFileNames;
    private DataFactory _dataFactory;
    private String _dbType;
    private int _optimizeBufferSize;
    private String _outputDir;
    private String _script;

    public static void main(String[] args) {
        block12: {
            InitUtil.initWithSpring();
            Reader reader = null;
            try {
                try {
                    SortedProperties properties = new SortedProperties();
                    reader = new FileReader(args[0]);
                    properties.load(reader);
                    DataFactory dataFactory = new DataFactory((Properties)properties);
                    new SampleSQLBuilder((Properties)properties, dataFactory);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    if (reader == null) break block12;
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
    }

    public SampleSQLBuilder(Properties properties, DataFactory dataFactory) throws Exception {
        this._dbType = properties.getProperty("sample.sql.db.type");
        this._csvFileNames = StringUtil.split((String)properties.getProperty("sample.sql.output.csv.file.names"));
        this._optimizeBufferSize = GetterUtil.getInteger((String)properties.getProperty("sample.sql.optimize.buffer.size"));
        this._outputDir = properties.getProperty("sample.sql.output.dir");
        this._script = properties.getProperty("sample.sql.script");
        this._dataFactory = dataFactory;
        Reader reader = this.generateSQL();
        File tempDir = new File(this._outputDir, "temp");
        tempDir.mkdirs();
        try {
            this.compressSQL(reader, tempDir);
            boolean outputMerge = GetterUtil.getBoolean((String)properties.getProperty("sample.sql.output.merge"));
            if (outputMerge) {
                File sqlFile = new File(this._outputDir, "sample-" + this._dbType + ".sql");
                FileUtil.delete((File)sqlFile);
                this.mergeSQL(tempDir, sqlFile);
            } else {
                File outputDir = new File(this._outputDir, "output");
                FileUtil.deltree((File)outputDir);
                if (!tempDir.renameTo(outputDir)) {
                    FileUtil.copyDirectory((File)tempDir, (File)outputDir);
                }
            }
        }
        finally {
            FileUtil.deltree((File)tempDir);
        }
        StringBundler sb = new StringBundler();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("sample.sql")) continue;
            String value = properties.getProperty(key);
            sb.append(key);
            sb.append("=");
            sb.append(value);
            sb.append("\n");
        }
        FileUtil.write((File)new File(this._outputDir, "benchmarks-actual.properties"), (String)sb.toString());
    }

    protected void compressSQL(DB db, File directory, Map<String, Writer> insertSQLWriters, Map<String, StringBundler> sqls, String insertSQL) throws IOException {
        String tableName = insertSQL.substring(0, insertSQL.indexOf(32));
        int index = insertSQL.indexOf(" values ") + 8;
        StringBundler sb = sqls.get(tableName);
        if (sb == null || sb.index() == 0) {
            sb = new StringBundler();
            sqls.put(tableName, sb);
            sb.append("insert into ");
            sb.append(insertSQL.substring(0, index));
            sb.append("\n");
        } else {
            sb.append(",\n");
        }
        String values = insertSQL.substring(index, insertSQL.length() - 1);
        sb.append(values);
        if (sb.index() >= this._optimizeBufferSize) {
            sb.append(";\n");
            insertSQL = db.buildSQL(sb.toString());
            sb.setIndex(0);
            this.writeToInsertSQLFile(directory, tableName, insertSQLWriters, insertSQL);
        }
    }

    protected void compressSQL(Reader reader, File dir) throws IOException {
        DB db = DBFactoryUtil.getDB((String)this._dbType);
        if (db instanceof MySQLDB) {
            db = new SampleMySQLDB();
        }
        HashMap<String, Writer> insertSQLWriters = new HashMap<String, Writer>();
        HashMap<String, StringBundler> insertSQLs = new HashMap<String, StringBundler>();
        ArrayList<String> miscSQLs = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);
        String s = null;
        while ((s = unsyncBufferedReader.readLine()) != null) {
            if ((s = s.trim()).length() <= 0) continue;
            if (s.startsWith("insert into ")) {
                this.compressSQL(db, dir, insertSQLWriters, insertSQLs, s.substring(12));
                continue;
            }
            miscSQLs.add(s);
        }
        unsyncBufferedReader.close();
        for (Map.Entry entry : insertSQLs.entrySet()) {
            String tableName = (String)entry.getKey();
            StringBundler sb = (StringBundler)entry.getValue();
            if (sb.index() == 0) continue;
            String insertSQL = db.buildSQL(sb.toString());
            this.writeToInsertSQLFile(dir, tableName, insertSQLWriters, insertSQL);
            Writer insertSQLWriter = (Writer)insertSQLWriters.remove(tableName);
            insertSQLWriter.write(";\n");
            insertSQLWriter.close();
        }
        FileWriter miscSQLWriter = new FileWriter(new File(dir, "misc.sql"));
        for (String miscSQL : miscSQLs) {
            miscSQL = db.buildSQL(miscSQL);
            miscSQLWriter.write(miscSQL);
            miscSQLWriter.write("\n");
        }
        ((Writer)miscSQLWriter).close();
    }

    protected Writer createFileWriter(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream);
        return this.createUnsyncBufferedWriter((Writer)writer);
    }

    protected Writer createUnsyncBufferedWriter(Writer writer) {
        return new UnsyncBufferedWriter(writer, 16384){

            public void flush() {
            }
        };
    }

    protected Reader generateSQL() {
        final CharPipe charPipe = new CharPipe(0x1000000);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    UnsyncTeeWriter sampleSQLWriter = new UnsyncTeeWriter(SampleSQLBuilder.this.createUnsyncBufferedWriter(charPipe.getWriter()), SampleSQLBuilder.this.createFileWriter(new File(SampleSQLBuilder.this._outputDir, "sample.sql")));
                    Map<String, Object> context = SampleSQLBuilder.this.getContext();
                    FreeMarkerUtil.process(SampleSQLBuilder.this._script, context, (Writer)sampleSQLWriter);
                    String[] stringArray = SampleSQLBuilder.this._csvFileNames;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String csvFileName = stringArray[n2];
                        Writer csvWriter = (Writer)context.get(String.valueOf(csvFileName) + "CSVWriter");
                        csvWriter.close();
                        ++n2;
                    }
                    sampleSQLWriter.close();
                    charPipe.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        };
        thread.start();
        return charPipe.getReader();
    }

    protected Map<String, Object> getContext() throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("dataFactory", this._dataFactory);
        String[] stringArray = this._csvFileNames;
        int n = this._csvFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String csvFileName = stringArray[n2];
            Writer csvWriter = this.createFileWriter(new File(this._outputDir, String.valueOf(csvFileName) + ".csv"));
            context.put(String.valueOf(csvFileName) + "CSVWriter", csvWriter);
            ++n2;
        }
        return context;
    }

    protected Properties getProperties(String[] args) throws Exception {
        Reader reader = null;
        try {
            SortedProperties properties = new SortedProperties();
            reader = new FileReader(args[0]);
            properties.load(reader);
            SortedProperties sortedProperties = properties;
            return sortedProperties;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    protected void mergeSQL(File inputDir, File outputSQLFile) throws IOException {
        FileOutputStream outputSQLFileOutputStream = new FileOutputStream(outputSQLFile);
        FileChannel outputFileChannel = outputSQLFileOutputStream.getChannel();
        File miscSQLFile = null;
        File[] fileArray = inputDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File inputFile = fileArray[n2];
            String inputFileName = inputFile.getName();
            if (inputFileName.equals("misc.sql")) {
                miscSQLFile = inputFile;
            } else {
                this.mergeSQL(inputFile, outputFileChannel);
            }
            ++n2;
        }
        if (miscSQLFile != null) {
            this.mergeSQL(miscSQLFile, outputFileChannel);
        }
        outputFileChannel.close();
    }

    protected void mergeSQL(File inputFile, FileChannel outputFileChannel) throws IOException {
        FileInputStream inputFileInputStream = new FileInputStream(inputFile);
        FileChannel inputFileChannel = inputFileInputStream.getChannel();
        inputFileChannel.transferTo(0L, inputFileChannel.size(), outputFileChannel);
        inputFileChannel.close();
        inputFile.delete();
    }

    protected void writeToInsertSQLFile(File dir, String tableName, Map<String, Writer> insertSQLWriters, String insertSQL) throws IOException {
        Writer insertSQLWriter = insertSQLWriters.get(tableName);
        if (insertSQLWriter == null) {
            File file = new File(dir, String.valueOf(tableName) + ".sql");
            insertSQLWriter = this.createFileWriter(file);
            insertSQLWriters.put(tableName, insertSQLWriter);
        }
        insertSQLWriter.write(insertSQL);
    }
}

