/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureExportActionableDynamicQuery;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMTemplateExportActionableDynamicQuery;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleExportActionableDynamicQuery;
import com.liferay.portlet.journal.service.persistence.JournalFeedExportActionableDynamicQuery;
import com.liferay.portlet.journal.service.persistence.JournalFolderExportActionableDynamicQuery;
import java.util.List;
import javax.portlet.PortletPreferences;

public class JournalPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "journal";

    public JournalPortletDataHandler() {
        this.setDataLocalized(true);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(DDMStructure.class, JournalArticle.class), new StagedModelType(DDMTemplate.class, DDMStructure.class), new StagedModelType(JournalArticle.class), new StagedModelType(JournalArticle.class, DDMStructure.class), new StagedModelType(JournalFeed.class), new StagedModelType(JournalFolder.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "web-content", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "referenced-content"), new PortletDataHandlerBoolean(NAMESPACE, "version-history", PropsValues.JOURNAL_PUBLISH_VERSION_HISTORY_BY_DEFAULT)}, JournalArticle.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "structures", true, false, null, DDMStructure.class.getName(), JournalArticle.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "templates", true, false, null, DDMTemplate.class.getName(), DDMStructure.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "feeds", true, false, null, JournalFeed.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "folders", true, false, null, JournalFolder.class.getName())});
        this.setPublishToLiveByDefault(PropsValues.JOURNAL_PUBLISH_TO_LIVE_BY_DEFAULT);
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(JournalPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        JournalArticleLocalServiceUtil.deleteArticles((long)portletDataContext.getScopeGroupId());
        JournalFolderLocalServiceUtil.deleteFolders((long)portletDataContext.getGroupId());
        DDMTemplateLocalServiceUtil.deleteTemplates((long)portletDataContext.getScopeGroupId());
        DDMStructureLocalServiceUtil.deleteStructures((long)portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.portlet.journal");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (portletDataContext.getBooleanParameter(NAMESPACE, "feeds")) {
            JournalFeedExportActionableDynamicQuery feedActionableDynamicQuery = new JournalFeedExportActionableDynamicQuery(portletDataContext);
            feedActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            JournalFolderExportActionableDynamicQuery folderActionableDynamicQuery = new JournalFolderExportActionableDynamicQuery(portletDataContext);
            folderActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "structures")) {
            ActionableDynamicQuery ddmStructureActionableDynamicQuery = this.getDDMStructureActionableDynamicQuery(portletDataContext, true);
            ddmStructureActionableDynamicQuery.performActions();
            ActionableDynamicQuery ddmStructureDefaultValueActionableDynamicQuery = this.getDDMStructureDefaultValuesActionableDynamicQuery(portletDataContext);
            ddmStructureDefaultValueActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "templates")) {
            ActionableDynamicQuery ddmTemplateActionableDynamicQuery = this.getDDMTemplateActionableDynamicQuery(portletDataContext, true);
            ddmTemplateActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "web-content")) {
            ActionableDynamicQuery articleActionableDynamicQuery = this.getArticleActionableDynamicQuery(portletDataContext);
            articleActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.portlet.journal");
        if (portletDataContext.getBooleanParameter(NAMESPACE, "feeds")) {
            Element feedsElement = portletDataContext.getImportDataGroupElement(JournalFeed.class);
            List feedElements = feedsElement.elements();
            for (Element feedElement : feedElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)feedElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            Element foldersElement = portletDataContext.getImportDataGroupElement(JournalFolder.class);
            List folderElements = foldersElement.elements();
            for (Element folderElement : folderElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
            }
        }
        Element articlesElement = portletDataContext.getImportDataGroupElement(JournalArticle.class);
        List articleElements = articlesElement.elements();
        if (portletDataContext.getBooleanParameter(NAMESPACE, "structures")) {
            Element ddmStructuresElement = portletDataContext.getImportDataGroupElement(DDMStructure.class);
            List ddmStructureElements = ddmStructuresElement.elements();
            for (Element ddmStructureElement : ddmStructureElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmStructureElement);
            }
            for (Element articleElement : articleElements) {
                String className = articleElement.attributeValue("class-name");
                if (!Validator.isNotNull((String)className) || !className.equals(DDMStructure.class.getName())) continue;
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)articleElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "templates")) {
            Element ddmTemplatesElement = portletDataContext.getImportDataGroupElement(DDMTemplate.class);
            List ddmTemplateElements = ddmTemplatesElement.elements();
            for (Element ddmTemplateElement : ddmTemplateElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmTemplateElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "web-content")) {
            for (Element articleElement : articleElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)articleElement);
            }
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ActionableDynamicQuery articleActionableDynamicQuery = this.getArticleActionableDynamicQuery(portletDataContext);
        articleActionableDynamicQuery.performCount();
        ActionableDynamicQuery ddmStructureActionableDynamicQuery = this.getDDMStructureActionableDynamicQuery(portletDataContext, false);
        ddmStructureActionableDynamicQuery.performActions();
        ddmStructureActionableDynamicQuery.performCount();
        ActionableDynamicQuery ddmTemplateActionableDynamicQuery = this.getDDMTemplateActionableDynamicQuery(portletDataContext, false);
        ddmTemplateActionableDynamicQuery.performActions();
        ddmTemplateActionableDynamicQuery.performCount();
        JournalFeedExportActionableDynamicQuery feedActionableDynamicQuery = new JournalFeedExportActionableDynamicQuery(portletDataContext);
        feedActionableDynamicQuery.performCount();
        JournalFolderExportActionableDynamicQuery folderActionableDynamicQuery = new JournalFolderExportActionableDynamicQuery(portletDataContext);
        folderActionableDynamicQuery.performCount();
    }

    protected ActionableDynamicQuery getArticleActionableDynamicQuery(final PortletDataContext portletDataContext) throws SystemException {
        return new JournalArticleExportActionableDynamicQuery(portletDataContext){

            protected void addOrderCriteria(DynamicQuery dynamicQuery) {
                if (portletDataContext.getBooleanParameter(JournalPortletDataHandler.NAMESPACE, "version-history")) {
                    dynamicQuery.addOrder(OrderFactoryUtil.asc((String)"id"));
                }
            }

            public void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                if (portletDataContext.getBooleanParameter(JournalPortletDataHandler.NAMESPACE, "version-history")) {
                    return;
                }
                DynamicQuery articleVersionDynamicQuery = DynamicQueryFactoryUtil.forClass(JournalArticle.class, (String)"articleVersion", (ClassLoader)PortalClassLoaderUtil.getClassLoader());
                articleVersionDynamicQuery.setProjection(ProjectionFactoryUtil.alias((Projection)ProjectionFactoryUtil.max((String)"articleVersion.version"), (String)"articleVersion.version"));
                articleVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"this.resourcePrimKey", (String)"articleVersion.resourcePrimKey"));
                Property versionProperty = PropertyFactoryUtil.forName((String)"version");
                dynamicQuery.add(versionProperty.eq(articleVersionDynamicQuery));
            }
        };
    }

    protected ActionableDynamicQuery getDDMStructureActionableDynamicQuery(final PortletDataContext portletDataContext, final boolean export) throws SystemException {
        return new DDMStructureExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                long classNameId = PortalUtil.getClassNameId(JournalArticle.class);
                dynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
            }

            protected StagedModelType getStagedModelType() {
                return new StagedModelType(DDMStructure.class.getName(), JournalArticle.class.getName());
            }

            protected void performAction(Object object) throws PortalException {
                DDMStructure ddmStructure = (DDMStructure)object;
                if (export) {
                    StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmStructure);
                }
            }
        };
    }

    protected ActionableDynamicQuery getDDMStructureDefaultValuesActionableDynamicQuery(PortletDataContext portletDataContext) throws SystemException {
        return new JournalArticleExportActionableDynamicQuery(portletDataContext){

            protected StagedModelType getStagedModelType() {
                return new StagedModelType(JournalArticle.class.getName(), DDMStructure.class.getName());
            }
        };
    }

    protected ActionableDynamicQuery getDDMTemplateActionableDynamicQuery(PortletDataContext portletDataContext) throws SystemException {
        return this.getDDMTemplateActionableDynamicQuery(portletDataContext, false);
    }

    protected ActionableDynamicQuery getDDMTemplateActionableDynamicQuery(final PortletDataContext portletDataContext, final boolean export) throws SystemException {
        return new DDMTemplateExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
                dynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
            }

            protected StagedModelType getStagedModelType() {
                return new StagedModelType(DDMTemplate.class.getName(), DDMStructure.class.getName());
            }

            public void performAction(Object object) throws PortalException {
                DDMTemplate ddmTemplate = (DDMTemplate)object;
                if (ddmTemplate.getClassPK() != 0L) {
                    try {
                        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchDDMStructure((long)ddmTemplate.getClassPK());
                        long classNameId = PortalUtil.getClassNameId(JournalArticle.class);
                        if (ddmStructure != null && ddmStructure.getClassNameId() != classNameId) {
                            return;
                        }
                    }
                    catch (SystemException systemException) {}
                }
                if (export) {
                    StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmTemplate);
                }
            }
        };
    }
}

