/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.sql.Timestamp;
import java.util.Date;
import org.json.JSONObject;

public class DateSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private static Class[] _serializableClasses = new Class[]{Date.class, Timestamp.class, java.sql.Date.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        String java_class = jso.getString("javaClass");
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (!java_class.equals("java.util.Date")) {
            throw new UnmarshallException("not a Date");
        }
        int time = jso.getInt("time");
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        long time = jso.getLong("time");
        if (jso.has("javaClass")) {
            try {
                clazz = Class.forName(jso.getString("javaClass"));
            }
            catch (ClassNotFoundException cnfe) {
                throw new UnmarshallException(cnfe.getMessage());
            }
        }
        if (Date.class.equals(clazz)) {
            return new Date(time);
        }
        if (Timestamp.class.equals(clazz)) {
            return new Timestamp(time);
        }
        if (java.sql.Date.class.equals(clazz)) {
            return new java.sql.Date(time);
        }
        throw new UnmarshallException("invalid class " + clazz);
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        if (!(o instanceof Date)) {
            throw new MarshallException("cannot marshall date using class " + o.getClass());
        }
        long time = ((Date)o).getTime();
        JSONObject obj = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            obj.put("javaClass", (Object)o.getClass().getName());
        }
        obj.put("time", (double)time);
        return obj;
    }
}

