/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.model;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.Environment;
import org.jamwiki.utils.WikiLogger;

public class VirtualWiki
implements Serializable {
    private static final WikiLogger logger = WikiLogger.getLogger(VirtualWiki.class.getName());
    private String rootTopicName = null;
    private String logoImageUrl = null;
    private String metaDescription = null;
    private String name = null;
    private String siteName = null;
    private int virtualWikiId = -1;

    public VirtualWiki(String name) {
        this.name = name;
    }

    public static VirtualWiki defaultVirtualWiki() {
        return new VirtualWiki(Environment.getValue("virtual-wiki-default"));
    }

    public String getLogoImageUrl() {
        return StringUtils.isBlank((String)this.logoImageUrl) ? Environment.getValue("logo-image") : this.logoImageUrl;
    }

    public void setLogoImageUrl(String logoImageUrl) {
        this.logoImageUrl = logoImageUrl;
    }

    public boolean isDefaultLogoImageUrl() {
        return StringUtils.isBlank((String)this.logoImageUrl) || StringUtils.equals((String)this.logoImageUrl, (String)Environment.getValue("logo-image"));
    }

    public String getMetaDescription() {
        return StringUtils.isBlank((String)this.metaDescription) ? Environment.getValue("meta-description") : this.metaDescription;
    }

    public void setMetaDescription(String metaDescription) {
        this.metaDescription = metaDescription;
    }

    public boolean isDefaultMetaDescription() {
        return StringUtils.isBlank((String)this.metaDescription) || StringUtils.equals((String)this.metaDescription, (String)Environment.getValue("meta-description"));
    }

    public boolean isDefaultVirtualWiki() {
        return this.name != null && this.name.equals(Environment.getValue("virtual-wiki-default"));
    }

    public String getName() {
        return this.name;
    }

    public String getRootTopicName() {
        return StringUtils.isBlank((String)this.rootTopicName) ? Environment.getValue("default-topic") : this.rootTopicName;
    }

    public void setRootTopicName(String rootTopicName) {
        this.rootTopicName = rootTopicName;
    }

    public boolean isDefaultRootTopicName() {
        return StringUtils.isBlank((String)this.rootTopicName) || StringUtils.equals((String)this.rootTopicName, (String)Environment.getValue("default-topic"));
    }

    public String getSiteName() {
        return StringUtils.isBlank((String)this.siteName) ? Environment.getValue("site-name") : this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public boolean isDefaultSiteName() {
        return StringUtils.isBlank((String)this.siteName) || StringUtils.equals((String)this.siteName, (String)Environment.getValue("site-name"));
    }

    public int getVirtualWikiId() {
        return this.virtualWikiId;
    }

    public void setVirtualWikiId(int virtualWikiId) {
        this.virtualWikiId = virtualWikiId;
    }
}

