/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static final WikiLogger logger = WikiLogger.getLogger(Utilities.class.getName());
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String ipv6Pattern = "([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}";
    private static final Pattern VALID_IPV4_PATTERN = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])", 2);
    private static final Pattern VALID_IPV6_PATTERN = Pattern.compile("([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}", 2);

    private Utilities() {
    }

    public static String convertEncoding(String text, String fromEncoding, String toEncoding) {
        if (StringUtils.isBlank((String)text)) {
            return text;
        }
        if (StringUtils.isBlank((String)fromEncoding)) {
            logger.warn("No character encoding specified to convert from, using UTF-8");
            fromEncoding = "UTF-8";
        }
        if (StringUtils.isBlank((String)toEncoding)) {
            logger.warn("No character encoding specified to convert to, using UTF-8");
            toEncoding = "UTF-8";
        }
        try {
            text = new String(text.getBytes(fromEncoding), toEncoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Unable to convert value " + text + " from " + fromEncoding + " to " + toEncoding, e);
        }
        return text;
    }

    public static String decodeTopicName(String url, boolean decodeUnderlines) {
        if (StringUtils.isBlank((String)url)) {
            return url;
        }
        return decodeUnderlines ? StringUtils.replace((String)url, (String)"_", (String)" ") : url;
    }

    public static String decodeAndEscapeTopicName(String url, boolean decodeUnderlines) {
        if (StringUtils.isBlank((String)url)) {
            return url;
        }
        String result = url;
        try {
            result = URLDecoder.decode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupporting encoding UTF-8");
        }
        return Utilities.decodeTopicName(result, decodeUnderlines);
    }

    public static List<String> delimitedStringToList(String delimitedString, String delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Attempt to call Utilities.delimitedStringToList with no delimiter specified");
        }
        if (StringUtils.isBlank((String)delimitedString)) {
            return null;
        }
        return Arrays.asList(StringUtils.splitByWholeSeparator((String)delimitedString, (String)delimiter));
    }

    public static String encodeTopicName(String url) {
        if (StringUtils.isBlank((String)url)) {
            return url;
        }
        return StringUtils.replace((String)url, (String)" ", (String)"_");
    }

    public static String encodeAndEscapeTopicName(String url) {
        if (StringUtils.isBlank((String)url)) {
            return url;
        }
        String result = Utilities.encodeTopicName(url);
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupporting encoding UTF-8");
        }
        result = StringUtils.replace((String)result, (String)"%3A", (String)":");
        result = StringUtils.replace((String)result, (String)"%2F", (String)"/");
        return result;
    }

    public static int findMatchingEndTag(CharSequence content, int start, String startToken, String endToken) {
        return Utilities.findMatchingTag(((Object)content).toString(), start, startToken, endToken, false);
    }

    public static int findMatchingStartTag(CharSequence content, int start, String startToken, String endToken) {
        return Utilities.findMatchingTag(((Object)content).toString(), start, startToken, endToken, true);
    }

    private static int findMatchingTag(String content, int start, String startToken, String endToken, boolean reverse) {
        if (StringUtils.isBlank((String)content) || start >= content.length()) {
            return -1;
        }
        int pos = start;
        int count = 0;
        String substring = null;
        boolean atLeastOneMatch = false;
        while (pos >= 0 && pos < content.length()) {
            String string = substring = reverse ? content.substring(0, pos + 1) : content.substring(pos);
            if (!reverse && substring.startsWith(startToken)) {
                ++count;
                atLeastOneMatch = true;
                pos += startToken.length();
            } else if (!reverse && substring.startsWith(endToken)) {
                --count;
                pos += endToken.length();
            } else if (reverse && substring.endsWith(endToken)) {
                ++count;
                atLeastOneMatch = true;
                pos -= endToken.length();
            } else if (reverse && substring.endsWith(startToken)) {
                --count;
                pos -= startToken.length();
            } else {
                int n = pos = reverse ? pos - 1 : pos + 1;
            }
            if (!atLeastOneMatch || count != 0) continue;
            return pos;
        }
        return -1;
    }

    public static void forName(String className) throws ClassNotFoundException {
        try {
            Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            return;
        }
        catch (ClassNotFoundException e) {
            logger.info("Unable to load class " + className + " using the thread class loader, now trying the default class loader");
            Class.forName(className);
            return;
        }
    }

    public static String formatMessage(String key, Locale locale) {
        ResourceBundle messages = ResourceBundle.getBundle("ApplicationResources", locale);
        return messages.getString(key);
    }

    public static String formatMessage(String key, Locale locale, Object[] params) {
        MessageFormat formatter = new MessageFormat("");
        formatter.setLocale(locale);
        String message = Utilities.formatMessage(key, locale);
        formatter.applyPattern(message);
        return formatter.format(params);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException e) {
            logger.debug("Unable to retrieve thread class loader, trying default");
        }
        if (loader == null) {
            loader = Utilities.class.getClassLoader();
        }
        return loader;
    }

    public static File getClassLoaderFile(String filename) throws FileNotFoundException {
        File file = null;
        ClassLoader loader = Utilities.getClassLoader();
        URL url = loader.getResource(filename = filename.replace('\\', '/'));
        if (url == null) {
            url = ClassLoader.getSystemResource(filename);
        }
        if (url == null) {
            throw new FileNotFoundException("Unable to find " + filename);
        }
        file = FileUtils.toFile((URL)url);
        if (file == null || !file.exists()) {
            InputStream is = null;
            FileOutputStream os = null;
            try {
                String tempFilename = RandomStringUtils.randomAlphanumeric((int)20);
                file = File.createTempFile(tempFilename, null);
                is = loader.getResourceAsStream(filename);
                os = new FileOutputStream(file);
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            catch (IOException e) {
                try {
                    throw new FileNotFoundException("Unable to load file with URL " + url);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
        return file;
    }

    public static File getClassLoaderRoot() throws FileNotFoundException {
        File file = Utilities.getClassLoaderFile("sql.ansi.properties");
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to find class loader root");
        }
        return file.getParentFile();
    }

    public static String getQueryString(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String queryString = request.getQueryString();
        if (StringUtils.isBlank((String)queryString)) {
            return queryString;
        }
        if (StringUtils.containsAny((String)queryString, (String)"\"><")) {
            queryString = queryString.replaceAll("\"", "%22");
            queryString = queryString.replaceAll(">", "%3E");
            queryString = queryString.replaceAll("<", "%3C");
        }
        return queryString;
    }

    public static String getServerUrl(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + (request.getServerPort() != 80 ? ":" + request.getServerPort() : "");
    }

    public static Object instantiateClass(String className) {
        if (StringUtils.isBlank((String)className)) {
            throw new IllegalArgumentException("Cannot call instantiateClass with an empty class name");
        }
        logger.debug("Instantiating class: " + className);
        try {
            Class clazz = ClassUtils.getClass((String)className);
            Class[] parameterTypes = new Class[]{};
            Constructor constructor = clazz.getConstructor(parameterTypes);
            Object[] initArgs = new Object[]{};
            return constructor.newInstance(initArgs);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Invalid class name specified: " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Specified class does not have a valid constructor: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Specified class does not have a valid constructor: " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Specified class does not have a valid constructor: " + className, e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Specified class could not be instantiated: " + className, e);
        }
    }

    public static <K, V> Map<K, V> intersect(Map<K, V> map1, Map<K, V> map2) {
        if (map1 == null || map2 == null) {
            throw new IllegalArgumentException("Utilities.intersection() requires non-null arguments");
        }
        HashMap<K, V> result = new HashMap<K, V>();
        for (K key : map1.keySet()) {
            if (!ObjectUtils.equals(map1.get(key), map2.get(key))) continue;
            result.put(key, map1.get(key));
        }
        return result;
    }

    public static boolean isHtmlEntity(String text) {
        if (text == null) {
            return false;
        }
        return !text.equals(StringEscapeUtils.unescapeHtml((String)text));
    }

    public static boolean isIpAddress(String ipAddress) {
        if (StringUtils.isBlank((String)ipAddress)) {
            return false;
        }
        Matcher m1 = VALID_IPV4_PATTERN.matcher(ipAddress);
        if (m1.matches()) {
            return true;
        }
        Matcher m2 = VALID_IPV6_PATTERN.matcher(ipAddress);
        return m2.matches();
    }

    public static String listToDelimitedString(List<String> list, String delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Attempt to call Utilities.delimitedStringToList with no delimiter specified");
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        String result = "";
        for (String item : list) {
            if (result.length() > 0) {
                result = result + delimiter;
            }
            result = result + item;
        }
        return result;
    }

    public static String readFile(String filename) throws IOException {
        File file = new File(filename);
        if (file.exists()) {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        file = Utilities.getClassLoaderFile(filename);
        return FileUtils.readFileToString((File)file, (String)"UTF-8");
    }

    public static String stripMarkup(String value) {
        return StringUtils.trim((String)value.replaceAll("<[^>]+>", ""));
    }
}

