/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.persist.RowStoreAVLHybrid;

public class RowStoreAVLHybridExtended
extends RowStoreAVLHybrid {
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();

    public RowStoreAVLHybridExtended(Session session, PersistentStoreCollection manager, TableBase table, boolean diskBased) {
        super(session, manager, table, diskBased);
    }

    private RowStoreAVLHybridExtended(Session session, TableBase table) {
        super(session, table);
    }

    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        if (this.indexList != this.table.getIndexList()) {
            this.resetAccessorKeys(this.table.getIndexList());
        }
        return super.getNewCachedObject(session, object, tx);
    }

    public void indexRow(Session session, Row row) {
        NodeAVL node = ((RowAVL)row).getNode(0);
        int count = 0;
        while (node != null) {
            ++count;
            node = node.nNext;
        }
        if (count != this.indexList.length) {
            this.resetAccessorKeys(this.table.getIndexList());
            ((RowAVL)row).setNewNodes(this);
        }
        super.indexRow(session, row);
    }

    public CachedObject getAccessor(Index key) {
        int position = key.getPosition();
        if (position >= this.accessorList.length || this.indexList[position] != key) {
            this.resetAccessorKeys(this.table.getIndexList());
            return this.getAccessor(key);
        }
        return this.accessorList[position];
    }

    public synchronized void resetAccessorKeys(Index[] keys) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            this.resetAccessorKeysForCached();
        }
        super.resetAccessorKeys(keys);
    }

    private void resetAccessorKeysForCached() {
        RowStoreAVLHybridExtended tempStore = new RowStoreAVLHybridExtended(this.session, this.table);
        RowIterator iterator = this.table.rowIterator(this);
        while (iterator.hasNext()) {
            Row row = iterator.getNextRow();
            Row newRow = (Row)((RowStoreAVLHybrid)tempStore).getNewCachedObject(this.session, row.getData(), false);
            ((RowStoreAVL)tempStore).indexRow(this.session, newRow);
        }
        this.indexList = tempStore.indexList;
        this.accessorList = tempStore.accessorList;
    }

    public void writeLock() {
        this.writeLock.lock();
    }

    public void writeUnlock() {
        this.writeLock.unlock();
    }

    void lockIndexes() {
        for (int i = 0; i < this.indexList.length; ++i) {
        }
    }

    void unlockIndexes(Index[] array) {
        for (int i = 0; i < array.length; ++i) {
        }
    }
}

