/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.dav;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class DavPath {
    private ArrayList<String> m_parts = new ArrayList();
    private boolean m_isAbsolute = false;
    private boolean m_isDirectory = false;

    private DavPath() {
    }

    public DavPath(DavPath dp) {
        this.m_parts.addAll(dp.m_parts);
        this.m_isAbsolute = dp.m_isAbsolute;
        this.m_isDirectory = dp.m_isDirectory;
    }

    public DavPath(String path) {
        if (path == null) {
            this.m_isDirectory = true;
            this.m_isAbsolute = true;
            return;
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            if (part.length() <= 0) continue;
            this.m_parts.add(part);
        }
        if (path.endsWith("/")) {
            this.m_isDirectory = true;
        }
        this.m_isAbsolute = path.startsWith("/");
    }

    public void append(DavPath dp) {
        this.m_parts.addAll(dp.m_parts);
        this.m_isDirectory = dp.m_isDirectory;
    }

    public void append(String path) {
        DavPath dp = new DavPath(path);
        this.append(dp);
    }

    public boolean isRoot() {
        return this.m_parts.size() == 0 || this.m_parts.get(0).equals("");
    }

    public boolean isDirectory() {
        return this.isRoot() || this.m_isDirectory;
    }

    public String pathPart() {
        StringBuffer result = new StringBuffer(this.m_isAbsolute ? "/" : "");
        for (int i = 0; i < this.m_parts.size() - (this.m_isDirectory ? 0 : 1); ++i) {
            result.append(this.m_parts.get(i));
            result.append("/");
        }
        return result.toString();
    }

    public String filePart() {
        if (this.m_parts.size() > 0 && !this.m_isDirectory) {
            return this.m_parts.get(this.m_parts.size() - 1);
        }
        return "";
    }

    public String getName() {
        if (this.isRoot()) {
            return "/";
        }
        if (!this.isDirectory()) {
            return this.filePart();
        }
        return this.m_parts.get(this.m_parts.size() - 1);
    }

    public String getPath() {
        return this.pathPart() + this.filePart();
    }

    public DavPath subPath(int idx) {
        DavPath dp = new DavPath();
        for (int i = idx; i < this.m_parts.size(); ++i) {
            dp.m_parts.add(this.m_parts.get(i));
        }
        dp.m_isAbsolute = idx == 0;
        dp.m_isDirectory = this.m_isDirectory;
        return dp;
    }

    public String get(int idx) {
        if (idx > this.size()) {
            return null;
        }
        return this.m_parts.get(idx);
    }

    public int size() {
        return this.m_parts.size();
    }

    public int length() {
        return this.m_parts.size();
    }

    public String toString() {
        return "DavPath [" + this.getPath() + "]";
    }
}

