/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.filter.BufferedResponseWrapper;

public final class ExportDelegate {
    private static Log log = LogFactory.getLog((Class)ExportDelegate.class);

    private ExportDelegate() {
    }

    protected static void writeExport(HttpServletResponse response, ServletRequest request, BufferedResponseWrapper wrapper) throws IOException {
        Object pageContent;
        if (wrapper.isOutRequested()) {
            log.debug((Object)"Filter operating in unbuffered mode. Everything done, exiting");
            return;
        }
        log.debug((Object)"Filter operating in buffered mode. ");
        Map bean = (Map)request.getAttribute("org.displaytag.filter.ResponseOverrideFilter.CONTENT_OVERRIDE_BODY");
        if (log.isDebugEnabled()) {
            log.debug((Object)bean);
        }
        if ((pageContent = bean.get("body")) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Filter is enabled but exported content has not been found. Maybe an error occurred?");
            }
            response.setContentType(wrapper.getContentType());
            PrintWriter out = response.getWriter();
            out.write(wrapper.getContentAsString());
            out.flush();
            return;
        }
        if (!response.isCommitted()) {
            response.reset();
        }
        String filename = (String)bean.get("filename");
        String contentType = (String)bean.get("contenttype");
        if (StringUtils.isNotBlank((String)filename)) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        }
        String characterEncoding = wrapper.getCharacterEncoding();
        String wrappedContentType = wrapper.getContentType();
        if (wrappedContentType != null && wrappedContentType.indexOf("charset") > -1) {
            characterEncoding = StringUtils.substringAfter((String)wrappedContentType, (String)"charset=");
        }
        if (characterEncoding != null && contentType.indexOf("charset") == -1) {
            contentType = contentType + "; charset=" + characterEncoding;
        }
        response.setContentType(contentType);
        if (pageContent instanceof String) {
            if (characterEncoding != null) {
                response.setContentLength(((String)pageContent).getBytes(characterEncoding).length);
            } else {
                response.setContentLength(((String)pageContent).getBytes().length);
            }
            PrintWriter out = response.getWriter();
            out.write((String)pageContent);
            out.flush();
        } else {
            byte[] content = (byte[])pageContent;
            response.setContentLength(content.length);
            ServletOutputStream out = response.getOutputStream();
            out.write(content);
            out.flush();
        }
    }
}

