/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPQname;
import com.hp.hpl.jena.rdf.arp.ARPResource;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.BadURIReference;
import com.hp.hpl.jena.rdf.arp.CoRoutineDeathException;
import com.hp.hpl.jena.rdf.arp.DefaultErrorHandler;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.ParserSupport;
import com.hp.hpl.jena.rdf.arp.RDFParser;
import com.hp.hpl.jena.rdf.arp.RDFParserConstants;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.StrToken;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.TokenPipe;
import com.hp.hpl.jena.rdf.arp.Warn;
import com.hp.hpl.jena.rdf.arp.WrappedException;
import com.hp.hpl.jena.rdf.arp.XMLContext;
import java.io.IOException;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

class ARPFilter
extends XMLFilterImpl
implements RDFParserConstants,
ARPErrorNumbers {
    private Throwable parsersLastException;
    private boolean embedding = true;
    StatementHandler statementHandler = new StatementHandler(){

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
        }
    };
    XMLContext documentContext;
    private TokenPipe pipe;
    private Locator locator;
    static final String rdfns;
    static final String xmlns;
    static final Map rdfnames;
    static final Set knownRDFProperties;
    static final Set knownRDFTypes;
    private static String[] specialAtts;
    private static String[] specialNameSpaces;
    private static int A_XMLSPACE;
    private static int[] specialAttValues;
    private Map allCollections;
    private Vector allAboutEach;
    private static int[] defaultErrorMode;
    private int[] errorMode = (int[])defaultErrorMode.clone();

    ARPFilter() {
        super(ARPFilter.saxDriver());
        this.setErrorHandler(new DefaultErrorHandler());
    }

    private static XMLReader saxDriver() {
        return new SAXParser();
    }

    boolean setEmbedding(boolean bl) {
        boolean bl2 = this.embedding;
        this.embedding = bl;
        return bl2;
    }

    public synchronized void parse(InputSource inputSource) throws IOException, SAXException {
        block19: {
            this.getParent().setFeature("http://xml.org/sax/features/namespaces", true);
            this.getParent().setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            String string = inputSource.getSystemId();
            if (string == null) {
                this.warning(100, "Base URI not specified for input file; local references will expand incorrectly.");
            } else {
                string = ParserSupport.truncateXMLBase(string);
            }
            this.documentContext = new XMLContext(string, "");
            this.pipe = new TokenPipe(this);
            this.parsersLastException = null;
            this.allCollections = new HashMap();
            this.allAboutEach = new Vector();
            final Thread thread = Thread.currentThread();
            Thread thread2 = new Thread(){

                public void run() {
                    try {
                        RDFParser rDFParser = new RDFParser(ARPFilter.this.pipe, ARPFilter.this);
                        if (ARPFilter.this.embedding) {
                            rDFParser.content(ARPFilter.this.documentContext);
                        } else {
                            rDFParser.rdfFile(ARPFilter.this.documentContext);
                        }
                    }
                    catch (WrappedException wrappedException) {
                        thread.interrupt();
                        ARPFilter.this.parsersLastException = wrappedException;
                    }
                    catch (ParseException parseException) {
                        ARPFilter.this.parsersLastException = parseException;
                        thread.interrupt();
                    }
                    catch (CoRoutineDeathException coRoutineDeathException) {
                    }
                    catch (Exception exception) {
                        System.err.println("ARP - Internal Error: " + ParseException.formatMessage(exception));
                        exception.printStackTrace();
                        ARPFilter.this.parsersLastException = exception;
                        thread.interrupt();
                        try {
                            ARPFilter.this.getErrorHandler().fatalError(new SAXParseException("ARP internal error", null, exception));
                        }
                        catch (SAXException sAXException) {}
                    }
                    catch (Throwable throwable) {
                        ARPFilter.this.parsersLastException = throwable;
                        thread.interrupt();
                    }
                }
            };
            try {
                try {
                    thread2.start();
                    super.parse(inputSource);
                    this.pipe.putNextToken(new Token(0, null));
                    thread2.join();
                }
                catch (InterruptedException interruptedException) {
                    Object var12_6 = null;
                    thread2.interrupt();
                    this.locator = null;
                    break block19;
                }
                catch (CoRoutineDeathException coRoutineDeathException) {
                    Object var12_7 = null;
                    thread2.interrupt();
                    this.locator = null;
                    break block19;
                }
                catch (WrappedException wrappedException) {
                    wrappedException.throwMe();
                    Object var12_8 = null;
                    thread2.interrupt();
                    this.locator = null;
                    break block19;
                }
                catch (SAXException sAXException) {
                    this.warning(111, "Failed to parse XML.");
                    throw sAXException;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Throwable throwable) {
                    System.err.println("ARP - Internal Error: " + throwable.getMessage());
                    throwable.printStackTrace();
                    this.parsersLastException = throwable;
                    Object var12_9 = null;
                    thread2.interrupt();
                    this.locator = null;
                }
                Object var12_5 = null;
                thread2.interrupt();
                this.locator = null;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                thread2.interrupt();
                this.locator = null;
                throw throwable;
            }
        }
        if (this.parsersLastException != null) {
            if (this.parsersLastException instanceof WrappedException) {
                ((WrappedException)this.parsersLastException).throwMe();
            }
            if (this.parsersLastException instanceof RuntimeException) {
                throw (RuntimeException)this.parsersLastException;
            }
            if (this.parsersLastException instanceof Error) {
                throw (Error)this.parsersLastException;
            }
            if (this.parsersLastException instanceof Exception) {
                if (!(this.parsersLastException instanceof SAXException)) {
                    this.parsersLastException = new SAXException((Exception)this.parsersLastException);
                }
                if (this.parsersLastException instanceof SAXParseException) {
                    this.getErrorHandler().fatalError((SAXParseException)this.parsersLastException);
                } else {
                    throw (SAXException)this.parsersLastException;
                }
            }
            return;
        }
        this.doAboutEach();
    }

    StatementHandler setStatementHandler(StatementHandler statementHandler) {
        StatementHandler statementHandler2 = this.statementHandler;
        this.statementHandler = statementHandler;
        return statementHandler2;
    }

    void addMember(String string, AResource aResource) {
        Object object = aResource.isAnonymous() ? aResource : aResource.getURI();
        Vector<Object> vector = (Vector<Object>)this.allCollections.get(string);
        if (vector == null) {
            vector = new Vector<Object>();
            this.allCollections.put(string, vector);
        }
        vector.add(object);
    }

    void addAboutEach(ARPResource aRPResource) {
        this.allAboutEach.add(aRPResource);
    }

    private void doAboutEach() {
        Iterator iterator = ((AbstractList)this.allAboutEach).iterator();
        while (iterator.hasNext()) {
            ARPResource aRPResource = (ARPResource)iterator.next();
            String string = aRPResource.getURI();
            Vector vector = (Vector)this.allCollections.get(string);
            if (vector == null) {
                this.warning(110, "There was an aboutEach declaration for the collection: '" + string + "'." + ParseException.eol + "Either this collection was not defined, or it is empty.");
                continue;
            }
            Iterator iterator2 = ((AbstractList)vector).iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                AResource aResource = e instanceof AResource ? (AResource)e : new BadURIReference((String)e);
                aRPResource.applyAboutEach(aResource);
            }
        }
    }

    private void warning(int n, String string) {
        try {
            this.getErrorHandler().warning(new ParseException(n, string));
        }
        catch (SAXException sAXException) {
            throw new WrappedException(sAXException);
        }
    }

    void setDefaultErrorMode() {
        this.errorMode = (int[])defaultErrorMode.clone();
    }

    void setLaxErrorMode() {
        this.setDefaultErrorMode();
        int n = 100;
        while (n < 200) {
            this.setErrorMode(n, 0);
            ++n;
        }
        this.setErrorMode(112, 1);
    }

    void setStrictErrorMode() {
        this.setStrictErrorMode(0);
    }

    void setStrictErrorMode(int n) {
        this.setDefaultErrorMode();
        int n2 = 1;
        while (n2 < 100) {
            this.setErrorMode(n2, n);
            ++n2;
        }
        int n3 = 100;
        while (n3 < 200) {
            this.setErrorMode(n3, 2);
            ++n3;
        }
        int n4 = 1;
        int n5 = 2;
        switch (n) {
            case 2: {
                n4 = 2;
                break;
            }
            case 3: {
                n5 = 3;
                n4 = 3;
            }
        }
        this.setErrorMode(2, n4);
        this.setErrorMode(3, n5);
        this.setErrorMode(112, n4);
        this.setErrorMode(117, n4);
        this.setErrorMode(110, n);
        this.setErrorMode(106, n4);
        this.setErrorMode(111, n);
        this.setErrorMode(114, n5);
    }

    int setErrorMode(int n, int n2) {
        int n3 = this.errorMode[n];
        block0 : switch (n2) {
            case 0: 
            case 1: {
                if (n >= 200 && n != 202) break;
            }
            case 2: 
            case 3: {
                switch (n) {
                    case 300: {
                        break block0;
                    }
                }
                this.errorMode[n] = n2;
            }
        }
        return n3;
    }

    void parseWarning(int n, Location location, String string) throws ParseException {
        int n2 = this.errorMode[n];
        if (n2 == 0) {
            return;
        }
        ParseException parseException = new ParseException(n, location, string);
        if (n2 == 3) {
            parseException.setFatal(true);
            n2 = 2;
        }
        if (n2 == 2) {
            throw parseException;
        }
        try {
            this.getErrorHandler().warning(parseException);
            return;
        }
        catch (ParseException parseException2) {
            if (parseException2 == parseException) {
                throw parseException2;
            }
            throw new WrappedException(parseException);
        }
        catch (SAXException sAXException) {
            throw new WrappedException(sAXException);
        }
    }

    void parseWarning(Warn warn) throws ParseException {
        this.parseWarning(warn.number, warn.location, warn.msg);
    }

    private void putWarning(int n, Location location, String string) {
        this.pipe.putNextToken(new Warn(n, location, string));
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    private void doSpecialAtt(int n, int n2, String string, BitSet bitSet, Attributes attributes, Location location) throws SAXException {
        bitSet.set(n);
        if (n2 == A_XMLSPACE) {
            return;
        }
        this.pipe.putNextToken(new ARPQname(n2, location, string, null, attributes.getQName(n)));
        String string2 = attributes.getValue(n);
        if (n2 == 16) {
            if (string2.equals("Resource")) {
                this.pipe.putNextToken(new StrToken(19, location, string2));
            } else if (string2.equals("daml:collection")) {
                this.pipe.putNextToken(new StrToken(18, location, string2));
            } else {
                this.pipe.putNextToken(new StrToken(17, location, string2));
                if (!string2.equals("Literal")) {
                    this.putWarning(106, location, "Unknown parseType: " + string2);
                }
            }
        } else {
            this.pipe.putNextToken(new StrToken(10, location, string2));
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        Location location = new Location(this.locator);
        this.putElementQname(string, string2, string3, location);
        BitSet bitSet = new BitSet();
        int n2 = 0;
        while (n2 < specialAtts.length) {
            n = attributes.getIndex(specialNameSpaces[n2], specialAtts[n2]);
            if (n != -1) {
                this.doSpecialAtt(n, specialAttValues[n2], specialNameSpaces[n2], bitSet, attributes, location);
            }
            if (specialNameSpaces[n2] == rdfns && (n = attributes.getIndex("", specialAtts[n2])) != -1) {
                this.putWarning(101, location, "Unqualified use of rdf:" + attributes.getLocalName(n) + " has been deprecated.");
                this.doSpecialAtt(n, specialAttValues[n2], "", bitSet, attributes, location);
            }
            ++n2;
        }
        n = 0;
        while (n < attributes.getLength()) {
            if (!bitSet.get(n)) {
                String string4 = attributes.getURI(n);
                String string5 = attributes.getQName(n);
                if (string5.length() >= 3 && string5.substring(0, 3).toLowerCase().equals("xml")) {
                    this.putWarning(118, location, "XML attribute: " + attributes.getQName(n) + " is not known and is being discarded.");
                } else {
                    if (string4.equals("")) {
                        this.putWarning(102, location, "Attribute: " + attributes.getLocalName(n) + ". Unqualified use is deprecated. Assuming namespace: " + string);
                        string4 = string;
                    }
                    this.putAttributeQname(string4, attributes.getLocalName(n), string5, location);
                    this.pipe.putNextToken(new StrToken(10, location, attributes.getValue(n)));
                }
            }
            ++n;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new Token(3, location));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new StrToken(1, location, new String(cArray, n, n2)));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    private boolean isMemberProperty(String string) {
        if (string.startsWith("_")) {
            String string2 = string.substring(1);
            if (string2.startsWith("-") || string2.startsWith("0")) {
                return false;
            }
            try {
                Integer.parseInt(string2);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    new BigInteger(string2);
                    return true;
                }
                catch (NumberFormatException numberFormatException2) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean isKnownRDFProperty(String string) {
        return knownRDFProperties.contains(string);
    }

    private void putElementQname(String string, String string2, String string3, Location location) throws SAXException {
        Warn warn = null;
        if (string.equals(rdfns)) {
            Integer n = (Integer)rdfnames.get(string2);
            if (n == null) {
                if (this.isMemberProperty(string2)) {
                    this.pipe.putNextToken(new ARPQname(15, location, string, string2, string3));
                    return;
                }
                if (!knownRDFTypes.contains(string2) && !this.isKnownRDFProperty(string2)) {
                    warn = new Warn(113, location, "Creating statement(s) for unknown RDF element: '<rdf:" + string2 + "'.");
                }
            } else {
                this.pipe.putNextToken(new ARPQname(n, location, string, string2, string3));
                return;
            }
        }
        this.pipe.putNextToken(new ARPQname(13, location, string, string2, string3));
        if (warn != null) {
            this.pipe.putNextToken(warn);
        }
    }

    private void putAttributeQname(String string, String string2, String string3, Location location) throws SAXException {
        if (string.equals(rdfns)) {
            if (this.isMemberProperty(string2)) {
                this.pipe.putNextToken(new ARPQname(11, location, string, string2, string3));
                return;
            }
            if (!this.isKnownRDFProperty(string2)) {
                this.putWarning(103, location, "Creating statement for unknown RDF property: 'rdf:" + string2 + "'.");
            }
        }
        this.pipe.putNextToken(new ARPQname(9, location, string, string2, string3));
    }

    static {
        XMLCharacterProperties.initCharFlags();
        rdfns = "http://www.w3.org/1999/02/22-rdf-syntax-ns#".intern();
        xmlns = "http://www.w3.org/XML/1998/namespace".intern();
        rdfnames = new HashMap();
        rdfnames.put("Description", new Integer(4));
        rdfnames.put("RDF", new Integer(2));
        rdfnames.put("li", new Integer(14));
        knownRDFProperties = new HashSet();
        knownRDFTypes = new HashSet();
        knownRDFTypes.add("Bag");
        knownRDFTypes.add("Seq");
        knownRDFTypes.add("Alt");
        knownRDFTypes.add("Property");
        knownRDFProperties.add("type");
        knownRDFTypes.add("Statement");
        knownRDFProperties.add("subject");
        knownRDFProperties.add("predicate");
        knownRDFProperties.add("object");
        knownRDFProperties.add("value");
        specialAtts = new String[]{"base", "lang", "space", "ID", "about", "aboutEach", "bagID", "resource", "parseType", "type"};
        specialNameSpaces = new String[]{xmlns, xmlns, xmlns, rdfns, rdfns, rdfns, rdfns, rdfns, rdfns, rdfns};
        A_XMLSPACE = -1;
        specialAttValues = new int[]{21, 22, A_XMLSPACE, 5, 6, 7, 8, 20, 16, 12};
        defaultErrorMode = new int[400];
        int n = 0;
        while (n < defaultErrorMode.length) {
            ARPFilter.defaultErrorMode[n] = n / 100;
            ++n;
        }
    }
}

