/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryEntryType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryInfoType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryServiceImpl
extends AbstractWebServicesService
implements RepositoryService {
    private final AbstractPortProvider portProvider;

    public RepositoryServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort();
        ArrayList<RepositoryInfo> infos = null;
        try {
            List entries = port.getRepositories(Converter.convert((ExtensionsData)extension));
            if (entries != null) {
                infos = new ArrayList<RepositoryInfo>();
                for (CmisRepositoryEntryType entry : entries) {
                    CmisRepositoryInfoType info = port.getRepositoryInfo(entry.getRepositoryId(), null);
                    infos.add(Converter.convert((CmisRepositoryInfoType)info));
                }
            }
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
        return infos;
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort();
        try {
            RepositoryInfo repositoryInfo = Converter.convert((CmisRepositoryInfoType)port.getRepositoryInfo(repositoryId, Converter.convert((ExtensionsData)extension)));
            return repositoryInfo;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort();
        try {
            TypeDefinition typeDefinition = Converter.convert((CmisTypeDefinitionType)port.getTypeDefinition(repositoryId, typeId, Converter.convert((ExtensionsData)extension)));
            return typeDefinition;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort();
        try {
            TypeDefinitionList typeDefinitionList = Converter.convert((CmisTypeDefinitionListType)port.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, Converter.convert((ExtensionsData)extension)));
            return typeDefinitionList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort();
        try {
            List list = Converter.convertTypeContainerList((List)port.getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, Converter.convert((ExtensionsData)extension)));
            return list;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

