/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.PortalIncludeUtil;
import com.liferay.portal.kernel.servlet.taglib.BaseBodyTagSupport;
import com.liferay.portal.kernel.servlet.taglib.FileAvailabilityUtil;
import com.liferay.portal.kernel.servlet.taglib.aui.ScriptData;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.taglib.aui.ScriptTag;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTag;

public class IconMenuTag
extends BaseBodyTagSupport
implements BodyTag {
    private static final String _AUI_PATH = "../aui/";
    private static final int _DEFAULT_MAX_DISPLAY_ITEMS = GetterUtil.getInteger((String)PropsUtil.get((String)"icon.menu.max.display.items"));
    private static final String _END_PAGE = "/html/taglib/ui/icon_menu/end.jsp";
    private static final String _START_PAGE = "/html/taglib/ui/icon_menu/start.jsp";
    private String _cssClass;
    private String _direction = "left";
    private boolean _disabled;
    private String _endPage;
    private boolean _extended = true;
    private String _icon;
    private String _id;
    private boolean _localizeMessage = true;
    private int _maxDisplayItems = _DEFAULT_MAX_DISPLAY_ITEMS;
    private String _message = "actions";
    private boolean _select;
    private boolean _showArrow = true;
    private boolean _showExpanded;
    private boolean _showWhenSingleIcon;
    private String _startPage;
    private String _triggerCssClass;
    private boolean _useIconCaret;

    public int doAfterBody() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        IntegerWrapper iconCount = (IntegerWrapper)request.getAttribute("liferay-ui:icon-menu:icon-count");
        Boolean singleIcon = (Boolean)request.getAttribute("liferay-ui:icon-menu:single-icon");
        if (iconCount != null && iconCount.getValue() == 1 && singleIcon == null) {
            this.bodyContent.clearBody();
            ScriptData scriptData = (ScriptData)request.getAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA");
            if (scriptData != null) {
                scriptData.reset();
            }
            request.setAttribute("liferay-ui:icon-menu:single-icon", (Object)Boolean.TRUE);
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            int n = this.processEndTag();
            return n;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            if (!ServerDetector.isResin()) {
                this._cssClass = null;
                this._direction = "left";
                this._endPage = null;
                this._extended = true;
                this._icon = null;
                this._id = null;
                this._localizeMessage = true;
                this._maxDisplayItems = _DEFAULT_MAX_DISPLAY_ITEMS;
                this._message = "actions";
                this._select = false;
                this._showArrow = true;
                this._showExpanded = false;
                this._showWhenSingleIcon = false;
                this._startPage = null;
                this._triggerCssClass = null;
            }
        }
    }

    public int doStartTag() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ScriptData scriptData = (ScriptData)request.getAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA");
        if (scriptData != null) {
            scriptData.mark();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (this._direction == null) {
            this._direction = "left";
        }
        if (this._icon == null) {
            this._icon = String.valueOf(themeDisplay.getPathThemeImages()) + "/common/tool.png";
        }
        if (Validator.isNull((String)this._id)) {
            this._id = (String)request.getAttribute("liferay-ui:search-container-row:rowId");
            if (Validator.isNull((String)this._id)) {
                this._id = PortalUtil.generateRandomKey((HttpServletRequest)request, (String)IconMenuTag.class.getName());
            }
            this._id = this._id.concat("_menu");
        }
        request.setAttribute("liferay-ui:icon-menu:id", (Object)this._id);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String namespace = portletDisplay.getNamespace();
        this._id = namespace.concat(this._id);
        request.setAttribute("liferay-ui:icon-menu:icon-count", (Object)new IntegerWrapper());
        request.setAttribute("liferay-ui:icon-menu:showWhenSingleIcon", (Object)String.valueOf(this._showWhenSingleIcon));
        return 2;
    }

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    public void setDirection(String direction) {
        this._direction = direction;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public void setEndPage(String endPage) {
        this._endPage = endPage;
    }

    public void setExtended(boolean extended) {
        this._extended = extended;
    }

    public void setIcon(String icon) {
        this._icon = icon;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setLocalizeMessage(boolean localizeMessage) {
        this._localizeMessage = localizeMessage;
    }

    public void setMaxDisplayItems(int maxDisplayItems) {
        if (maxDisplayItems <= 0) {
            maxDisplayItems = _DEFAULT_MAX_DISPLAY_ITEMS;
        }
        this._maxDisplayItems = maxDisplayItems;
    }

    public void setMessage(String message) {
        if (message != null) {
            this._message = message;
        }
    }

    public void setSelect(boolean select) {
        this._select = select;
    }

    public void setShowArrow(boolean showArrow) {
        this._showArrow = showArrow;
    }

    public void setShowExpanded(boolean showExpanded) {
        this._showExpanded = showExpanded;
    }

    public void setShowWhenSingleIcon(boolean showWhenSingleIcon) {
        this._showWhenSingleIcon = showWhenSingleIcon;
    }

    public void setStartPage(String startPage) {
        this._startPage = startPage;
    }

    public void setTriggerCssClass(String triggerCssClass) {
        this._triggerCssClass = triggerCssClass;
    }

    public void setUseIconCaret(boolean useIconCaret) {
        this._useIconCaret = useIconCaret;
    }

    protected String getEndPage() {
        if (Validator.isNull((String)this._endPage)) {
            return _END_PAGE;
        }
        return this._endPage;
    }

    protected String getStartPage() {
        if (Validator.isNull((String)this._startPage)) {
            return _START_PAGE;
        }
        return this._startPage;
    }

    protected int processEndTag() throws Exception {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        IntegerWrapper iconCount = (IntegerWrapper)request.getAttribute("liferay-ui:icon-menu:icon-count");
        request.removeAttribute("liferay-ui:icon-menu:icon-count");
        request.removeAttribute("liferay-ui:icon-menu:id");
        Boolean singleIcon = (Boolean)request.getAttribute("liferay-ui:icon-menu:single-icon");
        request.removeAttribute("liferay-ui:icon-menu:single-icon");
        JspWriter jspWriter = this.pageContext.getOut();
        if (iconCount != null && iconCount.getValue() >= 1 && (singleIcon == null || this._showWhenSingleIcon)) {
            if (!FileAvailabilityUtil.isAvailable((ServletContext)this.pageContext.getServletContext(), (String)this.getStartPage())) {
                if (this._showExpanded) {
                    jspWriter.write("<ul class=\"lfr-menu-expanded ");
                    jspWriter.write("lfr-menu-list");
                    if (Validator.isNotNull((String)this._cssClass)) {
                        jspWriter.write(" ");
                        jspWriter.print(this._cssClass);
                    }
                    jspWriter.write("\" id=\"");
                    jspWriter.write(this._id);
                    jspWriter.write("\">");
                } else {
                    jspWriter.write("<div class=\"btn-group lfr-icon-menu");
                    if (Validator.isNotNull((String)this._cssClass)) {
                        jspWriter.write(" ");
                        jspWriter.print(this._cssClass);
                    }
                    if (this._direction.equals("up")) {
                        jspWriter.write(" dropup");
                    }
                    jspWriter.write("\"><a class=\"dropdown-toggle direction-");
                    jspWriter.write(this._direction);
                    jspWriter.write(" max-display-items-");
                    jspWriter.write(String.valueOf(this._maxDisplayItems));
                    if (this._disabled) {
                        jspWriter.write(" disabled");
                    }
                    if (this._extended) {
                        jspWriter.write(" btn");
                    }
                    if (this._select) {
                        jspWriter.write(" select");
                    }
                    if (Validator.isNotNull((String)this._triggerCssClass)) {
                        jspWriter.write(" " + this._triggerCssClass);
                    }
                    String message = this._message;
                    if (this._localizeMessage) {
                        message = LanguageUtil.get((PageContext)this.pageContext, (String)this._message);
                    }
                    jspWriter.write("\" href=\"javascript:;\" id=\"");
                    jspWriter.write(this._id);
                    jspWriter.write("\" title=\"");
                    jspWriter.write(message);
                    jspWriter.write("\">");
                    if (this._showArrow && this._direction.equals("left")) {
                        String caret = "caret";
                        if (this._useIconCaret) {
                            caret = "icon-caret-left";
                        }
                        jspWriter.write("<i class=\"");
                        jspWriter.write(caret);
                        jspWriter.write("\"></i> ");
                    }
                    boolean auiImage = false;
                    if (Validator.isNotNull((String)this._icon)) {
                        auiImage = this._icon.startsWith(_AUI_PATH);
                        if (auiImage) {
                            jspWriter.write(" <i class=\"icon-");
                            jspWriter.write(this._icon.substring(_AUI_PATH.length()));
                            jspWriter.write("\"></i>");
                        } else {
                            jspWriter.write("<img alt=\"\" src=\"");
                            jspWriter.write(this._icon);
                            jspWriter.write("\" /> ");
                        }
                    }
                    if (Validator.isNotNull((String)message)) {
                        jspWriter.write("<span class=\"lfr-icon-menu-text\">");
                        jspWriter.write(message);
                        jspWriter.write("</span>");
                    }
                    if (this._showArrow && !this._direction.equals("left")) {
                        String caret = "caret";
                        if (this._useIconCaret) {
                            caret = "icon-caret-" + this._direction;
                        }
                        jspWriter.write("<i class=\"");
                        jspWriter.write(caret);
                        jspWriter.write("\"></i> ");
                    }
                    jspWriter.write("</a>");
                    ScriptTag.doTag(null, "liferay-menu", "Liferay.Menu.register('" + this._id + "');", this.bodyContent, this.pageContext);
                    jspWriter.write("<ul class=\"dropdown-menu lfr-menu-list");
                    jspWriter.write(" direction-");
                    jspWriter.write(this._direction);
                    jspWriter.write("\">");
                }
            } else {
                PortalIncludeUtil.include((PageContext)this.pageContext, (String)this.getStartPage());
            }
        }
        this.writeBodyContent((Writer)jspWriter);
        if (iconCount != null && iconCount.getValue() >= 1 && (singleIcon == null || this._showWhenSingleIcon)) {
            if (!FileAvailabilityUtil.isAvailable((ServletContext)this.pageContext.getServletContext(), (String)this.getEndPage())) {
                jspWriter.write("</ul>");
                if (this._showExpanded) {
                    ScriptTag.doTag(null, "liferay-menu", "Liferay.Menu.handleFocus('#" + this._id + "menu');", this.bodyContent, this.pageContext);
                } else {
                    jspWriter.write("</div>");
                }
            } else {
                PortalIncludeUtil.include((PageContext)this.pageContext, (String)this.getEndPage());
            }
        }
        request.removeAttribute("liferay-ui:icon-menu:showWhenSingleIcon");
        return 6;
    }
}

