/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.MultiOperandInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.MethodHandle;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.StringLiteral;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.interpreter.InlineMethodHint;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallInstr
extends MultiOperandInstr {
    private Operand receiver;
    private Operand[] arguments;
    MethAddr methAddr;
    Operand closure;
    private boolean _flagsComputed;
    private boolean _canBeEval;
    private boolean _requiresBinding;
    public HashMap<DynamicMethod, Integer> _profile;

    public CallInstr(Variable result2, MethAddr methAddr, Operand receiver2, Operand[] args2, Operand closure) {
        super(Operation.CALL, result2);
        this.receiver = receiver2;
        this.arguments = args2;
        this.methAddr = methAddr;
        this.closure = closure;
        this._flagsComputed = false;
        this._canBeEval = true;
        this._requiresBinding = true;
    }

    public CallInstr(Operation op, Variable result2, MethAddr methAddr, Operand receiver2, Operand[] args2, Operand closure) {
        super(op, result2);
        this.receiver = receiver2;
        this.arguments = args2;
        this.methAddr = methAddr;
        this.closure = closure;
        this._flagsComputed = false;
        this._canBeEval = true;
        this._requiresBinding = true;
    }

    @Override
    public Operand[] getOperands() {
        return CallInstr.buildAllArgs(this.methAddr, this.receiver, this.arguments, this.closure);
    }

    public void setMethodAddr(MethAddr mh) {
        this.methAddr = mh;
    }

    public MethAddr getMethodAddr() {
        return this.methAddr;
    }

    public Operand getClosureArg() {
        return this.closure;
    }

    public Operand getReceiver() {
        return this.receiver;
    }

    public Operand[] getCallArgs() {
        return this.arguments;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
        this.receiver = this.receiver.getSimplifiedOperand(valueMap);
        this.methAddr = (MethAddr)this.methAddr.getSimplifiedOperand(valueMap);
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            this.arguments[i2] = this.arguments[i2].getSimplifiedOperand(valueMap);
        }
        if (this.closure != null) {
            this.closure = this.closure.getSimplifiedOperand(valueMap);
        }
        this._flagsComputed = false;
    }

    public Operand[] cloneCallArgs(InlinerInfo ii) {
        int length2 = this.arguments.length;
        Operand[] clonedArgs = new Operand[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            clonedArgs[i2] = this.arguments[i2].cloneForInlining(ii);
        }
        return clonedArgs;
    }

    public boolean isRubyInternalsCall() {
        return false;
    }

    public boolean isStaticCallTarget() {
        return this.getTargetMethod() != null;
    }

    public IRMethod getTargetMethodWithReceiver(Operand receiver2) {
        String mname = this.methAddr.getName();
        if (receiver2 instanceof MetaObject) {
            IRModule m = (IRModule)((MetaObject)receiver2).scope;
            return m.getClassMethod(mname);
        }
        if (receiver2 instanceof LocalVariable && ((LocalVariable)receiver2).isSelf()) {
            return null;
        }
        IRClass c = receiver2.getTargetClass();
        return c == null ? null : c.getInstanceMethod(mname);
    }

    public IRMethod getTargetMethod() {
        return this.getTargetMethodWithReceiver(this.getReceiver());
    }

    public boolean canModifyCode() {
        IRMethod method2 = this.getTargetMethod();
        return method2 == null ? true : method2.modifiesCode();
    }

    private boolean getEvalFlag() {
        Operand[] args2;
        String mname = this.getMethodAddr().getName();
        if (mname.equals("call") || mname.equals("eval")) {
            return true;
        }
        if (mname.equals("send") && (args2 = this.getCallArgs()).length >= 2) {
            Operand meth = args2[0];
            if (!(meth instanceof StringLiteral)) {
                return true;
            }
            String name2 = ((StringLiteral)meth)._str_value;
            if (name2.equals("call") || name2.equals("eval") || name2.equals("send")) {
                return true;
            }
        }
        return false;
    }

    private boolean getRequiresBindingFlag() {
        String mname;
        if (this.canBeEval()) {
            return true;
        }
        if (this.closure != null) {
            if (!(this.closure instanceof MetaObject)) {
                return false;
            }
            IRClosure cl = (IRClosure)((MetaObject)this.closure).scope;
            if (cl.requiresBinding()) {
                return true;
            }
        }
        if ((mname = this.getMethodAddr().getName()).equals("lambda")) {
            return true;
        }
        if (mname.equals("new")) {
            Operand object = this.getReceiver();
            if (!(object instanceof MetaObject)) {
                return true;
            }
            IRScope c = ((MetaObject)object).scope;
            if (c instanceof IRClass && c.getName().equals("Proc")) {
                return true;
            }
        }
        return false;
    }

    private void computeFlags() {
        this._flagsComputed = true;
        this._canBeEval = this.getEvalFlag();
        this._requiresBinding = this._canBeEval ? true : this.getRequiresBindingFlag();
    }

    public boolean canBeEval() {
        if (!this._flagsComputed) {
            this.computeFlags();
        }
        return this._canBeEval;
    }

    public boolean requiresBinding() {
        if (!this._flagsComputed) {
            this.computeFlags();
        }
        return this._requiresBinding;
    }

    public boolean canCaptureCallersBinding() {
        Operand r = this.getReceiver();
        IRMethod rm = this.getTargetMethodWithReceiver(r);
        return rm == null || rm.canCaptureCallersBinding();
    }

    public boolean isLVADataflowBarrier() {
        return this.canBeEval() || this.getClosureArg() != null && this.canCaptureCallersBinding();
    }

    @Override
    public String toString() {
        return "\t" + (this.result == null ? "" : this.result + " = ") + (Object)((Object)this.operation) + "(" + this.methAddr + ", " + this.receiver + ", " + Arrays.toString(this.getCallArgs()) + (this.closure == null ? "" : ", &" + this.closure) + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new CallInstr(ii.getRenamedVariable(this.result), (MethAddr)this.methAddr.cloneForInlining(ii), this.receiver.cloneForInlining(ii), this.cloneCallArgs(ii), this.closure == null ? null : this.closure.cloneForInlining(ii));
    }

    private static Operand[] buildAllArgs(Operand methAddr, Operand receiver2, Operand[] callArgs, Operand closure) {
        Operand[] allArgs = new Operand[callArgs.length + 2 + (closure != null ? 1 : 0)];
        assert (methAddr != null) : "METHADDR is null";
        assert (receiver2 != null) : "RECEIVER is null";
        allArgs[0] = methAddr;
        allArgs[1] = receiver2;
        for (int i2 = 0; i2 < callArgs.length; ++i2) {
            assert (callArgs[i2] != null) : "ARG " + i2 + " is null";
            allArgs[i2 + 2] = callArgs[i2];
        }
        if (closure != null) {
            allArgs[callArgs.length + 2] = closure;
        }
        return allArgs;
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        IRubyObject resultValue;
        Object ma = this.methAddr.retrieve(interp);
        IRubyObject[] args2 = this.prepareArguments(this.getCallArgs(), interp);
        if (ma instanceof MethodHandle) {
            MethodHandle mh = (MethodHandle)ma;
            assert (mh.getMethodNameOperand() == this.getReceiver());
            DynamicMethod m = mh.getResolvedMethod();
            String mn = mh.getResolvedMethodName();
            IRubyObject ro = mh.getReceiverObj();
            if (m.isUndefined()) {
                resultValue = RuntimeHelpers.callMethodMissing(interp.getContext(), ro, m.getVisibility(), mn, CallType.FUNCTIONAL, args2, this.prepareBlock(interp));
            } else {
                try {
                    resultValue = m.call(interp.getContext(), ro, (RubyModule)ro.getMetaClass(), mn, args2, this.prepareBlock(interp));
                }
                catch (JumpException.BreakJump bj) {
                    resultValue = (IRubyObject)bj.getValue();
                }
            }
        } else {
            IRubyObject object = (IRubyObject)this.getReceiver().retrieve(interp);
            String name2 = ma.toString();
            try {
                resultValue = object.callMethod(interp.getContext(), name2, args2, this.prepareBlock(interp));
            }
            catch (JumpException.BreakJump bj) {
                resultValue = (IRubyObject)bj.getValue();
            }
        }
        this.getResult().store(interp, resultValue);
        return null;
    }

    public Label interpret_with_inline(InterpreterContext interp, IRubyObject self) {
        IRubyObject resultValue;
        Object ma = this.methAddr.retrieve(interp);
        IRubyObject[] args2 = this.prepareArguments(this.getCallArgs(), interp);
        if (ma instanceof MethodHandle) {
            MethodHandle mh = (MethodHandle)ma;
            assert (mh.getMethodNameOperand() == this.getReceiver());
            DynamicMethod m = mh.getResolvedMethod();
            String mn = mh.getResolvedMethodName();
            IRubyObject ro = mh.getReceiverObj();
            if (m.isUndefined()) {
                resultValue = RuntimeHelpers.callMethodMissing(interp.getContext(), ro, m.getVisibility(), mn, CallType.FUNCTIONAL, args2, this.prepareBlock(interp));
            } else {
                Integer count2;
                ThreadContext tc = interp.getContext();
                RubyClass rc = ro.getMetaClass();
                if (this._profile == null) {
                    this._profile = new HashMap();
                }
                if ((count2 = this._profile.get(m)) == null) {
                    count2 = new Integer(1);
                } else if ((count2 = new Integer(count2 + 1)) > 50 && m instanceof InterpretedIRMethod && this._profile.size() == 1) {
                    IRMethod inlineableMethod = ((InterpretedIRMethod)m).method;
                    this._profile.remove(m);
                    throw new InlineMethodHint(inlineableMethod);
                }
                this._profile.put(m, count2);
                resultValue = m.call(tc, ro, (RubyModule)rc, mn, args2, this.prepareBlock(interp));
            }
        } else {
            IRubyObject object = (IRubyObject)this.getReceiver().retrieve(interp);
            String name2 = ma.toString();
            resultValue = object.callMethod(interp.getContext(), name2, args2, this.prepareBlock(interp));
        }
        this.getResult().store(interp, resultValue);
        return null;
    }

    private Block prepareBlock(InterpreterContext interp) {
        if (this.closure == null) {
            return Block.NULL_BLOCK;
        }
        Object value2 = this.closure.retrieve(interp);
        return value2 instanceof RubyProc ? ((RubyProc)value2).getBlock() : (Block)value2;
    }
}

