/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer.impl;

import javax.xml.namespace.QName;
import org.apache.abdera.ext.serializer.Conventions;
import org.apache.abdera.ext.serializer.ObjectContext;
import org.apache.abdera.ext.serializer.SerializationContext;
import org.apache.abdera.ext.serializer.annotation.Author;
import org.apache.abdera.ext.serializer.annotation.Category;
import org.apache.abdera.ext.serializer.annotation.Contributor;
import org.apache.abdera.ext.serializer.annotation.ID;
import org.apache.abdera.ext.serializer.annotation.Icon;
import org.apache.abdera.ext.serializer.annotation.Link;
import org.apache.abdera.ext.serializer.annotation.Logo;
import org.apache.abdera.ext.serializer.annotation.Rights;
import org.apache.abdera.ext.serializer.annotation.Subtitle;
import org.apache.abdera.ext.serializer.annotation.Title;
import org.apache.abdera.ext.serializer.annotation.Updated;
import org.apache.abdera.ext.serializer.impl.CategorySerializer;
import org.apache.abdera.ext.serializer.impl.DateTimeSerializer;
import org.apache.abdera.ext.serializer.impl.ElementSerializer;
import org.apache.abdera.ext.serializer.impl.IRISerializer;
import org.apache.abdera.ext.serializer.impl.LinkSerializer;
import org.apache.abdera.ext.serializer.impl.PersonSerializer;
import org.apache.abdera.ext.serializer.impl.TextSerializer;
import org.apache.abdera.util.Constants;

public class SourceSerializer
extends ElementSerializer {
    public SourceSerializer() {
        super(Constants.SOURCE);
    }

    protected SourceSerializer(QName qname) {
        super(qname);
    }

    protected void process(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        this.writeAttributes(source, objectContext, context, conventions);
        this.writeElement(ID.class, new IRISerializer(Constants.ID), source, objectContext, context, conventions);
        this.writeElement(Icon.class, new IRISerializer(Constants.ICON), source, objectContext, context, conventions);
        this.writeElement(Logo.class, new IRISerializer(Constants.LOGO), source, objectContext, context, conventions);
        this.writeElement(Title.class, new TextSerializer(Constants.TITLE), source, objectContext, context, conventions);
        this.writeElement(Subtitle.class, new TextSerializer(Constants.SUBTITLE), source, objectContext, context, conventions);
        this.writeElement(Rights.class, new TextSerializer(Constants.RIGHTS), source, objectContext, context, conventions);
        this.writeElement(Updated.class, new DateTimeSerializer(Constants.UPDATED), source, objectContext, context, conventions);
        this.writeElements(Link.class, new LinkSerializer(), source, objectContext, context, conventions);
        this.writeElements(Category.class, new CategorySerializer(), source, objectContext, context, conventions);
        this.writeElements(Author.class, new PersonSerializer(Constants.AUTHOR), source, objectContext, context, conventions);
        this.writeElements(Contributor.class, new PersonSerializer(Constants.CONTRIBUTOR), source, objectContext, context, conventions);
        this.writeExtensions(source, objectContext, context, conventions);
    }
}

