/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.sharing;

import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.abdera.ext.sharing.SharingHelper;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ElementWrapper;

public class History
extends ElementWrapper {
    public History(Element internal) {
        super(internal);
    }

    public History(Factory factory, QName qname) {
        super(factory, qname);
    }

    public int getSequence() {
        String sequence = this.getAttributeValue("sequence");
        return sequence != null ? Integer.parseInt(sequence) : 0;
    }

    public void setSequence(int sequence) {
        if (sequence > 0) {
            this.setAttributeValue("sequence", Integer.toString(sequence));
        } else {
            this.removeAttribute(new QName("sequence"));
        }
    }

    public Date getWhen() {
        String when = this.getAttributeValue("when");
        return when != null ? AtomDate.parse(when) : null;
    }

    public void setWhen(Date when) {
        if (when != null) {
            this.setAttributeValue("when", AtomDate.format(when));
        } else {
            this.removeAttribute(new QName("when"));
        }
    }

    public String getBy() {
        return this.getAttributeValue("by");
    }

    public void setBy(String by) {
        if (by != null) {
            if (!SharingHelper.isValidEndpointIdentifier(by)) {
                throw new IllegalArgumentException("Invalid Endpoint Identifier");
            }
            this.setAttributeValue("by", by);
        } else {
            this.removeAttribute(new QName("by"));
        }
    }
}

