/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ccpp;

import com.sun.ccpp.AttributeDescriptionImpl;
import com.sun.ccpp.AttributeImpl;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ccpp.Attribute;
import javax.ccpp.Component;
import javax.ccpp.ComponentDescription;

public class ComponentImpl
implements Component {
    private HashMap attrsByURI = new HashMap();
    private HashMap attrsByName = new HashMap();
    private ComponentDescription description = null;
    private String name = null;

    ComponentImpl() {
    }

    void mergeComponent(Component other) {
        Iterator i = other.getAttributes().iterator();
        while (i.hasNext()) {
            Attribute otherAttr = (Attribute)i.next();
            AttributeDescriptionImpl attrDescImpl = (AttributeDescriptionImpl)otherAttr.getDescription();
            URI uri = attrDescImpl.getURIObject();
            Attribute thisAttr = this.getAttribute(uri);
            if (thisAttr == null) {
                thisAttr = (AttributeImpl)((AttributeImpl)otherAttr).clone();
            } else {
                ((AttributeImpl)thisAttr).mergeAttribute(otherAttr);
            }
            this.addAttribute(thisAttr);
        }
    }

    void addAttribute(Attribute attr) {
        if (attr == null) {
            return;
        }
        AttributeDescriptionImpl desc = (AttributeDescriptionImpl)attr.getDescription();
        if (desc != null) {
            this.attrsByURI.put(desc.getURIObject(), attr);
            this.attrsByName.put(desc.getName(), attr);
        }
    }

    void removeAttribute(Attribute attr) {
        if (attr == null) {
            return;
        }
        AttributeDescriptionImpl desc = (AttributeDescriptionImpl)attr.getDescription();
        if (desc != null) {
            this.attrsByURI.remove(desc.getURIObject());
            this.attrsByName.remove(desc.getName());
        }
    }

    void setDescription(ComponentDescription description) {
        this.description = description;
    }

    void setName(String name) {
        this.name = name;
    }

    public Object clone() {
        ComponentImpl clone = new ComponentImpl();
        clone.description = this.description;
        clone.name = this.name;
        Iterator i = this.getAttributes().iterator();
        while (i.hasNext()) {
            clone.addAttribute((AttributeImpl)((AttributeImpl)i.next()).clone());
        }
        return clone;
    }

    public Attribute getAttribute(String name) {
        return (Attribute)this.attrsByName.get(name);
    }

    Attribute getAttribute(URI uri) {
        return (Attribute)this.attrsByURI.get(uri);
    }

    public Set getAttributes() {
        return new HashSet(this.attrsByURI.values());
    }

    public ComponentDescription getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }
}

