/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.poller;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.poller.PollerHeader;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.kernel.poller.PollerResponseClosedException;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;

public class DefaultPollerResponse
implements PollerResponse {
    private String _chunkId;
    private Map<String, Object> _parameterMap = new HashMap<String, Object>();
    private PollerHeader _pollerHeader;
    private String _portletId;
    private Message _responseMessage;

    public DefaultPollerResponse(PollerHeader pollerHeader, String portletId, String chunkId) {
        this._pollerHeader = pollerHeader;
        this._portletId = portletId;
        this._chunkId = chunkId;
    }

    @Override
    public synchronized void close() {
        if (Validator.isNotNull(this._responseMessage)) {
            MessageBusUtil.sendMessage(this._responseMessage.getDestinationName(), this._responseMessage);
            this._responseMessage = null;
        }
    }

    @Override
    public void createResponseMessage(Message message) {
        String responseDestinationName = message.getResponseDestinationName();
        if (Validator.isNull(responseDestinationName)) {
            return;
        }
        this._responseMessage = MessageBusUtil.createResponseMessage(message);
        this._responseMessage.setPayload(this);
    }

    @Override
    public PollerHeader getPollerHeader() {
        return this._pollerHeader;
    }

    @Override
    public String getPortletId() {
        return this._portletId;
    }

    @Override
    public boolean isEmpty() {
        return this._parameterMap.isEmpty();
    }

    @Override
    public synchronized void setParameter(String name, JSONArray value) throws PollerResponseClosedException {
        if (this._responseMessage == null) {
            throw new PollerResponseClosedException();
        }
        this._parameterMap.put(name, value);
    }

    @Override
    public synchronized void setParameter(String name, JSONObject value) throws PollerResponseClosedException {
        if (this._responseMessage == null) {
            throw new PollerResponseClosedException();
        }
        this._parameterMap.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(String name, String value) throws PollerResponseClosedException {
        DefaultPollerResponse defaultPollerResponse = this;
        synchronized (defaultPollerResponse) {
            if (this._responseMessage == null) {
                throw new PollerResponseClosedException();
            }
            this._parameterMap.put(name, value);
        }
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject pollerResponseJSONObject = JSONFactoryUtil.createJSONObject();
        pollerResponseJSONObject.put("portletId", this._portletId);
        if (Validator.isNotNull(this._chunkId)) {
            pollerResponseJSONObject.put("chunkId", this._chunkId);
        }
        JSONObject dataJSONObject = JSONFactoryUtil.createJSONObject();
        for (Map.Entry<String, Object> entry : this._parameterMap.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONArray) {
                dataJSONObject.put(name, (JSONArray)value);
                continue;
            }
            if (value instanceof JSONObject) {
                dataJSONObject.put(name, (JSONObject)value);
                continue;
            }
            dataJSONObject.put(name, String.valueOf(value));
        }
        pollerResponseJSONObject.put("data", dataJSONObject);
        return pollerResponseJSONObject;
    }
}

