/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.MembershipRequest;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.UserModelImpl;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.ldap.LDAPUserTransactionThreadLocal;
import com.liferay.portal.security.ldap.PortalLDAPExporterUtil;
import com.liferay.portal.service.MembershipRequestLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UserListener
extends BaseModelListener<User> {
    public void onAfterAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        try {
            if (associationClassName.equals(Group.class.getName())) {
                long userId = (Long)classPK;
                long groupId = (Long)associationClassPK;
                this.updateMembershipRequestStatus(userId, groupId);
            }
        }
        catch (Exception e2) {
            throw new ModelListenerException((Throwable)e2);
        }
    }

    public void onAfterCreate(User user) throws ModelListenerException {
        try {
            this.exportToLDAP(user);
        }
        catch (Exception e2) {
            throw new ModelListenerException((Throwable)e2);
        }
    }

    public void onAfterUpdate(User user) throws ModelListenerException {
        try {
            this.exportToLDAP(user);
        }
        catch (Exception e2) {
            throw new ModelListenerException((Throwable)e2);
        }
    }

    public void onBeforeUpdate(User user) {
        UserModelImpl userModelImpl = (UserModelImpl)user;
        LDAPUserTransactionThreadLocal.setOriginalEmailAddress(userModelImpl.getOriginalEmailAddress());
    }

    protected void exportToLDAP(User user) throws Exception {
        if (user.isDefaultUser() || LDAPUserTransactionThreadLocal.isOriginatesFromLDAP()) {
            return;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Map expandoBridgeAttributes = null;
        if (serviceContext != null) {
            expandoBridgeAttributes = serviceContext.getExpandoBridgeAttributes();
        }
        PortalLDAPExporterUtil.exportToLDAP((User)user, (Map)expandoBridgeAttributes);
    }

    protected void updateMembershipRequestStatus(long userId, long groupId) throws Exception {
        long principalUserId = GetterUtil.getLong((String)PrincipalThreadLocal.getName());
        User user = UserLocalServiceUtil.getUser((long)userId);
        List membershipRequests = MembershipRequestLocalServiceUtil.getMembershipRequests((long)userId, (long)groupId, (int)0);
        for (MembershipRequest membershipRequest : membershipRequests) {
            MembershipRequestLocalServiceUtil.updateStatus((long)principalUserId, (long)membershipRequest.getMembershipRequestId(), (String)LanguageUtil.get((Locale)user.getLocale(), (String)"your-membership-has-been-approved"), (int)1, (boolean)false, (ServiceContext)new ServiceContext());
        }
    }
}

