/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.security.permission.UserPermissionCheckerBag;
import com.liferay.portal.security.permission.UserPermissionCheckerBagImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.service.permission.LayoutSetPrototypePermissionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PermissionCheckerBagImpl
extends UserPermissionCheckerBagImpl
implements PermissionCheckerBag {
    private Map<Long, Boolean> _contentReviewers = new HashMap<Long, Boolean>();
    private Map<Long, Boolean> _groupAdmins = new HashMap<Long, Boolean>();
    private Map<Long, Boolean> _groupOwners = new HashMap<Long, Boolean>();
    private Map<Long, Boolean> _organizationAdmins = new HashMap<Long, Boolean>();
    private Map<Long, Boolean> _organizationOwners = new HashMap<Long, Boolean>();
    private long[] _roleIds;
    private List<Role> _roles;

    public PermissionCheckerBagImpl() {
        this(0L);
    }

    public PermissionCheckerBagImpl(long userId) {
        this(userId, Collections.emptyList());
    }

    public PermissionCheckerBagImpl(long userId, List<Group> userGroups, List<Organization> userOrgs, List<Group> userOrgGroups, List<Group> userUserGroupGroups, List<Role> roles) {
        super(userId, userGroups, userOrgs, userOrgGroups, userUserGroupGroups);
        this._roles = roles;
    }

    public PermissionCheckerBagImpl(long userId, List<Role> roles) {
        super(userId);
        this._roles = roles;
    }

    public PermissionCheckerBagImpl(UserPermissionCheckerBag userPermissionCheckerBag, List<Role> roles) {
        super(userPermissionCheckerBag);
        this._roles = roles;
    }

    @Override
    public List<Group> getGroups() {
        return super.getGroups();
    }

    public long[] getRoleIds() {
        if (this._roleIds == null) {
            List<Role> roles = this.getRoles();
            long[] roleIds = new long[roles.size()];
            int i2 = 0;
            while (i2 < roles.size()) {
                Role role = roles.get(i2);
                roleIds[i2] = role.getRoleId();
                ++i2;
            }
            Arrays.sort(roleIds);
            this._roleIds = roleIds;
        }
        return this._roleIds;
    }

    public List<Role> getRoles() {
        return this._roles;
    }

    @Override
    public List<Group> getUserGroups() {
        return super.getUserGroups();
    }

    @Override
    public List<Group> getUserOrgGroups() {
        return super.getUserOrgGroups();
    }

    @Override
    public List<Organization> getUserOrgs() {
        return super.getUserOrgs();
    }

    @Override
    public List<Group> getUserUserGroupGroups() {
        return super.getUserUserGroupGroups();
    }

    public boolean isCommunityAdmin(PermissionChecker permissionChecker, Group group) throws Exception {
        return this.isGroupAdmin(permissionChecker, group);
    }

    public boolean isCommunityOwner(PermissionChecker permissionChecker, Group group) throws Exception {
        return this.isGroupOwner(permissionChecker, group);
    }

    public boolean isContentReviewer(PermissionChecker permissionChecker, Group group) throws Exception {
        Boolean value = this._contentReviewers.get(group.getCompanyId());
        if (value == null) {
            value = this.isContentReviewerImpl(permissionChecker, group);
            this._contentReviewers.put(group.getCompanyId(), value);
        }
        return value;
    }

    public boolean isGroupAdmin(PermissionChecker permissionChecker, Group group) throws Exception {
        Boolean value = this._groupAdmins.get(group.getGroupId());
        if (value == null) {
            value = this.isGroupAdminImpl(permissionChecker, group);
            this._groupAdmins.put(group.getGroupId(), value);
        }
        return value;
    }

    public boolean isGroupMember(PermissionChecker permissionChecker, Group group) throws Exception {
        for (Role role : this._roles) {
            String roleName = role.getName();
            if (!roleName.equals("Site Member")) continue;
            return true;
        }
        List<Group> userGroups = this.getUserGroups();
        return userGroups.contains(group);
    }

    public boolean isGroupOwner(PermissionChecker permissionChecker, Group group) throws Exception {
        Boolean value = this._groupOwners.get(group.getGroupId());
        if (value == null) {
            value = this.isGroupOwnerImpl(permissionChecker, group);
            this._groupOwners.put(group.getGroupId(), value);
        }
        return value;
    }

    public boolean isOrganizationAdmin(PermissionChecker permissionChecker, Organization organization) throws Exception {
        Boolean value = this._organizationAdmins.get(organization.getOrganizationId());
        if (value == null) {
            value = this.isOrganizationAdminImpl(permissionChecker, organization);
            this._organizationAdmins.put(organization.getOrganizationId(), value);
        }
        return value;
    }

    public boolean isOrganizationOwner(PermissionChecker permissionChecker, Organization organization) throws Exception {
        Boolean value = this._organizationOwners.get(organization.getOrganizationId());
        if (value == null) {
            value = this.isOrganizationOwnerImpl(permissionChecker, organization);
            this._organizationOwners.put(organization.getOrganizationId(), value);
        }
        return value;
    }

    protected boolean isContentReviewerImpl(PermissionChecker permissionChecker, Group group) throws PortalException, SystemException {
        if (permissionChecker.isCompanyAdmin() || permissionChecker.isGroupAdmin(group.getGroupId())) {
            return true;
        }
        if (RoleLocalServiceUtil.hasUserRole((long)this.getUserId(), (long)group.getCompanyId(), (String)"Portal Content Reviewer", (boolean)true)) {
            return true;
        }
        return group.isSite() && UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)group.getGroupId(), (String)"Site Content Reviewer", (boolean)true);
    }

    protected boolean isGroupAdminImpl(PermissionChecker permissionChecker, Group group) throws PortalException, SystemException {
        if (group.isLayout()) {
            long parentGroupId = group.getParentGroupId();
            if (parentGroupId == 0L) {
                return false;
            }
            group = GroupLocalServiceUtil.getGroup((long)parentGroupId);
        }
        if (group.isSite() && (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)group.getGroupId(), (String)"Site Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)group.getGroupId(), (String)"Site Owner", (boolean)true))) {
            return true;
        }
        if (group.isCompany()) {
            return permissionChecker.isCompanyAdmin();
        }
        if (group.isLayoutPrototype()) {
            return LayoutPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isLayoutSetPrototype()) {
            return LayoutSetPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            while (organizationId != 0L) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                long organizationGroupId = organization.getGroupId();
                if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)organizationGroupId, (String)"Organization Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                    return true;
                }
                organizationId = organization.getParentOrganizationId();
            }
        }
        return false;
    }

    protected boolean isGroupOwnerImpl(PermissionChecker permissionChecker, Group group) throws PortalException, SystemException {
        if (group.isSite() && UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)group.getGroupId(), (String)"Site Owner", (boolean)true)) {
            return true;
        }
        if (group.isLayoutPrototype()) {
            return LayoutPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isLayoutSetPrototype()) {
            return LayoutSetPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            while (organizationId != 0L) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                long organizationGroupId = organization.getGroupId();
                if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                    return true;
                }
                organizationId = organization.getParentOrganizationId();
            }
        } else if (group.isUser()) {
            long groupUserId = group.getClassPK();
            if (this.getUserId() == groupUserId) {
                return true;
            }
        }
        return false;
    }

    protected boolean isOrganizationAdminImpl(PermissionChecker permissionChecker, Organization organization) throws PortalException, SystemException {
        while (organization != null) {
            long organizationGroupId = organization.getGroupId();
            long userId = this.getUserId();
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)organizationGroupId, (String)"Organization Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }

    protected boolean isOrganizationOwnerImpl(PermissionChecker permissionChecker, Organization organization) throws PortalException, SystemException {
        long userId = this.getUserId();
        while (organization != null) {
            long organizationGroupId = organization.getGroupId();
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }
}

