/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.NoSuchShardException;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Shard;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ShardLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.RobotsUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class VerifyGroup
extends VerifyProcess {
    private static String[] _LEGACY_STAGED_PORTLET_TYPE_SETTINGS_KEYS = new String[]{"staged-portlet_39", "staged-portlet_54", "staged-portlet_56", "staged-portlet_59", "staged-portlet_107", "staged-portlet_108", "staged-portlet_110", "staged-portlet_166", "staged-portlet_169"};
    private static Log _log = LogFactoryUtil.getLog(VerifyGroup.class);

    @Override
    protected void doVerify() throws Exception {
        this.verifyCompanyGroups();
        this.verifyNullFriendlyURLGroups();
        this.verifyOrganizationNames();
        this.verifyRobots();
        this.verifySites();
        this.verifyStagedGroups();
        this.verifyTree();
    }

    protected String getRobots(LayoutSet layoutSet) {
        if (layoutSet == null) {
            return RobotsUtil.getDefaultRobots(null);
        }
        String virtualHostname = "";
        try {
            virtualHostname = layoutSet.getVirtualHostname();
        }
        catch (Exception exception) {}
        return GetterUtil.get((String)layoutSet.getSettingsProperty(String.valueOf(layoutSet.isPrivateLayout()) + "-robots.txt"), (String)RobotsUtil.getDefaultRobots(virtualHostname));
    }

    protected void updateName(long groupId, String name) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update Group_ set name = ? where groupId= " + groupId);
            ps.setString(1, name);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void verifyCompanyGroups() throws Exception {
        List companies = CompanyLocalServiceUtil.getCompanies();
        String currentShardName = ShardUtil.getCurrentShardName();
        for (Company company : companies) {
            String shardName = null;
            try {
                shardName = company.getShardName();
            }
            catch (NoSuchShardException noSuchShardException) {
                Shard shard = ShardLocalServiceUtil.addShard((String)Company.class.getName(), (long)company.getCompanyId(), (String)PropsValues.SHARD_DEFAULT_NAME);
                shardName = shard.getName();
            }
            if (ShardUtil.isEnabled() && !shardName.equals(currentShardName)) continue;
            GroupLocalServiceUtil.checkCompanyGroup((long)company.getCompanyId());
            GroupLocalServiceUtil.checkSystemGroups((long)company.getCompanyId());
        }
    }

    protected void verifyNullFriendlyURLGroups() throws Exception {
        List groups = GroupLocalServiceUtil.getNullFriendlyURLGroups();
        for (Group group : groups) {
            String friendlyURL = "/" + group.getGroupId();
            User user = null;
            if (group.isCompany() && !group.isCompanyStagingGroup()) {
                friendlyURL = "/global";
            } else if (group.isUser()) {
                user = UserLocalServiceUtil.getUserById((long)group.getClassPK());
                friendlyURL = "/" + user.getScreenName();
            } else if (group.getClassPK() > 0L) {
                friendlyURL = "/" + group.getClassPK();
            }
            try {
                GroupLocalServiceUtil.updateFriendlyURL((long)group.getGroupId(), (String)friendlyURL);
            }
            catch (GroupFriendlyURLException gfurle) {
                if (user != null) {
                    long userId = user.getUserId();
                    String screenName = user.getScreenName();
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Updating user screen name " + screenName + " to " + userId + " because it is generating an " + "invalid friendly URL"));
                    }
                    UserLocalServiceUtil.updateScreenName((long)userId, (String)String.valueOf(userId));
                    continue;
                }
                _log.error((Object)("Invalid Friendly URL " + friendlyURL));
                throw gfurle;
            }
        }
    }

    protected void verifyOrganizationNames() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(5);
            sb.append("select groupId, name from Group_ where name like '%");
            sb.append(" LFR_ORGANIZATION");
            sb.append("%' and name not like '%");
            sb.append(" LFR_ORGANIZATION");
            sb.append("'");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                String name = rs.getString("name");
                if (name.endsWith(" LFR_ORGANIZATION") || name.endsWith(" (Staging)")) continue;
                int pos = name.indexOf(" LFR_ORGANIZATION");
                pos = name.indexOf(" ", pos + 1);
                String newName = String.valueOf(name.substring(pos + 1)) + " LFR_ORGANIZATION";
                this.updateName(groupId, newName);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void verifyRobots() throws Exception {
        List groups = GroupLocalServiceUtil.getLiveGroups();
        for (Group group : groups) {
            LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
            LayoutSet publicLayoutSet = group.getPublicLayoutSet();
            String privateLayoutSetRobots = this.getRobots(privateLayoutSet);
            String publicLayoutSetRobots = this.getRobots(publicLayoutSet);
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            typeSettingsProperties.setProperty("true-robots.txt", privateLayoutSetRobots);
            typeSettingsProperties.setProperty("false-robots.txt", publicLayoutSetRobots);
            GroupLocalServiceUtil.updateGroup((long)group.getGroupId(), (String)typeSettingsProperties.toString());
        }
    }

    protected void verifySites() throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(Group.class);
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classNameId", (Object)PortalUtil.getClassNameId(Organization.class)));
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"site", (Object)false));
        List groups = GroupLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (Group group : groups) {
            if (group.getPrivateLayoutsPageCount() <= 0 && group.getPublicLayoutsPageCount() <= 0) continue;
            group.setSite(true);
            GroupLocalServiceUtil.updateGroup((Group)group);
        }
    }

    protected void verifyStagedGroups() throws Exception {
        List groups = GroupLocalServiceUtil.getLiveGroups();
        for (Group group : groups) {
            if (!group.hasStagingGroup()) continue;
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
            typeSettingsProperties.setProperty("stagedRemotely", Boolean.FALSE.toString());
            this.verifyStagingTypeSettingsProperties(typeSettingsProperties);
            GroupLocalServiceUtil.updateGroup((long)group.getGroupId(), (String)typeSettingsProperties.toString());
            Group stagingGroup = group.getStagingGroup();
            if (group.getClassNameId() == stagingGroup.getClassNameId()) continue;
            stagingGroup.setClassNameId(group.getClassNameId());
            GroupLocalServiceUtil.updateGroup((Group)stagingGroup);
        }
    }

    protected void verifyStagingTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        Set keys = typeSettingsProperties.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!ArrayUtil.contains((Object[])_LEGACY_STAGED_PORTLET_TYPE_SETTINGS_KEYS, (Object)key)) continue;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Removing type settings property " + key));
            }
            iterator.remove();
        }
    }

    protected void verifyTree() throws Exception {
        long[] companyIds;
        long[] lArray = companyIds = PortalInstances.getCompanyIdsBySQL();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            GroupLocalServiceUtil.rebuildTree((long)companyId);
            ++n2;
        }
    }
}

