/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.xml.StAXReaderUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import com.liferay.portlet.PortalPreferencesWrapperCacheUtil;
import com.liferay.portlet.PortletPreferencesFactory;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.Preference;
import com.liferay.portlet.StrictPortletPreferencesImpl;
import com.liferay.portlet.portletconfiguration.util.ConfigurationPortletRequest;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PreferencesValidator;
import javax.portlet.filter.PortletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

@DoPrivileged
public class PortletPreferencesFactoryImpl
implements PortletPreferencesFactory {
    private static Log _log = LogFactoryUtil.getLog(PortletPreferencesFactoryImpl.class);
    private PortalCache<String, Map<String, Preference>> _preferencesMapPortalCache = SingleVMPoolUtil.getCache((String)PortletPreferencesFactoryImpl.class.getName());

    public void checkControlPanelPortletPreferences(ThemeDisplay themeDisplay, Portlet portlet) throws PortalException, SystemException {
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        if (!group.isControlPanel()) {
            return;
        }
        String portletId = portlet.getPortletId();
        boolean hasControlPanelAccessPermission = PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (String)portletId);
        if (!hasControlPanelAccessPermission) {
            return;
        }
        PortletPreferences portletSetup = this.getStrictLayoutPortletSetup(layout, portletId);
        if (portletSetup instanceof StrictPortletPreferencesImpl) {
            this.getLayoutPortletSetup(layout, portletId);
        }
        if (portlet.isInstanceable()) {
            return;
        }
        PortletPreferencesIds portletPreferencesIds = this.getPortletPreferencesIds(themeDisplay.getScopeGroupId(), themeDisplay.getUserId(), layout, portletId, false);
        PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.fetchPreferences((PortletPreferencesIds)portletPreferencesIds);
        if (portletPreferences != null) {
            return;
        }
        PortletPreferencesLocalServiceUtil.getPreferences((PortletPreferencesIds)portletPreferencesIds);
    }

    public PortletPreferences fromDefaultXML(String xml) throws SystemException {
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        return new PortletPreferencesImpl(xml, preferencesMap);
    }

    public PortalPreferencesImpl fromXML(long ownerId, int ownerType, String xml) throws SystemException {
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        return new PortalPreferencesImpl(ownerId, ownerType, xml, preferencesMap, false);
    }

    public PortletPreferencesImpl fromXML(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws SystemException {
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        return new PortletPreferencesImpl(companyId, ownerId, ownerType, plid, portletId, xml, preferencesMap);
    }

    public PortalPreferences fromXML(long companyId, long ownerId, int ownerType, String xml) throws SystemException {
        return this.fromXML(ownerId, ownerType, xml);
    }

    public PortletPreferences getLayoutPortletSetup(Layout layout, String portletId) throws SystemException {
        long ownerId = 0L;
        int ownerType = 3;
        if (PortletConstants.hasUserId((String)portletId)) {
            ownerId = PortletConstants.getUserId((String)portletId);
            ownerType = 4;
        }
        return PortletPreferencesLocalServiceUtil.getPreferences((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)layout.getPlid(), (String)portletId);
    }

    public PortalPreferences getPortalPreferences(HttpServletRequest request) throws SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getPortalPreferences(request.getSession(), themeDisplay.getUserId(), themeDisplay.isSignedIn());
    }

    public PortalPreferences getPortalPreferences(HttpSession session, long userId, boolean signedIn) throws SystemException {
        long ownerId = userId;
        int ownerType = 4;
        PortalPreferences portalPreferences = null;
        if (signedIn) {
            PortalPreferencesWrapper portalPreferencesWrapper = PortalPreferencesWrapperCacheUtil.get(ownerId, ownerType);
            if (portalPreferencesWrapper == null) {
                portalPreferencesWrapper = (PortalPreferencesWrapper)PortalPreferencesLocalServiceUtil.getPreferences((long)ownerId, (int)ownerType);
                portalPreferences = portalPreferencesWrapper.getPortalPreferencesImpl();
            } else {
                PortalPreferencesImpl portalPreferencesImpl = portalPreferencesWrapper.getPortalPreferencesImpl();
                portalPreferences = portalPreferencesImpl.clone();
            }
        } else {
            if (session != null) {
                portalPreferences = (PortalPreferences)session.getAttribute("PORTAL_PREFERENCES");
            }
            if (portalPreferences == null) {
                PortalPreferencesWrapper portalPreferencesWrapper = PortalPreferencesWrapperCacheUtil.get(ownerId, ownerType);
                if (portalPreferencesWrapper == null) {
                    portalPreferencesWrapper = (PortalPreferencesWrapper)PortalPreferencesLocalServiceUtil.getPreferences((long)ownerId, (int)ownerType);
                    portalPreferences = portalPreferencesWrapper.getPortalPreferencesImpl();
                } else {
                    PortalPreferencesImpl portalPreferencesImpl = portalPreferencesWrapper.getPortalPreferencesImpl();
                    portalPreferences = portalPreferencesImpl.clone();
                }
                if (session != null) {
                    session.setAttribute("PORTAL_PREFERENCES", (Object)portalPreferences);
                }
            }
        }
        portalPreferences.setSignedIn(signedIn);
        portalPreferences.setUserId(userId);
        return portalPreferences;
    }

    public PortalPreferences getPortalPreferences(HttpSession session, long companyId, long userId, boolean signedIn) throws SystemException {
        return this.getPortalPreferences(session, userId, signedIn);
    }

    public PortalPreferences getPortalPreferences(long userId, boolean signedIn) throws SystemException {
        return this.getPortalPreferences(null, userId, signedIn);
    }

    public PortalPreferences getPortalPreferences(long companyId, long userId, boolean signedIn) throws SystemException {
        return this.getPortalPreferences(userId, signedIn);
    }

    public PortalPreferences getPortalPreferences(PortletRequest portletRequest) throws SystemException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return this.getPortalPreferences(request);
    }

    public PortletPreferences getPortletPreferences(HttpServletRequest request, String portletId) throws PortalException, SystemException {
        PortletPreferencesIds portletPreferencesIds = this.getPortletPreferencesIds(request, portletId);
        return PortletPreferencesLocalServiceUtil.getPreferences((PortletPreferencesIds)portletPreferencesIds);
    }

    public PortletPreferencesIds getPortletPreferencesIds(HttpServletRequest request, Layout layout, String portletId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)request, (String)portletId, (boolean)true);
        long userId = PortalUtil.getUserId((HttpServletRequest)request);
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        boolean modeEditGuest = false;
        String portletMode = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_mode");
        if (portletMode.equals(LiferayPortletMode.EDIT_GUEST.toString()) || layoutTypePortlet != null && layoutTypePortlet.hasModeEditGuestPortletId(portletId)) {
            modeEditGuest = true;
        }
        return this.getPortletPreferencesIds(scopeGroupId, userId, layout, portletId, modeEditGuest);
    }

    public PortletPreferencesIds getPortletPreferencesIds(HttpServletRequest request, String portletId) throws PortalException, SystemException {
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        return this.getPortletPreferencesIds(request, layout, portletId);
    }

    public PortletPreferencesIds getPortletPreferencesIds(long scopeGroupId, long userId, Layout layout, String portletId, boolean modeEditGuest) throws PortalException, SystemException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        String originalPortletId = portletId;
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
        long ownerId = 0L;
        int ownerType = 0;
        long plid = 0L;
        if (modeEditGuest) {
            boolean hasUpdateLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE");
            if (layout.isPrivateLayout() || !hasUpdateLayoutPermission) {
                throw new PrincipalException();
            }
        }
        if (PortletConstants.hasUserId((String)originalPortletId) && PortletConstants.getUserId((String)originalPortletId) == userId) {
            ownerId = userId;
            ownerType = 4;
            plid = layout.getPlid();
        } else if (portlet.isPreferencesCompanyWide()) {
            ownerId = layout.getCompanyId();
            ownerType = 1;
            plid = 0L;
            portletId = PortletConstants.getRootPortletId((String)portletId);
        } else if (portlet.isPreferencesUniquePerLayout()) {
            ownerId = 0L;
            ownerType = 3;
            plid = layout.getPlid();
            if (!portlet.isPreferencesOwnedByGroup()) {
                if (userId <= 0L || modeEditGuest) {
                    userId = UserLocalServiceUtil.getDefaultUserId((long)layout.getCompanyId());
                }
                ownerId = userId;
                ownerType = 4;
            }
        } else {
            plid = 0L;
            if (portlet.isPreferencesOwnedByGroup()) {
                ownerId = scopeGroupId;
                ownerType = 2;
                portletId = PortletConstants.getRootPortletId((String)portletId);
            } else {
                if (userId <= 0L || modeEditGuest) {
                    userId = UserLocalServiceUtil.getDefaultUserId((long)layout.getCompanyId());
                }
                ownerId = userId;
                ownerType = 4;
            }
        }
        return new PortletPreferencesIds(layout.getCompanyId(), ownerId, ownerType, plid, portletId);
    }

    public PortletPreferences getPortletSetup(HttpServletRequest request, String portletId) throws SystemException {
        return this.getPortletSetup(request, portletId, null);
    }

    public PortletPreferences getPortletSetup(HttpServletRequest request, String portletId, String defaultPreferences) throws SystemException {
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        if (portletRequest instanceof ConfigurationPortletRequest) {
            PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
            return portletRequestWrapper.getPreferences();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getPortletSetup(themeDisplay.getScopeGroupId(), themeDisplay.getLayout(), portletId, defaultPreferences);
    }

    public PortletPreferences getPortletSetup(Layout layout, String portletId, String defaultPreferences) throws SystemException {
        return this.getPortletSetup(0L, layout, portletId, defaultPreferences);
    }

    public PortletPreferences getPortletSetup(long scopeGroupId, Layout layout, String portletId, String defaultPreferences) throws SystemException {
        return this.getPortletSetup(scopeGroupId, layout, portletId, defaultPreferences, false);
    }

    public PortletPreferences getPortletSetup(PortletRequest portletRequest) throws SystemException {
        String portletId = PortalUtil.getPortletId((PortletRequest)portletRequest);
        return this.getPortletSetup(portletRequest, portletId);
    }

    public PortletPreferences getPortletSetup(PortletRequest portletRequest, String portletId) throws SystemException {
        if (portletRequest instanceof ConfigurationPortletRequest) {
            PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
            return portletRequestWrapper.getPreferences();
        }
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return this.getPortletSetup(request, portletId);
    }

    public Map<Long, PortletPreferences> getPortletSetupMap(long companyId, long groupId, long ownerId, int ownerType, String portletId, boolean privateLayout) throws SystemException {
        HashMap<Long, PortletPreferences> portletSetupMap = new HashMap<Long, PortletPreferences>();
        List portletPreferencesList = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)companyId, (long)groupId, (long)ownerId, (int)ownerType, (String)portletId, (boolean)privateLayout);
        for (com.liferay.portal.model.PortletPreferences portletPreferences : portletPreferencesList) {
            PortletPreferences portletSetup = PortletPreferencesLocalServiceUtil.getPreferences((long)companyId, (long)ownerId, (int)ownerType, (long)portletPreferences.getPlid(), (String)portletId);
            portletSetupMap.put(portletPreferences.getPlid(), portletSetup);
        }
        return portletSetupMap;
    }

    public PortletPreferences getPreferences(HttpServletRequest request) {
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        PortletPreferencesImpl portletPreferences = null;
        if (portletRequest != null) {
            PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)portletRequest.getPreferences();
            portletPreferences = portletPreferencesWrapper.getPortletPreferencesImpl();
        }
        return portletPreferences;
    }

    public PreferencesValidator getPreferencesValidator(Portlet portlet) {
        return PortalUtil.getPreferencesValidator((Portlet)portlet);
    }

    public PortletPreferences getStrictLayoutPortletSetup(Layout layout, String portletId) throws SystemException {
        long ownerId = 0L;
        int ownerType = 3;
        if (PortletConstants.hasUserId((String)portletId)) {
            ownerId = PortletConstants.getUserId((String)portletId);
            ownerType = 4;
        }
        return PortletPreferencesLocalServiceUtil.getStrictPreferences((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)layout.getPlid(), (String)portletId);
    }

    public PortletPreferences getStrictPortletSetup(Layout layout, String portletId) throws SystemException {
        return this.getPortletSetup(0L, layout, portletId, "", true);
    }

    public StrictPortletPreferencesImpl strictFromXML(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws SystemException {
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        return new StrictPortletPreferencesImpl(companyId, ownerId, ownerType, plid, portletId, xml, preferencesMap);
    }

    public String toXML(PortalPreferences portalPreferences) {
        PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)portalPreferences;
        return portalPreferencesImpl.toXML();
    }

    public String toXML(PortletPreferences portletPreferences) {
        PortletPreferencesImpl portletPreferencesImpl = (PortletPreferencesImpl)portletPreferences;
        return portletPreferencesImpl.toXML();
    }

    protected PortletPreferences getPortletSetup(long scopeGroupId, Layout layout, String portletId, String defaultPreferences, boolean strictMode) throws SystemException {
        String originalPortletId = portletId;
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
        boolean uniquePerLayout = false;
        boolean uniquePerGroup = false;
        if (portlet.isPreferencesCompanyWide()) {
            portletId = PortletConstants.getRootPortletId((String)portletId);
        } else if (portlet.isPreferencesUniquePerLayout()) {
            uniquePerLayout = true;
            if (portlet.isPreferencesOwnedByGroup()) {
                uniquePerGroup = true;
            }
        } else if (portlet.isPreferencesOwnedByGroup()) {
            uniquePerGroup = true;
            portletId = PortletConstants.getRootPortletId((String)portletId);
        }
        long ownerId = 0L;
        int ownerType = 3;
        long plid = layout.getPlid();
        Group group = GroupLocalServiceUtil.fetchGroup((long)scopeGroupId);
        if (group != null && group.isLayout()) {
            plid = group.getClassPK();
        }
        if (PortletConstants.hasUserId((String)originalPortletId)) {
            ownerId = PortletConstants.getUserId((String)originalPortletId);
            ownerType = 4;
        } else if (!uniquePerLayout) {
            plid = 0L;
            if (uniquePerGroup) {
                ownerId = scopeGroupId > 0L ? scopeGroupId : layout.getGroupId();
                ownerType = 2;
            } else {
                ownerId = layout.getCompanyId();
                ownerType = 1;
            }
        }
        if (strictMode) {
            return PortletPreferencesLocalServiceUtil.getStrictPreferences((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        }
        return PortletPreferencesLocalServiceUtil.getPreferences((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)defaultPreferences);
    }

    protected Preference readPreference(XMLEventReader xmlEventReader) throws XMLStreamException {
        String name = null;
        ArrayList<String> values = new ArrayList<String>();
        boolean readOnly = false;
        while (xmlEventReader.hasNext()) {
            EndElement endElement;
            String elementName;
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                String value;
                StartElement startElement = xmlEvent.asStartElement();
                elementName = startElement.getName().getLocalPart();
                if (elementName.equals("name")) {
                    name = StAXReaderUtil.read(xmlEventReader);
                    continue;
                }
                if (elementName.equals("value")) {
                    value = StAXReaderUtil.read(xmlEventReader);
                    values.add(value);
                    continue;
                }
                if (!elementName.equals("read-only")) continue;
                value = StAXReaderUtil.read(xmlEventReader);
                readOnly = GetterUtil.getBoolean((String)value);
                continue;
            }
            if (xmlEvent.isEndElement() && (elementName = (endElement = xmlEvent.asEndElement()).getName().getLocalPart()).equals("preference")) break;
        }
        return new Preference(name, values.toArray(new String[values.size()]), readOnly);
    }

    protected Map<String, Preference> toPreferencesMap(String xml) throws SystemException {
        if (Validator.isNull((String)xml)) {
            return Collections.emptyMap();
        }
        String cacheKey = this._encodeCacheKey(xml);
        Map<String, Preference> preferencesMap = (Map<String, Preference>)this._preferencesMapPortalCache.get((Serializable)((Object)cacheKey));
        if (preferencesMap != null) {
            return preferencesMap;
        }
        XMLEventReader xmlEventReader = null;
        try {
            try {
                XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
                xmlEventReader = xmlInputFactory.createXMLEventReader((Reader)new UnsyncStringReader(xml));
                while (xmlEventReader.hasNext()) {
                    StartElement startElement;
                    String elementName;
                    XMLEvent xmlEvent = xmlEventReader.nextEvent();
                    if (!xmlEvent.isStartElement() || !(elementName = (startElement = xmlEvent.asStartElement()).getName().getLocalPart()).equals("preference")) continue;
                    Preference preference = this.readPreference(xmlEventReader);
                    if (preferencesMap == null) {
                        preferencesMap = new HashMap<String, Preference>();
                    }
                    preferencesMap.put(preference.getName(), preference);
                }
            }
            catch (XMLStreamException xse) {
                throw new SystemException((Throwable)xse);
            }
        }
        finally {
            block16: {
                if (xmlEventReader != null) {
                    try {
                        xmlEventReader.close();
                    }
                    catch (XMLStreamException xse) {
                        if (!_log.isDebugEnabled()) break block16;
                        _log.debug((Object)xse, (Throwable)xse);
                    }
                }
            }
        }
        if (preferencesMap == null) {
            preferencesMap = Collections.emptyMap();
        }
        this._preferencesMapPortalCache.put((Serializable)((Object)cacheKey), preferencesMap);
        return preferencesMap;
    }

    private String _encodeCacheKey(String xml) {
        if (xml.length() <= PropsValues.PORTLET_PREFERENCES_CACHE_KEY_THRESHOLD_SIZE) {
            return xml;
        }
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)PortletPreferencesFactoryImpl.class.getName());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Cache key generator " + cacheKeyGenerator.getClass()));
        }
        return String.valueOf(cacheKeyGenerator.getCacheKey(xml));
    }
}

