/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.base.JournalTemplateServiceBaseImpl;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import com.liferay.portlet.journal.service.permission.JournalTemplatePermission;
import com.liferay.portlet.journal.util.JournalUtil;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JournalTemplateServiceImpl
extends JournalTemplateServiceBaseImpl {
    public JournalTemplate addTemplate(long groupId, String templateId, boolean autoTemplateId, String structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsl, boolean formatXsl, String langType, boolean cacheable, boolean smallImage, String smallImageURL, File smallFile, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_TEMPLATE");
        return this.journalTemplateLocalService.addTemplate(this.getUserId(), groupId, templateId, autoTemplateId, structureId, nameMap, descriptionMap, xsl, formatXsl, langType, cacheable, smallImage, smallImageURL, smallFile, serviceContext);
    }

    public JournalTemplate addTemplate(long groupId, String templateId, boolean autoTemplateId, String structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsl, boolean formatXsl, String langType, boolean cacheable, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_TEMPLATE");
        return this.journalTemplateLocalService.addTemplate(this.getUserId(), groupId, templateId, autoTemplateId, structureId, nameMap, descriptionMap, xsl, formatXsl, langType, cacheable, false, null, null, serviceContext);
    }

    public JournalTemplate copyTemplate(long groupId, String oldTemplateId, String newTemplateId, boolean autoTemplateId) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_TEMPLATE");
        return this.journalTemplateLocalService.copyTemplate(this.getUserId(), groupId, oldTemplateId, newTemplateId, autoTemplateId);
    }

    public void deleteTemplate(long groupId, String templateId) throws PortalException, SystemException {
        JournalTemplatePermission.check(this.getPermissionChecker(), groupId, templateId, "DELETE");
        this.journalTemplateLocalService.deleteTemplate(groupId, templateId);
    }

    public List<JournalTemplate> getStructureTemplates(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructure structure = this.journalStructureLocalService.getStructure(groupId, structureId);
        List ddmTemplates = this.ddmTemplatePersistence.filterFindByG_CPK(groupId, structure.getPrimaryKey());
        return JournalUtil.toJournalTemplates(ddmTemplates);
    }

    public JournalTemplate getTemplate(long groupId, String templateId) throws PortalException, SystemException {
        JournalTemplatePermission.check(this.getPermissionChecker(), groupId, templateId, "VIEW");
        return this.journalTemplateLocalService.getTemplate(groupId, templateId);
    }

    public JournalTemplate getTemplate(long groupId, String templateId, boolean includeGlobalTemplates) throws PortalException, SystemException {
        JournalTemplatePermission.check(this.getPermissionChecker(), groupId, templateId, "VIEW");
        return this.journalTemplateLocalService.getTemplate(groupId, templateId, includeGlobalTemplates);
    }

    public List<JournalTemplate> search(long companyId, long[] groupIds, String keywords, String structureId, String structureIdComparator, int start, int end, OrderByComparator obc) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(DDMStructure.class)};
        long[] classPKs = JournalUtil.getStructureClassPKs(groupIds, structureId);
        List ddmTemplates = this.ddmTemplateFinder.filterFindByKeywords(companyId, groupIds, classNameIds, classPKs, keywords, null, null, start, end, obc);
        return JournalUtil.toJournalTemplates(ddmTemplates);
    }

    public List<JournalTemplate> search(long companyId, long[] groupIds, String templateId, String structureId, String structureIdComparator, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(DDMStructure.class)};
        long[] classPKs = JournalUtil.getStructureClassPKs(groupIds, structureId);
        List ddmTemplates = this.ddmTemplateFinder.filterFindByC_G_C_C_N_D_T_M_L(companyId, groupIds, classNameIds, classPKs, name, description, null, null, null, andOperator, start, end, obc);
        return JournalUtil.toJournalTemplates(ddmTemplates);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords, String structureId, String structureIdComparator) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(DDMStructure.class)};
        long[] classPKs = JournalUtil.getStructureClassPKs(groupIds, structureId);
        return this.ddmTemplateFinder.filterCountByKeywords(companyId, groupIds, classNameIds, classPKs, keywords, null, null);
    }

    public int searchCount(long companyId, long[] groupIds, String templateId, String structureId, String structureIdComparator, String name, String description, boolean andOperator) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(DDMStructure.class)};
        long[] classPKs = JournalUtil.getStructureClassPKs(groupIds, structureId);
        return this.ddmTemplateFinder.filterCountByC_G_C_C_N_D_T_M_L(companyId, groupIds, classNameIds, classPKs, name, description, null, null, null, andOperator);
    }

    public JournalTemplate updateTemplate(long groupId, String templateId, String structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsl, boolean formatXsl, String langType, boolean cacheable, boolean smallImage, String smallImageURL, File smallFile, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalTemplatePermission.check(this.getPermissionChecker(), groupId, templateId, "UPDATE");
        return this.journalTemplateLocalService.updateTemplate(groupId, templateId, structureId, nameMap, descriptionMap, xsl, formatXsl, langType, cacheable, smallImage, smallImageURL, smallFile, serviceContext);
    }

    public JournalTemplate updateTemplate(long groupId, String templateId, String structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsl, boolean formatXsl, String langType, boolean cacheable, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalTemplatePermission.check(this.getPermissionChecker(), groupId, templateId, "UPDATE");
        return this.journalTemplateLocalService.updateTemplate(groupId, templateId, structureId, nameMap, descriptionMap, xsl, formatXsl, langType, cacheable, false, null, null, serviceContext);
    }
}

