/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.join.AbstractCondition;
import org.apache.jackrabbit.core.query.lucene.join.ScoreNodeMap;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;

public class DescendantNodeJoin
extends AbstractCondition {
    private final ScoreNodeMap contextIndex = new ScoreNodeMap();
    private final IndexReader reader;
    private final HierarchyResolver resolver;
    private int[] docNums = new int[1];
    private final List<Integer> ancestors = new ArrayList<Integer>();
    private final List<ScoreNode[]> scoreNodes = new ArrayList<ScoreNode[]>();

    public DescendantNodeJoin(MultiColumnQueryHits context, Name contextSelectorName, IndexReader reader, HierarchyResolver resolver) throws IOException {
        super(context);
        ScoreNode[] nodes;
        this.reader = reader;
        this.resolver = resolver;
        int idx = DescendantNodeJoin.getIndex(context, contextSelectorName);
        while ((nodes = context.nextScoreNodes()) != null) {
            Integer docNum = nodes[idx].getDoc(reader);
            this.contextIndex.addScoreNodes(docNum, nodes);
        }
    }

    public ScoreNode[][] getMatchingScoreNodes(ScoreNode descendant) throws IOException {
        this.ancestors.clear();
        this.collectAncestors(descendant.getDoc(this.reader));
        this.scoreNodes.clear();
        for (Integer ancestor : this.ancestors) {
            ScoreNode[][] sn = this.contextIndex.getScoreNodes(ancestor);
            if (sn == null) continue;
            for (ScoreNode[] aSn : sn) {
                this.scoreNodes.add(aSn);
            }
        }
        if (this.scoreNodes.isEmpty()) {
            return null;
        }
        return (ScoreNode[][])this.scoreNodes.toArray((T[])new ScoreNode[this.scoreNodes.size()][]);
    }

    private void collectAncestors(int doc) throws IOException {
        this.docNums = this.resolver.getParents(doc, this.docNums);
        if (this.docNums.length == 1) {
            this.ancestors.add(this.docNums[0]);
            this.collectAncestors(this.docNums[0]);
        } else if (this.docNums.length > 1) {
            for (int docNum : (int[])this.docNums.clone()) {
                this.ancestors.add(docNum);
                this.collectAncestors(docNum);
            }
        }
    }
}

