/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.PathGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupInterface;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.test.TestRig;
import org.antlr.stringtemplate.test.TestSuite;

public class TestStringTemplate
extends TestSuite {
    final String newline = System.getProperty("line.separator");
    static /* synthetic */ Class class$org$antlr$stringtemplate$language$DefaultTemplateLexer;
    static /* synthetic */ Class class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer;
    static /* synthetic */ Class class$java$util$GregorianCalendar;

    public void runTests() throws Throwable {
        TestRig.runAllTests(this.getClass(), this);
    }

    public void testInterfaceFileFormat() throws Exception {
        String string = "interface test;" + this.newline + "t();" + this.newline + "bold(item);" + this.newline + "optional duh(a,b,c);" + this.newline;
        StringTemplateGroupInterface stringTemplateGroupInterface = new StringTemplateGroupInterface(new StringReader(string));
        String string2 = "interface test;\nt();\nbold(item);\noptional duh(a, b, c);\n";
        this.assertEqual(stringTemplateGroupInterface.toString(), string2);
    }

    public void testNoGroupLoader() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        String string2 = "group testG implements blort;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>" + this.newline + "duh(a,b,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(string, "testG.stg", string2);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string3 = "no group loader registered";
        this.assertEqual(((Object)errorBuffer).toString(), string3);
    }

    public void testCannotFindInterfaceFile() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "group testG implements blort;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>" + this.newline + "duh(a,b,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(string, "testG.stg", string2);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string3 = "no such interface file blort.sti";
        this.assertEqual(((Object)errorBuffer).toString(), string3);
    }

    public void testMultiDirGroupLoading() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        if (!new File(string + "/sub").exists() && !new File(string + "/sub").mkdir()) {
            System.err.println("can't make subdir in test");
            return;
        }
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string + ":" + string + "/sub", errorBuffer));
        String string2 = "group testG2;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>" + this.newline + "duh(a,b,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(string + "/sub", "testG2.stg", string2);
        StringTemplateGroup stringTemplateGroup = StringTemplateGroup.loadGroup("testG2");
        String string3 = "group testG2;\nbold(item) ::= <<foo>>\nduh(a,b,c) ::= <<foo>>\nt() ::= <<foo>>\n";
        this.assertEqual(stringTemplateGroup.toString(), string3);
    }

    public void testGroupSatisfiesSingleInterface() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "interface testI;" + this.newline + "t();" + this.newline + "bold(item);" + this.newline + "optional duh(a,b,c);" + this.newline;
        TestStringTemplate.writeFile(string, "testI.sti", string2);
        String string3 = "group testG implements testI;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>" + this.newline + "duh(a,b,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(string, "testG.stg", string3);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string4 = "";
        this.assertEqual(((Object)errorBuffer).toString(), string4);
    }

    public void testGroupExtendsSuperGroup() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "group superG;" + this.newline + "bold(item) ::= <<*$item$*>>;\n" + this.newline;
        TestStringTemplate.writeFile(string, "superG.stg", string2);
        String string3 = "group testG : superG;" + this.newline + "main(x) ::= <<$bold(x)$>>" + this.newline;
        TestStringTemplate.writeFile(string, "testG.stg", string3);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new FileReader(string + "/testG.stg"), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("main");
        stringTemplate.setAttribute("x", "foo");
        String string4 = "*foo*";
        this.assertEqual(stringTemplate.toString(), string4);
    }

    public void testMissingInterfaceTemplate() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "interface testI;" + this.newline + "t();" + this.newline + "bold(item);" + this.newline + "optional duh(a,b,c);" + this.newline;
        TestStringTemplate.writeFile(string, "testI.sti", string2);
        String string3 = "group testG implements testI;" + this.newline + "t() ::= <<foo>>" + this.newline + "duh(a,b,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(string, "testG.stg", string3);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string4 = "group testG does not satisfy interface testI: missing templates [bold]";
        this.assertEqual(((Object)errorBuffer).toString(), string4);
    }

    public void testMissingOptionalInterfaceTemplate() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "interface testI;" + this.newline + "t();" + this.newline + "bold(item);" + this.newline + "optional duh(a,b,c);" + this.newline;
        TestStringTemplate.writeFile(string, "testI.sti", string2);
        String string3 = "group testG implements testI;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>";
        TestStringTemplate.writeFile(string, "testG.stg", string3);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string4 = "";
        this.assertEqual(((Object)errorBuffer).toString(), string4);
    }

    public void testMismatchedInterfaceTemplate() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "interface testI;" + this.newline + "t();" + this.newline + "bold(item);" + this.newline + "optional duh(a,b,c);" + this.newline;
        TestStringTemplate.writeFile(string, "testI.sti", string2);
        String string3 = "group testG implements testI;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>" + this.newline + "duh(a,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(string, "testG.stg", string3);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string4 = "group testG does not satisfy interface testI: mismatched arguments on these templates [optional duh(a, b, c)]";
        this.assertEqual(((Object)errorBuffer).toString(), string4);
    }

    public void testGroupFileFormat() throws Exception {
        String string = "group test;" + this.newline + "t() ::= \"literal template\"" + this.newline + "bold(item) ::= \"<b>$item$</b>\"" + this.newline + "duh() ::= <<" + this.newline + "xx" + this.newline + ">>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        String string2 = "group test;" + this.newline + "bold(item) ::= <<<b>$item$</b>>>" + this.newline + "duh() ::= <<xx>>" + this.newline + "t() ::= <<literal template>>" + this.newline;
        this.assertEqual(stringTemplateGroup.toString(), string2);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("t");
        string2 = "literal template";
        this.assertEqual(stringTemplate.toString(), string2);
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("bold");
        stringTemplate2.setAttribute("item", "dork");
        string2 = "<b>dork</b>";
        this.assertEqual(stringTemplate2.toString(), string2);
    }

    public void testEscapedTemplateDelimiters() throws Exception {
        String string = "group test;" + this.newline + "t() ::= <<$\"literal\":{a|$a$\\}}$ template\n>>" + this.newline + "bold(item) ::= <<<b>$item$</b\\>>>" + this.newline + "duh() ::= <<" + this.newline + "xx" + this.newline + ">>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        String string2 = "group test;" + this.newline + "bold(item) ::= <<<b>$item$</b>>>" + this.newline + "duh() ::= <<xx>>" + this.newline + "t() ::= <<$\"literal\":{a|$a$\\}}$ template>>" + this.newline;
        this.assertEqual(stringTemplateGroup.toString(), string2);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("bold");
        stringTemplate.setAttribute("item", "dork");
        string2 = "<b>dork</b>";
        this.assertEqual(stringTemplate.toString(), string2);
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("t");
        string2 = "literal} template";
        this.assertEqual(stringTemplate2.toString(), string2);
    }

    public void testTemplateParameterDecls() throws Exception {
        String string = "group test;" + this.newline + "t() ::= \"no args but ref $foo$\"" + this.newline + "t2(item) ::= \"decl but not used is ok\"" + this.newline + "t3(a,b,c,d) ::= <<$a$ $d$>>" + this.newline + "t4(a,b,c,d) ::= <<$a$ $b$ $c$ $d$>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("t");
        String string2 = null;
        try {
            stringTemplate.setAttribute("foo", "x");
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = noSuchElementException.getMessage();
        }
        String string3 = "no such attribute: foo in template context [t]";
        this.assertEqual(string2, string3);
        stringTemplate = stringTemplateGroup.getInstanceOf("t2");
        stringTemplate.setAttribute("item", "x");
        stringTemplate = stringTemplateGroup.getInstanceOf("t3");
        stringTemplate.setAttribute("b", "x");
    }

    public void testTemplateRedef() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"x\"" + this.newline + "b() ::= \"y\"" + this.newline + "a() ::= \"z\"" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        String string2 = "redefinition of template: a";
        this.assertEqual(((Object)errorBuffer).toString(), string2);
    }

    public void testMissingInheritedAttribute() throws Exception {
        String string = "group test;" + this.newline + "page(title,font) ::= <<" + this.newline + "<html>" + this.newline + "<body>" + this.newline + "$title$<br>" + this.newline + "$body()$" + this.newline + "</body>" + this.newline + "</html>" + this.newline + ">>" + this.newline + "body() ::= \"<font face=$font$>my body</font>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("title", "my title");
        stringTemplate.setAttribute("font", "Helvetica");
        stringTemplate.toString();
    }

    public void testFormalArgumentAssignment() throws Exception {
        String string = "group test;" + this.newline + "page() ::= <<$body(font=\"Times\")$>>" + this.newline + "body(font) ::= \"<font face=$font$>my body</font>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        String string2 = "<font face=Times>my body</font>";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testUndefinedArgumentAssignment() throws Exception {
        String string = "group test;" + this.newline + "page(x) ::= <<$body(font=x)$>>" + this.newline + "body() ::= \"<font face=$font$>my body</font>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("x", "Times");
        String string2 = "";
        try {
            stringTemplate.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = noSuchElementException.getMessage();
        }
        String string3 = "template body has no such attribute: font in template context [page <invoke body arg context>]";
        this.assertEqual(string2, string3);
    }

    public void testFormalArgumentAssignmentInApply() throws Exception {
        String string = "group test;" + this.newline + "page(name) ::= <<$name:bold(font=\"Times\")$>>" + this.newline + "bold(font) ::= \"<font face=$font$><b>$it$</b></font>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("name", "Ter");
        String string2 = "<font face=Times><b>Ter</b></font>";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testUndefinedArgumentAssignmentInApply() throws Exception {
        String string = "group test;" + this.newline + "page(name,x) ::= <<$name:bold(font=x)$>>" + this.newline + "bold() ::= \"<font face=$font$><b>$it$</b></font>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("x", "Times");
        stringTemplate.setAttribute("name", "Ter");
        String string2 = "";
        try {
            stringTemplate.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = noSuchElementException.getMessage();
        }
        String string3 = "template bold has no such attribute: font in template context [page <invoke bold arg context>]";
        this.assertEqual(string2, string3);
    }

    public void testUndefinedAttributeReference() throws Exception {
        String string = "group test;" + this.newline + "page() ::= <<$bold()$>>" + this.newline + "bold() ::= \"$name$\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        String string2 = "";
        try {
            stringTemplate.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = noSuchElementException.getMessage();
        }
        String string3 = "no such attribute: name in template context [page bold]";
        this.assertEqual(string2, string3);
    }

    public void testUndefinedDefaultAttributeReference() throws Exception {
        String string = "group test;" + this.newline + "page() ::= <<$bold()$>>" + this.newline + "bold() ::= \"$it$\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        String string2 = "";
        try {
            stringTemplate.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = noSuchElementException.getMessage();
        }
        String string3 = "no such attribute: it in template context [page bold]";
        this.assertEqual(string2, string3);
    }

    public void testAngleBracketsWithGroupFile() throws Exception {
        String string = "group test;" + this.newline + "a(s) ::= \"<s:{case <i> : <it> break;}>\"" + this.newline + "b(t) ::= \"<t; separator=\\\",\\\">\"" + this.newline + "c(t) ::= << <t; separator=\",\"> >>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.setAttribute("s", "Test");
        String string2 = "case 1 : Test break;";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testAngleBracketsNoGroup() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Tokens : <rules; separator=\"|\"> ;", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        stringTemplate.setAttribute("rules", "A");
        stringTemplate.setAttribute("rules", "B");
        String string = "Tokens : A|B ;";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testRegionRef() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"X$@r()$Y\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XY";
        this.assertEqual(string2, string3);
    }

    public void testEmbeddedRegionRef() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"X$@r$blort$@end$Y\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XblortY";
        this.assertEqual(string2, string3);
    }

    public void testRegionRefAngleBrackets() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"X<@r()>Y\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XY";
        this.assertEqual(string2, string3);
    }

    public void testEmbeddedRegionRefAngleBrackets() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"X<@r>blort<@end>Y\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XblortY";
        this.assertEqual(string2, string3);
    }

    public void testEmbeddedRegionRefWithNewlinesAngleBrackets() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"X<@r>" + this.newline + "blort" + this.newline + "<@end>" + this.newline + "Y\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XblortY";
        this.assertEqual(string2, string3);
    }

    public void testRegionRefWithDefAngleBrackets() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"X<@r()>Y\"" + this.newline + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XfooY";
        this.assertEqual(string2, string3);
    }

    public void testRegionRefWithDefInConditional() throws Exception {
        String string = "group test;" + this.newline + "a(v) ::= \"X<if(v)>A<@r()>B<endif>Y\"" + this.newline + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.setAttribute("v", "true");
        String string2 = stringTemplate.toString();
        String string3 = "XAfooBY";
        this.assertEqual(string2, string3);
    }

    public void testRegionRefWithImplicitDefInConditional() throws Exception {
        String string = "group test;" + this.newline + "a(v) ::= \"X<if(v)>A<@r>yo<@end>B<endif>Y\"" + this.newline + "@a.r() ::= \"foo\"" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.setAttribute("v", "true");
        String string2 = stringTemplate.toString();
        String string3 = "XAyoBY";
        this.assertEqual(string2, string3);
        String string4 = ((Object)errorBuffer).toString();
        String string5 = "group test line 3: redefinition of template region: @a.r";
        this.assertEqual(string4, string5);
    }

    public void testRegionOverride() throws Exception {
        String string = "group super;" + this.newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + this.newline + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer, null, stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("a");
        String string3 = stringTemplate.toString();
        String string4 = "XfooY";
        this.assertEqual(string3, string4);
    }

    public void testRegionOverrideRefSuperRegion() throws Exception {
        String string = "group super;" + this.newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + this.newline + "@a.r() ::= \"A<@super.r()>B\"" + this.newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer, null, stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("a");
        String string3 = stringTemplate.toString();
        String string4 = "XAfooBY";
        this.assertEqual(string3, string4);
    }

    public void testRegionOverrideRefSuperRegion3Levels() throws Exception {
        String string = "group super;" + this.newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + this.newline + "@a.r() ::= \"<@super.r()>2\"" + this.newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer, null, stringTemplateGroup);
        String string3 = "group subsub;" + this.newline + "@a.r() ::= \"<@super.r()>3\"" + this.newline;
        StringTemplateGroup stringTemplateGroup3 = new StringTemplateGroup(new StringReader(string3), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer, null, stringTemplateGroup2);
        StringTemplate stringTemplate = stringTemplateGroup3.getInstanceOf("a");
        String string4 = stringTemplate.toString();
        String string5 = "Xfoo23Y";
        this.assertEqual(string4, string5);
    }

    public void testRegionOverrideRefSuperImplicitRegion() throws Exception {
        String string = "group super;" + this.newline + "a() ::= \"X<@r>foo<@end>Y\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + this.newline + "@a.r() ::= \"A<@super.r()>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer, null, stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("a");
        String string3 = stringTemplate.toString();
        String string4 = "XAfooY";
        this.assertEqual(string3, string4);
    }

    public void testEmbeddedRegionRedefError() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"X<@r>dork<@end>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.toString();
        String string2 = ((Object)errorBuffer).toString();
        String string3 = "group test line 2: redefinition of template region: @a.r";
        this.assertEqual(string2, string3);
    }

    public void testImplicitRegionRedefError() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"X<@r()>Y\"" + this.newline + "@a.r() ::= \"foo\"" + this.newline + "@a.r() ::= \"bar\"" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.toString();
        String string2 = ((Object)errorBuffer).toString();
        String string3 = "group test line 4: redefinition of template region: @a.r";
        this.assertEqual(string2, string3);
    }

    public void testImplicitOverriddenRegionRedefError() throws Exception {
        String string = "group super;" + this.newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + this.newline + "@a.r() ::= \"foo\"" + this.newline + "@a.r() ::= \"bar\"" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer, errorBuffer, stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("a");
        String string3 = ((Object)errorBuffer).toString();
        String string4 = "group sub line 3: redefinition of template region: @a.r";
        this.assertEqual(string3, string4);
    }

    public void testUnknownRegionDefError() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"X<@r()>Y\"" + this.newline + "@a.q() ::= \"foo\"" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.toString();
        String string2 = ((Object)errorBuffer).toString();
        String string3 = "group test line 3: template a has no region called q";
        this.assertEqual(string2, string3);
    }

    public void testSuperRegionRefError() throws Exception {
        String string = "group super;" + this.newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + this.newline + "@a.r() ::= \"A<@super.q()>B\"" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer, errorBuffer, stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("a");
        String string3 = ((Object)errorBuffer).toString();
        String string4 = "template a has no region called q";
        this.assertEqual(string3, string4);
    }

    public void testMissingEndRegionError() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"X$@r$foo\"" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer, errorBuffer, null);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.toString();
        String string2 = ((Object)errorBuffer).toString();
        String string3 = "missing region r $@end$ tag";
        this.assertEqual(string2, string3);
    }

    public void testMissingEndRegionErrorAngleBrackets() throws Exception {
        String string = "group test;" + this.newline + "a() ::= \"X<@r>foo\"" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.toString();
        String string2 = ((Object)errorBuffer).toString();
        String string3 = "missing region r <@end> tag";
        this.assertEqual(string2, string3);
    }

    public void testSimpleInheritance() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("super");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup2.setErrorListener(errorBuffer);
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup2, "$name:bold()$");
        stringTemplate2.setAttribute("name", "Terence");
        String string = "<b>Terence</b>";
        this.assertEqual(stringTemplate2.toString(), string);
    }

    public void testOverrideInheritance() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("super");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup2.defineTemplate("bold", "<strong>$it$</strong>");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup2.setErrorListener(errorBuffer);
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup2, "$name:bold()$");
        stringTemplate.setAttribute("name", "Terence");
        String string = "<strong>Terence</strong>";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testMultiLevelInheritance() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("root");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("level1");
        StringTemplateGroup stringTemplateGroup3 = new StringTemplateGroup("level2");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        stringTemplateGroup3.setSuperGroup(stringTemplateGroup2);
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        stringTemplateGroup2.setErrorListener(errorBuffer);
        stringTemplateGroup3.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup3, "$name:bold()$");
        stringTemplate.setAttribute("name", "Terence");
        String string = "<b>Terence</b>";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testComplicatedInheritance() throws Exception {
        String string = "group base;" + this.newline + "decls() ::= \"D<labels()>\"" + this.newline + "labels() ::= \"L\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + this.newline + "decls() ::= \"<super.decls()>\"" + this.newline + "labels() ::= \"SL\"" + this.newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2));
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("decls");
        String string3 = "DSL";
        String string4 = stringTemplate.toString();
        this.assertEqual(string4, string3);
    }

    public void test3LevelSuperRef() throws Exception {
        String string = "group super;" + this.newline + "r() ::= \"foo\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + this.newline + "r() ::= \"<super.r()>2\"" + this.newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer, null, stringTemplateGroup);
        String string3 = "group subsub;" + this.newline + "r() ::= \"<super.r()>3\"" + this.newline;
        StringTemplateGroup stringTemplateGroup3 = new StringTemplateGroup(new StringReader(string3), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer, null, stringTemplateGroup2);
        StringTemplate stringTemplate = stringTemplateGroup3.getInstanceOf("r");
        String string4 = stringTemplate.toString();
        String string5 = "foo23";
        this.assertEqual(string4, string5);
    }

    public void testExprInParens() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$(\"blort: \"+(list)):bold()$");
        stringTemplate2.setAttribute("list", "a");
        stringTemplate2.setAttribute("list", "b");
        stringTemplate2.setAttribute("list", "c");
        String string = "<b>blort: abc</b>";
        this.assertEqual(stringTemplate2.toString(), string);
    }

    public void testMultipleAdditions() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        stringTemplateGroup.defineTemplate("link", "<a href=\"$url$\"><b>$title$</b></a>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$link(url=\"/member/view?ID=\"+ID+\"&x=y\"+foo, title=\"the title\")$");
        stringTemplate.setAttribute("ID", "3321");
        stringTemplate.setAttribute("foo", "fubar");
        String string = "<a href=\"/member/view?ID=3321&x=yfubar\"><b>the title</b></a>";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testCollectionAttributes() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$data$, $data:bold()$, $list:bold():bold()$, $array$, $a2$, $a3$, $a4$");
        Vector<String> vector = new Vector<String>();
        vector.addElement("1");
        vector.addElement("2");
        vector.addElement("3");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("a");
        arrayList.add("b");
        arrayList.add("c");
        stringTemplate2.setAttribute("data", vector);
        stringTemplate2.setAttribute("list", arrayList);
        stringTemplate2.setAttribute("array", (Object)new String[]{"x", "y"});
        stringTemplate2.setAttribute("a2", (Object)new int[]{10, 20});
        stringTemplate2.setAttribute("a3", (Object)new float[]{1.2f, 1.3f});
        stringTemplate2.setAttribute("a4", (Object)new double[]{8.7, 9.2});
        String string = "123, <b>1</b><b>2</b><b>3</b>, <b><b>a</b></b><b><b>b</b></b><b><b>c</b></b>, xy, 1020, 1.21.3, 8.79.2";
        this.assertEqual(stringTemplate2.toString(), string);
    }

    public void testParenthesizedExpression() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$(f+l):bold()$");
        stringTemplate2.setAttribute("f", "Joe");
        stringTemplate2.setAttribute("l", "Schmoe");
        String string = "<b>JoeSchmoe</b>";
        this.assertEqual(stringTemplate2.toString(), string);
    }

    public void testApplyTemplateNameExpression() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("foobar", "foo$attr$bar");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$data:(name+\"bar\")()$");
        stringTemplate2.setAttribute("data", "Ter");
        stringTemplate2.setAttribute("data", "Tom");
        stringTemplate2.setAttribute("name", "foo");
        String string = "fooTerbarfooTombar";
        this.assertEqual(stringTemplate2.toString(), string);
    }

    public void testApplyTemplateNameTemplateEval() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("foobar", "foo$it$bar");
        StringTemplate stringTemplate2 = stringTemplateGroup.defineTemplate("a", "$it$bar");
        StringTemplate stringTemplate3 = new StringTemplate(stringTemplateGroup, "$data:(\"foo\":a())()$");
        stringTemplate3.setAttribute("data", "Ter");
        stringTemplate3.setAttribute("data", "Tom");
        String string = "fooTerbarfooTombar";
        this.assertEqual(stringTemplate3.toString(), string);
    }

    public void testTemplateNameExpression() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("foo", "hi there!");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$(name)()$");
        stringTemplate2.setAttribute("name", "foo");
        String string = "hi there!";
        this.assertEqual(stringTemplate2.toString(), string);
    }

    public void testMissingEndDelimiter() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "stuff $a then more junk etc...");
        String string = "problem parsing template 'anonymous': line 1:31: expecting '$', found '<EOF>'";
        this.assertTrue(((Object)errorBuffer).toString().startsWith(string));
    }

    public void testSetButNotRefd() throws Exception {
        StringTemplate.setLintMode(true);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$a$ then $b$ and $c$ refs.");
        stringTemplate.setAttribute("a", "Terence");
        stringTemplate.setAttribute("b", "Terence");
        stringTemplate.setAttribute("cc", "Terence");
        String string = System.getProperty("line.separator");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        String string2 = "anonymous: set but not used: cc";
        String string3 = stringTemplate.toString();
        StringTemplate.setLintMode(false);
        this.assertEqual(((Object)errorBuffer).toString(), string2);
    }

    public void testNullTemplateApplication() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$names:bold(x=it)$");
        stringTemplate.setAttribute("names", "Terence");
        Object var4_4 = null;
        String string = null;
        String string2 = null;
        try {
            string = stringTemplate.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = illegalArgumentException.getMessage();
        }
        this.assertEqual(string2, "Can't find template bold.st; context is [anonymous]");
    }

    public void testNullTemplateToMultiValuedApplication() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$names:bold(x=it)$");
        stringTemplate.setAttribute("names", "Terence");
        stringTemplate.setAttribute("names", "Tom");
        Object var4_4 = null;
        String string = null;
        String string2 = null;
        try {
            string = stringTemplate.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = illegalArgumentException.getMessage();
        }
        this.assertEqual(string2, "Can't find template bold.st; context is [anonymous]");
    }

    public void testChangingAttrValueTemplateApplicationToVector() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$names:bold(x=it)$");
        stringTemplate2.setAttribute("names", "Terence");
        stringTemplate2.setAttribute("names", "Tom");
        String string = "<b>Terence</b><b>Tom</b>";
        this.assertEqual(stringTemplate2.toString(), string);
    }

    public void testChangingAttrValueRepeatedTemplateApplicationToVector() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$item$</b>");
        StringTemplate stringTemplate2 = stringTemplateGroup.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate stringTemplate3 = new StringTemplate(stringTemplateGroup, "$members:bold(item=it):italics(it=it)$");
        stringTemplate3.setAttribute("members", "Jim");
        stringTemplate3.setAttribute("members", "Mike");
        stringTemplate3.setAttribute("members", "Ashar");
        String string = "<i><b>Jim</b></i><i><b>Mike</b></i><i><b>Ashar</b></i>";
        this.assertEqual(stringTemplate3.toString(), string);
    }

    public void testAlternatingTemplateApplication() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("listItem", "<li>$it$</li>");
        StringTemplate stringTemplate2 = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate3 = stringTemplateGroup.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate stringTemplate4 = new StringTemplate(stringTemplateGroup, "$item:bold(),italics():listItem()$");
        stringTemplate4.setAttribute("item", "Jim");
        stringTemplate4.setAttribute("item", "Mike");
        stringTemplate4.setAttribute("item", "Ashar");
        String string = "<li><b>Jim</b></li><li><i>Mike</i></li><li><b>Ashar</b></li>";
        this.assertEqual(stringTemplate4.toString(), string);
    }

    public void testExpressionAsRHSOfAssignment() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("hostname", "$machine$.jguru.com");
        StringTemplate stringTemplate2 = stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate stringTemplate3 = new StringTemplate(stringTemplateGroup, "$bold(x=hostname(machine=\"www\"))$");
        String string = "<b>www.jguru.com</b>";
        this.assertEqual(stringTemplate3.toString(), string);
    }

    public void testTemplateApplicationAsRHSOfAssignment() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("hostname", "$machine$.jguru.com");
        StringTemplate stringTemplate2 = stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate stringTemplate3 = stringTemplateGroup.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate stringTemplate4 = new StringTemplate(stringTemplateGroup, "$bold(x=hostname(machine=\"www\"):italics())$");
        String string = "<b><i>www.jguru.com</i></b>";
        this.assertEqual(stringTemplate4.toString(), string);
    }

    public void testParameterAndAttributeScoping() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("italics", "<i>$x$</i>");
        StringTemplate stringTemplate2 = stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate stringTemplate3 = new StringTemplate(stringTemplateGroup, "$bold(x=italics(x=name))$");
        stringTemplate3.setAttribute("name", "Terence");
        String string = "<b><i>Terence</i></b>";
        this.assertEqual(stringTemplate3.toString(), string);
    }

    public void testComplicatedSeparatorExpr() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bulletSeparator", "</li>$foo$<li>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "<ul>$name; separator=bulletSeparator(foo=\" \")+\"&nbsp;\"$</ul>");
        stringTemplate2.setAttribute("name", "Ter");
        stringTemplate2.setAttribute("name", "Tom");
        stringTemplate2.setAttribute("name", "Mel");
        String string = "<ul>Ter</li> <li>&nbsp;Tom</li> <li>&nbsp;Mel</ul>";
        this.assertEqual(stringTemplate2.toString(), string);
    }

    public void testAttributeRefButtedUpAgainstEndifAndWhitespace() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$if (!firstName)$$email$$endif$");
        stringTemplate.setAttribute("email", "parrt@jguru.com");
        String string = "parrt@jguru.com";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testStringCatenationOnSingleValuedAttributeViaTemplateLiteral() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$bold(it={$name$ Parr})$");
        stringTemplate2.setAttribute("name", "Terence");
        String string = "<b>Terence Parr</b>";
        this.assertEqual(stringTemplate2.toString(), string);
    }

    public void testStringCatenationOpOnArg() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$bold(it=name+\" Parr\")$");
        stringTemplate2.setAttribute("name", "Terence");
        String string = "<b>Terence Parr</b>";
        this.assertEqual(stringTemplate2.toString(), string);
    }

    public void testStringCatenationOpOnArgWithEqualsInString() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$bold(it=name+\" Parr=\")$");
        stringTemplate2.setAttribute("name", "Terence");
        String string = "<b>Terence Parr=</b>";
        this.assertEqual(stringTemplate2.toString(), string);
    }

    public void testApplyingTemplateFromDiskWithPrecompiledIF() throws Exception {
        String string = System.getProperty("line.separator");
        FileWriter fileWriter = new FileWriter("/tmp/page.st");
        fileWriter.write("<html><head>" + string);
        fileWriter.write("</head>" + string);
        fileWriter.write("<body>" + string);
        fileWriter.write("$if(member)$User: $member:terse()$$endif$" + string);
        fileWriter.write("</body>" + string);
        fileWriter.write("</head>" + string);
        fileWriter.close();
        fileWriter = new FileWriter("/tmp/terse.st");
        fileWriter.write("$it.firstName$ $it.lastName$ (<tt>$it.email$</tt>)" + string);
        fileWriter.close();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", "/tmp");
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("member", new Connector());
        String string2 = "<html><head>" + string + "</head>" + string + "<body>" + string + "User: Terence Parr (<tt>parrt@jguru.com</tt>)" + string + "</body>" + string + "</head>";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testMultiValuedAttributeWithAnonymousTemplateUsingIndexVariableI() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, " List:" + this.newline + "  " + this.newline + "foo" + this.newline + this.newline + "$names:{<br>$i$. $it$" + this.newline + "}$");
        stringTemplate.setAttribute("names", "Terence");
        stringTemplate.setAttribute("names", "Jim");
        stringTemplate.setAttribute("names", "Sriram");
        String string = System.getProperty("line.separator");
        String string2 = " List:" + string + "  " + string + "foo" + string + string + "<br>1. Terence" + string + "<br>2. Jim" + string + "<br>3. Sriram" + string;
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testFindTemplateInCLASSPATH() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("method stuff", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("org/antlr/stringtemplate/test/method");
        stringTemplate.setAttribute("visibility", "public");
        stringTemplate.setAttribute("name", "foobar");
        stringTemplate.setAttribute("returnType", "void");
        stringTemplate.setAttribute("statements", "i=1;");
        stringTemplate.setAttribute("statements", "x=i;");
        String string = System.getProperty("line.separator");
        String string2 = "public void foobar() {" + string + "\t// start of a body" + string + "\ti=1;" + string + "\tx=i;" + string + "\t// end of a body" + string + "}";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testApplyTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$name:bold(x=name)$");
        stringTemplate2.setAttribute("name", "Terence");
        this.assertEqual(stringTemplate2.toString(), "<b>Terence</b>");
    }

    public void testStringLiteralAsAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$\"Terence\":bold()$");
        this.assertEqual(stringTemplate2.toString(), "<b>Terence</b>");
    }

    public void testApplyTemplateToSingleValuedAttributeWithDefaultAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$name:bold()$");
        stringTemplate2.setAttribute("name", "Terence");
        this.assertEqual(stringTemplate2.toString(), "<b>Terence</b>");
    }

    public void testApplyAnonymousTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$item:{<li>$it$</li>}$");
        stringTemplate.setAttribute("item", "Terence");
        this.assertEqual(stringTemplate.toString(), "<li>Terence</li>");
    }

    public void testApplyAnonymousTemplateToMultiValuedAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<ul>$items$</ul>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$item:{<li>$it$</li>}; separator=\",\"$");
        stringTemplate2.setAttribute("item", "Terence");
        stringTemplate2.setAttribute("item", "Jim");
        stringTemplate2.setAttribute("item", "John");
        stringTemplate.setAttribute("items", stringTemplate2);
        this.assertEqual(stringTemplate.toString(), "<ul><li>Terence</li>,<li>Jim</li>,<li>John</li></ul>");
    }

    public void testApplyAnonymousTemplateToAggregateAttribute() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$items:{$it.lastName$, $it.firstName$\n}$");
        stringTemplate.setAttribute("items.{ firstName ,lastName}", "Ter", "Parr");
        stringTemplate.setAttribute("items.{firstName, lastName }", "Tom", "Burns");
        String string = "Parr, Ter" + this.newline + "Burns, Tom" + this.newline;
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testRepeatedApplicationOfTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$item:bold():bold()$");
        stringTemplate2.setAttribute("item", "Jim");
        this.assertEqual(stringTemplate2.toString(), "<b><b>Jim</b></b>");
    }

    public void testRepeatedApplicationOfTemplateToMultiValuedAttributeWithSeparator() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$item:bold():bold(); separator=\",\"$");
        stringTemplate2.setAttribute("item", "Jim");
        stringTemplate2.setAttribute("item", "Mike");
        stringTemplate2.setAttribute("item", "Ashar");
        this.assertEqual(stringTemplate2.toString(), "<b><b>Jim</b></b>,<b><b>Mike</b></b>,<b><b>Ashar</b></b>");
    }

    public void testMultiValuedAttributeWithSeparator() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "SELECT <distinct> <column; separator=\", \"> FROM <table>;");
        stringTemplate.setAttribute("column", "name");
        stringTemplate.setAttribute("column", "email");
        stringTemplate.setAttribute("table", "User");
        this.assertEqual(stringTemplate.toString(), "SELECT  name, email FROM User;");
    }

    public void testSingleValuedAttributes() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("SELECT $column$ FROM $table$;");
        stringTemplate.setAttribute("column", "name");
        stringTemplate.setAttribute("table", "User");
        this.assertEqual(stringTemplate.toString(), "SELECT name FROM User;");
    }

    public void testIFTemplate() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "SELECT <column> FROM PERSON <if(cond)>WHERE ID=<id><endif>;");
        stringTemplate.setAttribute("column", "name");
        stringTemplate.setAttribute("cond", "true");
        stringTemplate.setAttribute("id", "231");
        this.assertEqual(stringTemplate.toString(), "SELECT name FROM PERSON WHERE ID=231;");
    }

    public void testIFCondWithParensTemplate() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<if(map.(type))><type> <prop>=<map.(type)>;<endif>");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("int", "0");
        stringTemplate.setAttribute("map", hashMap);
        stringTemplate.setAttribute("prop", "x");
        stringTemplate.setAttribute("type", "int");
        this.assertEqual(stringTemplate.toString(), "int x=0;");
    }

    public void testIFCondWithParensDollarDelimsTemplate() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$if(map.(type))$$type$ $prop$=$map.(type)$;$endif$");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("int", "0");
        stringTemplate.setAttribute("map", hashMap);
        stringTemplate.setAttribute("prop", "x");
        stringTemplate.setAttribute("type", "int");
        this.assertEqual(stringTemplate.toString(), "int x=0;");
    }

    public void testIFBoolean() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$if(b)$x$endif$ $if(!b)$y$endif$");
        stringTemplate.setAttribute("b", new Boolean(true));
        this.assertEqual(stringTemplate.toString(), "x ");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("b", new Boolean(false));
        this.assertEqual(stringTemplate.toString(), " y");
    }

    public void testNestedIFTemplate() throws Exception {
        String string = System.getProperty("line.separator");
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "ack<if(a)>" + string + "foo" + string + "<if(!b)>stuff<endif>" + string + "<if(b)>no<endif>" + string + "junk" + string + "<endif>");
        stringTemplate.setAttribute("a", "blort");
        String string2 = "ackfoo" + string + "stuff" + string + "junk";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testObjectPropertyReference() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        String string = System.getProperty("line.separator");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<b>Name: $p.firstName$ $p.lastName$</b><br>" + string + "<b>Email: $p.email$</b><br>" + string + "$p.bio$");
        stringTemplate.setAttribute("p", new Connector());
        String string2 = "<b>Name: Terence Parr</b><br>" + string + "<b>Email: parrt@jguru.com</b><br>" + string + "Superhero by night...";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testApplyRepeatedAnonymousTemplateWithForeignTemplateRefToMultiValuedAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        stringTemplateGroup.defineTemplate("link", "<a href=\"$url$\"><b>$title$</b></a>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "start|$p:{$link(url=\"/member/view?ID=\"+it.ID, title=it.firstName)$ $if(it.canEdit)$canEdit$endif$}:{$it$<br>\n}$|end");
        stringTemplate.setAttribute("p", new Connector());
        stringTemplate.setAttribute("p", new Connector2());
        String string = System.getProperty("line.separator");
        String string2 = "start|<a href=\"/member/view?ID=1\"><b>Terence</b></a> <br>" + string + "<a href=\"/member/view?ID=2\"><b>Tom</b></a> canEdit<br>" + string + "|end";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testRecursion() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        stringTemplateGroup.defineTemplate("tree", "<if(it.firstChild)>( <it.text> <it.children:tree(); separator=\" \"> )<else><it.text><endif>");
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("tree");
        Tree tree = new Tree("a");
        tree.addChild(new Tree("b"));
        Tree tree2 = new Tree("c");
        tree2.addChild(new Tree("d"));
        tree.addChild(tree2);
        tree.addChild(new Tree("e"));
        stringTemplate.setAttribute("it", tree);
        String string = "( a b ( c d ) e )";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNestedAnonymousTemplates() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        String string = System.getProperty("line.separator");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A:{" + string + "<i>$it:{" + string + "<b>$it$</b>" + string + "}$</i>" + string + "}$");
        stringTemplate.setAttribute("A", "parrt");
        String string2 = string + "<i>" + string + "<b>parrt</b>" + string + "</i>" + string;
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testAnonymousTemplateAccessToEnclosingAttributes() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        String string = System.getProperty("line.separator");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A:{" + string + "<i>$it:{" + string + "<b>$it$, $B$</b>" + string + "}$</i>" + string + "}$");
        stringTemplate.setAttribute("A", "parrt");
        stringTemplate.setAttribute("B", "tombu");
        String string2 = string + "<i>" + string + "<b>parrt, tombu</b>" + string + "</i>" + string;
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testNestedAnonymousTemplatesAgain() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        String string = System.getProperty("line.separator");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<table>" + string + "$names:{<tr>$it:{<td>$it:{<b>$it$</b>}$</td>}$</tr>}$" + string + "</table>" + string);
        stringTemplate.setAttribute("names", "parrt");
        stringTemplate.setAttribute("names", "tombu");
        String string2 = "<table>" + string + "<tr><td><b>parrt</b></td></tr><tr><td><b>tombu</b></td></tr>" + string + "</table>" + string;
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testEscapes() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        String string = System.getProperty("line.separator");
        stringTemplateGroup.defineTemplate("foo", "$x$ && $it$");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A:foo(x=\"dog\\\"\\\"\")$");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$A:foo(x=\"dog\\\"g\")$");
        StringTemplate stringTemplate3 = new StringTemplate(stringTemplateGroup, "$A:{$it:foo(x=\"\\{dog\\}\\\"\")$ is cool}$");
        stringTemplate.setAttribute("A", "ick");
        stringTemplate2.setAttribute("A", "ick");
        stringTemplate3.setAttribute("A", "ick");
        String string2 = "dog\"\" && ick";
        this.assertEqual(stringTemplate.toString(), string2);
        string2 = "dog\"g && ick";
        this.assertEqual(stringTemplate2.toString(), string2);
        string2 = "{dog}\" && ick is cool";
        this.assertEqual(stringTemplate3.toString(), string2);
    }

    public void testEscapesOutsideExpressions() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("It\\'s ok...\\$; $a:{\\'hi\\', $it$}$");
        stringTemplate.setAttribute("a", "Ter");
        String string = "It\\'s ok...$; \\'hi\\', Ter";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testElseClause() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$if(title)$" + this.newline + "foo" + this.newline + "$else$" + this.newline + "bar" + this.newline + "$endif$");
        stringTemplate.setAttribute("title", "sample");
        String string = "foo";
        this.assertEqual(stringTemplate.toString(), string);
        stringTemplate = stringTemplate.getInstanceOf();
        string = "bar";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNestedIF() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$if(title)$" + this.newline + "foo" + this.newline + "$else$" + this.newline + "$if(header)$" + this.newline + "bar" + this.newline + "$else$" + this.newline + "blort" + this.newline + "$endif$" + this.newline + "$endif$");
        stringTemplate.setAttribute("title", "sample");
        String string = "foo";
        this.assertEqual(stringTemplate.toString(), string);
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("header", "more");
        string = "bar";
        this.assertEqual(stringTemplate.toString(), string);
        stringTemplate = stringTemplate.getInstanceOf();
        string = "blort";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testEmbeddedMultiLineIF() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$sub$");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "begin" + this.newline + "$if(foo)$" + this.newline + "$foo$" + this.newline + "$else$" + this.newline + "blort" + this.newline + "$endif$" + this.newline);
        stringTemplate2.setAttribute("foo", "stuff");
        stringTemplate.setAttribute("sub", stringTemplate2);
        String string = "begin" + this.newline + "stuff";
        this.assertEqual(stringTemplate.toString(), string);
        stringTemplate = new StringTemplate(stringTemplateGroup, "$sub$");
        stringTemplate2 = stringTemplate2.getInstanceOf();
        stringTemplate.setAttribute("sub", stringTemplate2);
        string = "begin" + this.newline + "blort";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testSimpleIndentOfAttributeList() throws Exception {
        String string = "group test;" + this.newline + "list(names) ::= <<" + "  $names; separator=\"\n\"$" + this.newline + ">>" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("list");
        stringTemplate.setAttribute("names", "Terence");
        stringTemplate.setAttribute("names", "Jim");
        stringTemplate.setAttribute("names", "Sriram");
        String string2 = "  Terence" + this.newline + "  Jim" + this.newline + "  Sriram";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testIndentOfMultilineAttributes() throws Exception {
        String string = "group test;" + this.newline + "list(names) ::= <<" + "  $names; separator=\"\n\"$" + this.newline + ">>" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("list");
        stringTemplate.setAttribute("names", "Terence\nis\na\nmaniac");
        stringTemplate.setAttribute("names", "Jim");
        stringTemplate.setAttribute("names", "Sriram\nis\ncool");
        String string2 = "  Terence" + this.newline + "  is" + this.newline + "  a" + this.newline + "  maniac" + this.newline + "  Jim" + this.newline + "  Sriram" + this.newline + "  is" + this.newline + "  cool";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testIndentOfMultipleBlankLines() throws Exception {
        String string = "group test;" + this.newline + "list(names) ::= <<" + "  $names$" + this.newline + ">>" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("list");
        stringTemplate.setAttribute("names", "Terence\n\nis a maniac");
        String string2 = "  Terence" + this.newline + "" + this.newline + "  is a maniac";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testIndentBetweenLeftJustifiedLiterals() throws Exception {
        String string = "group test;" + this.newline + "list(names) ::= <<" + "Before:" + this.newline + "  $names; separator=\"\\n\"$" + this.newline + "after" + this.newline + ">>" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("list");
        stringTemplate.setAttribute("names", "Terence");
        stringTemplate.setAttribute("names", "Jim");
        stringTemplate.setAttribute("names", "Sriram");
        String string2 = "Before:" + this.newline + "  Terence" + this.newline + "  Jim" + this.newline + "  Sriram" + this.newline + "after";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testNestedIndent() throws Exception {
        String string = "group test;" + this.newline + "method(name,stats) ::= <<" + "void $name$() {" + this.newline + "\t$stats; separator=\"\\n\"$" + this.newline + "}" + this.newline + ">>" + this.newline + "ifstat(expr,stats) ::= <<" + this.newline + "if ($expr$) {" + this.newline + "  $stats; separator=\"\\n\"$" + this.newline + "}" + ">>" + this.newline + "assign(lhs,expr) ::= <<$lhs$=$expr$;>>" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("assign");
        stringTemplate2.setAttribute("lhs", "x");
        stringTemplate2.setAttribute("expr", "0");
        StringTemplate stringTemplate3 = stringTemplateGroup.getInstanceOf("ifstat");
        stringTemplate3.setAttribute("expr", "x>0");
        StringTemplate stringTemplate4 = stringTemplateGroup.getInstanceOf("assign");
        stringTemplate4.setAttribute("lhs", "y");
        stringTemplate4.setAttribute("expr", "x+y");
        StringTemplate stringTemplate5 = stringTemplateGroup.getInstanceOf("assign");
        stringTemplate5.setAttribute("lhs", "z");
        stringTemplate5.setAttribute("expr", "4");
        stringTemplate3.setAttribute("stats", stringTemplate4);
        stringTemplate3.setAttribute("stats", stringTemplate5);
        stringTemplate.setAttribute("stats", stringTemplate2);
        stringTemplate.setAttribute("stats", stringTemplate3);
        String string2 = "void foo() {" + this.newline + "\tx=0;" + this.newline + "\tif (x>0) {" + this.newline + "\t  y=x+y;" + this.newline + "\t  z=4;" + this.newline + "\t}" + this.newline + "}";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testAlternativeWriter() throws Exception {
        final StringBuffer stringBuffer = new StringBuffer();
        StringTemplateWriter stringTemplateWriter = new StringTemplateWriter(){

            public void pushIndentation(String string) {
            }

            public String popIndentation() {
                return null;
            }

            public void pushAnchorPoint() {
            }

            public void popAnchorPoint() {
            }

            public void setLineWidth(int n) {
            }

            public int write(String string, String string2) throws IOException {
                return 0;
            }

            public int write(String string) throws IOException {
                stringBuffer.append(string);
                return string.length();
            }

            public int writeWrapSeparator(String string) throws IOException {
                return 0;
            }

            public int writeSeparator(String string) throws IOException {
                return this.write(string);
            }
        };
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$name:bold(x=name)$");
        stringTemplate.setAttribute("name", "Terence");
        stringTemplate.write(stringTemplateWriter);
        this.assertEqual(stringBuffer.toString(), "<b>Terence</b>");
    }

    public void testApplyAnonymousTemplateToMapAndSet() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$items:{<li>$it$</li>}$");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("a", "1");
        hashMap.put("b", "2");
        hashMap.put("c", "3");
        stringTemplate.setAttribute("items", hashMap);
        String string = "<li>1</li><li>3</li><li>2</li>";
        this.assertEqual(stringTemplate.toString(), string);
        stringTemplate = stringTemplate.getInstanceOf();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("1");
        hashSet.add("2");
        hashSet.add("3");
        stringTemplate.setAttribute("items", hashSet);
        string = "<li>3</li><li>2</li><li>1</li>";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testDumpMapAndSet() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$items; separator=\",\"$");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("a", "1");
        hashMap.put("b", "2");
        hashMap.put("c", "3");
        stringTemplate.setAttribute("items", hashMap);
        String string = "1,3,2";
        this.assertEqual(stringTemplate.toString(), string);
        stringTemplate = stringTemplate.getInstanceOf();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("1");
        hashSet.add("2");
        hashSet.add("3");
        stringTemplate.setAttribute("items", hashSet);
        string = "3,2,1";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testApplyAnonymousTemplateToArrayAndMapProperty() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$x.values:{<li>$it$</li>}$");
        stringTemplate.setAttribute("x", new Connector3());
        String string = "<li>1</li><li>2</li><li>3</li>";
        this.assertEqual(stringTemplate.toString(), string);
        stringTemplate = new StringTemplate("$x.stuff:{<li>$it$</li>}$");
        stringTemplate.setAttribute("x", new Connector3());
        string = "<li>1</li><li>2</li>";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testSuperTemplateRef() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("super");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        stringTemplateGroup.defineTemplate("page", "$font()$:text");
        stringTemplateGroup.defineTemplate("font", "Helvetica");
        stringTemplateGroup2.defineTemplate("font", "$super.font()$ and Times");
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("page");
        String string = "Helvetica and Times:text";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testApplySuperTemplateRef() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("super");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup2.defineTemplate("bold", "<strong>$it$</strong>");
        stringTemplateGroup2.defineTemplate("page", "$name:super.bold()$");
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("page");
        stringTemplate.setAttribute("name", "Ter");
        String string = "<b>Ter</b>";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testLazyEvalOfSuperInApplySuperTemplateRef() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("base");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup2.defineTemplate("bold", "<strong>$it$</strong>");
        stringTemplateGroup.defineTemplate("page", "$name:super.bold()$");
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("page");
        stringTemplate.setAttribute("name", "Ter");
        String string = null;
        try {
            stringTemplate.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = illegalArgumentException.getMessage();
        }
        String string2 = "base has no super group; invalid template: super.bold";
        this.assertEqual(string, string2);
    }

    public void testTemplatePolymorphism() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("super");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup.defineTemplate("page", "$name:bold()$");
        stringTemplateGroup2.defineTemplate("bold", "<strong>$it$</strong>");
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("page");
        stringTemplate.setAttribute("name", "Ter");
        String string = "<strong>Ter</strong>";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testListOfEmbeddedTemplateSeesEnclosingAttributes() throws Exception {
        String string = "group test;" + this.newline + "output(cond,items) ::= <<page: $items$>>" + this.newline + "mybody() ::= <<$font()$stuff>>" + this.newline + "font() ::= <<$if(cond)$this$else$that$endif$>>";
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("output");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("mybody");
        StringTemplate stringTemplate3 = stringTemplateGroup.getInstanceOf("mybody");
        StringTemplate stringTemplate4 = stringTemplateGroup.getInstanceOf("mybody");
        stringTemplate.setAttribute("items", stringTemplate2);
        stringTemplate.setAttribute("items", stringTemplate3);
        stringTemplate.setAttribute("items", stringTemplate4);
        String string2 = "page: thatstuffthatstuffthatstuff";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testInheritArgumentFromRecursiveTemplateApplication() throws Exception {
        String string = "group test;" + this.newline + "block(stats) ::= \"<stats>\"" + "ifstat(stats) ::= \"IF true then <stats>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("block");
        stringTemplate.setAttribute("stats", stringTemplateGroup.getInstanceOf("ifstat"));
        stringTemplate.setAttribute("stats", stringTemplateGroup.getInstanceOf("ifstat"));
        String string2 = "IF true then IF true then ";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testDeliberateRecursiveTemplateApplication() throws Exception {
        String string = "group test;" + this.newline + "block(stats) ::= \"<stats>\"" + "ifstat(stats) ::= \"IF true then <stats>\"" + this.newline;
        StringTemplate.setLintMode(true);
        StringTemplate.resetTemplateCounter();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("block");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("ifstat");
        stringTemplate.setAttribute("stats", stringTemplate2);
        stringTemplate2.setAttribute("stats", stringTemplate);
        String string2 = "infinite recursion to <ifstat([stats])@4> referenced in <block([stats])@3>; stack trace:" + this.newline + "<ifstat([stats])@4>, attributes=[stats=<block()@3>]>" + this.newline + "<block([stats])@3>, attributes=[stats=<ifstat()@4>], references=[stats]>" + this.newline + "<ifstat([stats])@4> (start of recursive cycle)" + this.newline + "...";
        String string3 = "";
        try {
            String string4 = stringTemplate.toString();
        }
        catch (IllegalStateException illegalStateException) {
            string3 = illegalStateException.getMessage();
        }
        StringTemplate.setLintMode(false);
        this.assertEqual(string3, string2);
    }

    public void testImmediateTemplateAsAttributeLoop() throws Exception {
        String string = "group test;" + this.newline + "block(stats) ::= \"{<stats>}\"";
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("block");
        stringTemplate.setAttribute("stats", stringTemplateGroup.getInstanceOf("block"));
        String string2 = "{{}}";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testTemplateAlias() throws Exception {
        String string = "group test;" + this.newline + "page(name) ::= \"name is <name>\"" + "other ::= page" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("other");
        stringTemplate.setAttribute("name", "Ter");
        String string2 = "name is Ter";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testTemplateGetPropertyGetsAttribute() throws Exception {
        String string = "group test;" + this.newline + "Cfile(funcs) ::= <<" + this.newline + "#include \\<stdio.h>" + this.newline + "<funcs:{public void <it.name>(<it.args>);}; separator=\"\\n\">" + this.newline + "<funcs; separator=\"\\n\">" + this.newline + ">>" + this.newline + "func(name,args,body) ::= <<" + this.newline + "public void <name>(<args>) {<body>}" + this.newline + ">>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("Cfile");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("func");
        StringTemplate stringTemplate3 = stringTemplateGroup.getInstanceOf("func");
        stringTemplate2.setAttribute("name", "f");
        stringTemplate2.setAttribute("args", "");
        stringTemplate2.setAttribute("body", "i=1;");
        stringTemplate3.setAttribute("name", "g");
        stringTemplate3.setAttribute("args", "int arg");
        stringTemplate3.setAttribute("body", "y=1;");
        stringTemplate.setAttribute("funcs", stringTemplate2);
        stringTemplate.setAttribute("funcs", stringTemplate3);
        String string2 = "#include <stdio.h>" + this.newline + "public void f();" + this.newline + "public void g(int arg);" + this.newline + "public void f() {i=1;}" + this.newline + "public void g(int arg) {y=1;}";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testComplicatedIndirectTemplateApplication() throws Exception {
        String string = "group Java;" + this.newline + "" + this.newline + "file(variables) ::= <<" + "<variables:{ v | <v.decl:(v.format)()>}; separator=\"\\n\">" + this.newline + ">>" + this.newline + "intdecl(decl) ::= \"int <decl.name> = 0;\"" + this.newline + "intarray(decl) ::= \"int[] <decl.name> = null;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("file");
        stringTemplate.setAttribute("variables.{decl,format}", new Decl("i", "int"), "intdecl");
        stringTemplate.setAttribute("variables.{decl,format}", new Decl("a", "int-array"), "intarray");
        String string2 = "int i = 0;" + this.newline + "int[] a = null;";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testIndirectTemplateApplication() throws Exception {
        String string = "group dork;" + this.newline + "" + this.newline + "test(name) ::= <<" + "<(name)()>" + this.newline + ">>" + this.newline + "first() ::= \"the first\"" + this.newline + "second() ::= \"the second\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("name", "first");
        String string2 = "the first";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testIndirectTemplateWithArgsApplication() throws Exception {
        String string = "group dork;" + this.newline + "" + this.newline + "test(name) ::= <<" + "<(name)(a=\"foo\")>" + this.newline + ">>" + this.newline + "first(a) ::= \"the first: <a>\"" + this.newline + "second(a) ::= \"the second <a>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("name", "first");
        String string2 = "the first: foo";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testNullIndirectTemplateApplication() throws Exception {
        String string = "group dork;" + this.newline + "" + this.newline + "test(names) ::= <<" + "<names:(ind)()>" + this.newline + ">>" + this.newline + "ind() ::= \"[<it>]\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "me");
        stringTemplate.setAttribute("names", "you");
        String string2 = "";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testNullIndirectTemplate() throws Exception {
        String string = "group dork;" + this.newline + "" + this.newline + "test(name) ::= <<" + "<(name)()>" + this.newline + ">>" + this.newline + "first() ::= \"the first\"" + this.newline + "second() ::= \"the second\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        String string2 = "";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testHashMapPropertyFetch() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$stuff.prop$");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        stringTemplate.setAttribute("stuff", hashMap);
        hashMap.put("prop", "Terence");
        String string = stringTemplate.toString();
        String string2 = "Terence";
        this.assertEqual(string, string2);
    }

    public void testHashMapPropertyFetchEmbeddedStringTemplate() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$stuff.prop$");
        HashMap<String, StringTemplate> hashMap = new HashMap<String, StringTemplate>();
        stringTemplate.setAttribute("stuff", hashMap);
        stringTemplate.setAttribute("title", "ST rocks");
        hashMap.put("prop", new StringTemplate("embedded refers to $title$"));
        String string = stringTemplate.toString();
        String string2 = "embedded refers to ST rocks";
        this.assertEqual(string, string2);
    }

    public void testEmbeddedComments() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Foo $! ignore !$bar" + this.newline);
        String string = "Foo bar" + this.newline;
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
        stringTemplate = new StringTemplate("Foo $! ignore" + this.newline + " and a line break!$" + this.newline + "bar" + this.newline);
        string = "Foo " + this.newline + "bar" + this.newline;
        string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
        stringTemplate = new StringTemplate("$! start of line $ and $! ick" + this.newline + "!$boo" + this.newline);
        string = "boo" + this.newline;
        string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
        stringTemplate = new StringTemplate("$! start of line !$" + this.newline + "$! another to ignore !$" + this.newline + "$! ick" + this.newline + "!$boo" + this.newline);
        string = "boo" + this.newline;
        string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
        stringTemplate = new StringTemplate("$! back !$$! to back !$" + this.newline + "$! ick" + this.newline + "!$boo" + this.newline);
        string = this.newline + "boo" + this.newline;
        string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testEmbeddedCommentsAngleBracketed() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Foo <! ignore !>bar" + this.newline, class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        String string = "Foo bar" + this.newline;
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
        stringTemplate = new StringTemplate("Foo <! ignore" + this.newline + " and a line break!>" + this.newline + "bar" + this.newline, class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        string = "Foo " + this.newline + "bar" + this.newline;
        string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
        stringTemplate = new StringTemplate("<! start of line $ and <! ick" + this.newline + "!>boo" + this.newline, class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        string = "boo" + this.newline;
        string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
        stringTemplate = new StringTemplate("<! start of line !><! another to ignore !><! ick" + this.newline + "!>boo" + this.newline, class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        string = "boo" + this.newline;
        string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
        stringTemplate = new StringTemplate("<! back !><! to back !>" + this.newline + "<! ick" + this.newline + "!>boo" + this.newline, class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        string = this.newline + "boo" + this.newline;
        string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testCharLiterals() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Foo <\\n><\\t> bar" + this.newline, class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        String string = "Foo " + this.newline + "\t bar" + this.newline;
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
        stringTemplate = new StringTemplate("Foo $\\n$$\\t$ bar" + this.newline);
        string = "Foo " + this.newline + "\t bar" + this.newline;
        string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
        stringTemplate = new StringTemplate("Foo$\\ $bar$\\n$");
        string = "Foo bar" + this.newline;
        string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testEmptyIteratedValueGetsSeparator() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$names; separator=\",\"$");
        stringTemplate.setAttribute("names", "Terence");
        stringTemplate.setAttribute("names", "");
        stringTemplate.setAttribute("names", "");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Frank");
        stringTemplate.setAttribute("names", "");
        String string = "Terence,,,Tom,Frank,";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testEmptyIteratedConditionalValueGetsSeparator() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$users:{$if(it.ok)$$it.name$$endif$}; separator=\",\"$");
        stringTemplate.setAttribute("users.{name,ok}", "Terence", new Boolean(true));
        stringTemplate.setAttribute("users.{name,ok}", "Tom", new Boolean(false));
        stringTemplate.setAttribute("users.{name,ok}", "Frank", new Boolean(true));
        stringTemplate.setAttribute("users.{name,ok}", "Johnny", new Boolean(false));
        String string = "Terence,,Frank,";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testEmptyIteratedConditionalWithElseValueGetsSeparator() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$users:{$if(it.ok)$$it.name$$else$$endif$}; separator=\",\"$");
        stringTemplate.setAttribute("users.{name,ok}", "Terence", new Boolean(true));
        stringTemplate.setAttribute("users.{name,ok}", "Tom", new Boolean(false));
        stringTemplate.setAttribute("users.{name,ok}", "Frank", new Boolean(true));
        stringTemplate.setAttribute("users.{name,ok}", "Johnny", new Boolean(false));
        String string = "Terence,,Frank,";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testWhiteSpaceAtEndOfTemplate() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("group");
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("org/antlr/stringtemplate/test/page");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("org/antlr/stringtemplate/test/users_list");
        stringTemplate2.setAttribute("users", new Connector());
        stringTemplate2.setAttribute("users", new Connector2());
        stringTemplate.setAttribute("title", "some title");
        stringTemplate.setAttribute("body", stringTemplate2);
        String string = "some title" + this.newline + "Terence parrt@jguru.comTom tombu@jguru.com";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testSizeZeroButNonNullListGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n$duh.users:{name: $it$}; separator=\", \"$\nend\n");
        stringTemplate.setAttribute("duh", new Duh());
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testNullListGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n$users:{name: $it$}; separator=\", \"$\nend\n");
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testEmptyListGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n$users:{name: $it$}; separator=\", \"$\nend\n");
        stringTemplate.setAttribute("users", new ArrayList());
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testEmptyListNoIteratorGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n$users; separator=\", \"$\nend\n");
        stringTemplate.setAttribute("users", new ArrayList());
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testEmptyExprAsFirstLineGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$users$\nend\n");
        String string = "end\n";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testSizeZeroOnLineByItselfGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n$name$\n$users:{name: $it$}$\n$users:{name: $it$}; separator=\", \"$\nend\n");
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testSizeZeroOnLineWithIndentGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n  $name$\n\t$users:{name: $it$}$\n\t$users:{name: $it$$\\n$}$\nend\n");
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testSimpleAutoIndent() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$title$: {\n\t$name; separator=\"\n\"$\n}");
        stringTemplate.setAttribute("title", "foo");
        stringTemplate.setAttribute("name", "Terence");
        stringTemplate.setAttribute("name", "Frank");
        String string = stringTemplate.toString();
        String string2 = "foo: {\n\tTerence\n\tFrank\n}";
        this.assertEqual(string, string2);
    }

    public void testComputedPropertyName() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "variable property $propName$=$v.(propName)$");
        stringTemplate.setAttribute("v", new Decl("i", "int"));
        stringTemplate.setAttribute("propName", "type");
        String string = "variable property type=int";
        String string2 = stringTemplate.toString();
        this.assertEqual(((Object)errorBuffer).toString(), "");
        this.assertEqual(string2, string);
    }

    public void testNonNullButEmptyIteratorTestsFalse() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$if(users)$\nUsers: $users:{$it.name$ }$\n$endif$");
        stringTemplate.setAttribute("users", new LinkedList());
        String string = "";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testDoNotInheritAttributesThroughFormalArgs() throws Exception {
        String string = "group test;" + this.newline + "method(name) ::= \"<stat()>\"" + this.newline + "stat(name) ::= \"x=y; // <name>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=y; // ";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testArgEvaluationContext() throws Exception {
        String string = "group test;" + this.newline + "method(name) ::= \"<stat(name=name)>\"" + this.newline + "stat(name) ::= \"x=y; // <name>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=y; // foo";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testPassThroughAttributes() throws Exception {
        String string = "group test;" + this.newline + "method(name) ::= \"<stat(...)>\"" + this.newline + "stat(name) ::= \"x=y; // <name>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=y; // foo";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testPassThroughAttributes2() throws Exception {
        String string = "group test;" + this.newline + "method(name) ::= <<" + this.newline + "<stat(value=\"34\",...)>" + this.newline + ">>" + this.newline + "stat(name,value) ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=34; // foo";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testDefaultArgument() throws Exception {
        String string = "group test;" + this.newline + "method(name) ::= <<" + this.newline + "<stat(...)>" + this.newline + ">>" + this.newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=99; // foo";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testDefaultArgument2() throws Exception {
        String string = "group test;" + this.newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("stat");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=99; // foo";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testDefaultArgumentAsTemplate() throws Exception {
        String string = "group test;" + this.newline + "method(name,size) ::= <<" + this.newline + "<stat(...)>" + this.newline + ">>" + this.newline + "stat(name,value={<name>}) ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        stringTemplate.setAttribute("size", "2");
        String string2 = "x=foo; // foo";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testDefaultArgumentAsTemplate2() throws Exception {
        String string = "group test;" + this.newline + "method(name,size) ::= <<" + this.newline + "<stat(...)>" + this.newline + ">>" + this.newline + "stat(name,value={ [<name>] }) ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        stringTemplate.setAttribute("size", "2");
        String string2 = "x= [foo] ; // foo";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testDoNotUseDefaultArgument() throws Exception {
        String string = "group test;" + this.newline + "method(name) ::= <<" + this.newline + "<stat(value=\"34\",...)>" + this.newline + ">>" + this.newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=34; // foo";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testArgumentsAsTemplates() throws Exception {
        String string = "group test;" + this.newline + "method(name,size) ::= <<" + this.newline + "<stat(value={<size>})>" + this.newline + ">>" + this.newline + "stat(value) ::= \"x=<value>;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        stringTemplate.setAttribute("size", "34");
        String string2 = "x=34;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testArgumentsAsTemplatesDefaultDelimiters() throws Exception {
        String string = "group test;" + this.newline + "method(name,size) ::= <<" + this.newline + "$stat(value={$size$})$" + this.newline + ">>" + this.newline + "stat(value) ::= \"x=$value$;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        stringTemplate.setAttribute("size", "34");
        String string2 = "x=34;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testDefaultArgsWhenNotInvoked() throws Exception {
        String string = "group test;" + this.newline + "b(name=\"foo\") ::= \".<name>.\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("b");
        String string2 = ".foo.";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testRendererForST() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("date: <created>", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        stringTemplate.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        stringTemplate.registerRenderer(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = TestStringTemplate.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar, new DateRenderer());
        String string = "date: 2005.07.05";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testEmbeddedRendererSeesEnclosing() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("X: <x>", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate2 = new StringTemplate("date: <created>", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        stringTemplate2.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        stringTemplate.setAttribute("x", stringTemplate2);
        stringTemplate.registerRenderer(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = TestStringTemplate.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar, new DateRenderer());
        String string = "X: date: 2005.07.05";
        String string2 = stringTemplate.toString();
        this.assertEqual(string2, string);
    }

    public void testRendererForGroup() throws Exception {
        String string = "group test;" + this.newline + "dateThing(created) ::= \"date: <created>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("dateThing");
        stringTemplate.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        stringTemplateGroup.registerRenderer(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = TestStringTemplate.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar, new DateRenderer());
        String string2 = "date: 2005.07.05";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testOverriddenRenderer() throws Exception {
        String string = "group test;" + this.newline + "dateThing(created) ::= \"date: <created>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("dateThing");
        stringTemplate.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        stringTemplateGroup.registerRenderer(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = TestStringTemplate.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar, new DateRenderer());
        stringTemplate.registerRenderer(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = TestStringTemplate.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar, new DateRenderer2());
        String string2 = "date: 07/05/2005";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testMap() throws Exception {
        String string = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "int");
        stringTemplate.setAttribute("name", "x");
        String string2 = "int x = 0;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testMapValuesAreTemplates() throws Exception {
        String string = "group test;" + this.newline + "typeInit ::= [\"int\":\"0<w>\", \"float\":\"0.0<w>\"] " + this.newline + "var(type,w,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("w", "L");
        stringTemplate.setAttribute("type", "int");
        stringTemplate.setAttribute("name", "x");
        String string2 = "int x = 0L;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testMapMissingDefaultValueIsEmpty() throws Exception {
        String string = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + this.newline + "var(type,w,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("w", "L");
        stringTemplate.setAttribute("type", "double");
        stringTemplate.setAttribute("name", "x");
        String string2 = "double x = ;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testMapHiddenByFormalArg() throws Exception {
        String string = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + this.newline + "var(typeInit,type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "int");
        stringTemplate.setAttribute("name", "x");
        String string2 = "int x = ;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testMapEmptyValueAndAngleBracketStrings() throws Exception {
        String string = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":, \"double\":<<0.0L>>] " + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "float");
        stringTemplate.setAttribute("name", "x");
        String string2 = "float x = ;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testMapDefaultValue() throws Exception {
        String string = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"default\":\"null\"] " + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "UserRecord");
        stringTemplate.setAttribute("name", "x");
        String string2 = "UserRecord x = null;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testMapEmptyDefaultValue() throws Exception {
        String string = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"default\":] " + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "UserRecord");
        stringTemplate.setAttribute("name", "x");
        String string2 = "UserRecord x = ;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testMapEmptyDefaultValueIsKey() throws Exception {
        String string = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"default\":key] " + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "UserRecord");
        stringTemplate.setAttribute("name", "x");
        String string2 = "UserRecord x = UserRecord;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testMapViaEnclosingTemplates() throws Exception {
        String string = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + this.newline + "intermediate(type,name) ::= \"<var(...)>\"" + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("intermediate");
        stringTemplate.setAttribute("type", "int");
        stringTemplate.setAttribute("name", "x");
        String string2 = "int x = 0;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testMapViaEnclosingTemplates2() throws Exception {
        String string = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + this.newline + "intermediate(stuff) ::= \"<stuff>\"" + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("intermediate");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("var");
        stringTemplate2.setAttribute("type", "int");
        stringTemplate2.setAttribute("name", "x");
        stringTemplate.setAttribute("stuff", stringTemplate2);
        String string2 = "int x = 0;";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testEmptyGroupTemplate() throws Exception {
        String string = "group test;" + this.newline + "foo() ::= \"\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("foo");
        String string2 = "";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testEmptyStringAndEmptyAnonTemplateAsParameterUsingAngleBracketLexer() throws Exception {
        String string = "group test;" + this.newline + "top() ::= <<<x(a=\"\", b={})\\>>>" + this.newline + "x(a,b) ::= \"a=<a>, b=<b>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        String string2 = "a=, b=";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testEmptyStringAndEmptyAnonTemplateAsParameterUsingDollarLexer() throws Exception {
        String string = "group test;" + this.newline + "top() ::= <<$x(a=\"\", b={})$>>" + this.newline + "x(a,b) ::= \"a=$a$, b=$b$\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        String string2 = "a=, b=";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void test8BitEuroChars() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Danish: \u00c5 char");
        stringTemplate = stringTemplate.getInstanceOf();
        String string = "Danish: \u00c5 char";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testFirstOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$first(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Ter";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testRestOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$rest(names); separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Tom, Sriram";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testLastOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$last(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Sriram";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testCombinedOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[first(mine),rest(yours)]; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("mine", "1");
        stringTemplate.setAttribute("mine", "2");
        stringTemplate.setAttribute("mine", "3");
        stringTemplate.setAttribute("yours", "a");
        stringTemplate.setAttribute("yours", "b");
        String string = "1, b";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testCatListAndSingleAttribute() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[mine,yours]; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("mine", "1");
        stringTemplate.setAttribute("mine", "2");
        stringTemplate.setAttribute("mine", "3");
        stringTemplate.setAttribute("yours", "a");
        String string = "1, 2, 3, a";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testCatListAndEmptyAttributes() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[x,mine,y,yours,z]; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("mine", "1");
        stringTemplate.setAttribute("mine", "2");
        stringTemplate.setAttribute("mine", "3");
        stringTemplate.setAttribute("yours", "a");
        String string = "1, 2, 3, a";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNestedOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$first(rest(names))$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Tom";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testFirstWithOneAttributeOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$first(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        String string = "Ter";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testLastWithOneAttributeOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$last(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        String string = "Ter";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testLastWithLengthOneListAttributeOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$last(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", new ArrayList(){
            {
                this.add("Ter");
            }
        });
        String string = "Ter";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testRestWithOneAttributeOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$rest(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        String string = "";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testRestWithLengthOneListAttributeOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$rest(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", new ArrayList(){
            {
                this.add("Ter");
            }
        });
        String string = "";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testRepeatedRestOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$rest(names)$, $rest(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string = "Tom, Tom";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testRepeatedIteratedAttrFromArg() throws Exception {
        String string = "group test;" + this.newline + "root(names) ::= \"$other(names)$\"" + this.newline + "other(x) ::= \"$x$, $x$\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("root");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Ter");
        arrayList.add("Tom");
        stringTemplate.setAttribute("names", arrayList.iterator());
        String string2 = "TerTom, ";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testRepeatedRestOpAsArg() throws Exception {
        String string = "group test;" + this.newline + "root(names) ::= \"$other(rest(names))$\"" + this.newline + "other(x) ::= \"$x$, $x$\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("root");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string2 = "Tom, Tom";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testIncomingLists() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$rest(names)$, $rest(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string = "Tom, Tom";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testIncomingListsAreNotModified() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Ter");
        arrayList.add("Tom");
        stringTemplate.setAttribute("names", arrayList);
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Ter, Tom, Sriram";
        this.assertEqual(stringTemplate.toString(), string);
        this.assertEqual(arrayList.size(), 2);
    }

    public void testIncomingListsAreNotModified2() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Ter");
        arrayList.add("Tom");
        stringTemplate.setAttribute("names", "Sriram");
        stringTemplate.setAttribute("names", arrayList);
        String string = "Sriram, Ter, Tom";
        this.assertEqual(stringTemplate.toString(), string);
        this.assertEqual(arrayList.size(), 2);
    }

    public void testIncomingArraysAreOk() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", (Object)new String[]{"Ter", "Tom"});
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Ter, Tom, Sriram";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testApplyTemplateWithSingleFormalArgs() throws Exception {
        String string = "group test;" + this.newline + "test(names) ::= <<<names:bold(item=it); separator=\", \"> >>" + this.newline + "bold(item) ::= <<*<item>*>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string2 = "*Ter*, *Tom* ";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testApplyTemplateWithNoFormalArgs() throws Exception {
        String string = "group test;" + this.newline + "test(names) ::= <<<names:bold(); separator=\", \"> >>" + this.newline + "bold() ::= <<*<it>*>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string2 = "*Ter*, *Tom* ";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testAnonTemplateArgs() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names:{n| $n$}; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string = "Ter, Tom";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testAnonTemplateWithArgHasNoITArg() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names:{n| $n$:$it$}; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string = null;
        try {
            stringTemplate.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string = noSuchElementException.getMessage();
        }
        String string2 = "no such attribute: it in template context [anonymous anonymous]";
        this.assertEqual(string, string2);
    }

    public void testAnonTemplateArgs2() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names:{n| .$n$.}:{ n | _$n$_}; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string = "_.Ter._, _.Tom._";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testFirstWithCatAttribute() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$first([names,phones])$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        String string = "Ter";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testJustCat() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[names,phones]$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        String string = "TerTom12";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testCat2Attributes() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[names,phones]; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        String string = "Ter, Tom, 1, 2";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testCat2AttributesWithApply() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[names,phones]:{a|$a$.}$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        String string = "Ter.Tom.1.2.";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testCat3Attributes() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[names,phones,salaries]; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        stringTemplate.setAttribute("salaries", "huge");
        String string = "Ter, Tom, 1, 2, big, huge";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testListAsTemplateArgument() throws Exception {
        String string = "group test;" + this.newline + "test(names,phones) ::= \"<foo([names,phones])>\"" + this.newline + "foo(items) ::= \"<items:{a | *<a>*}>\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        String string2 = "*Ter**Tom**1**2*";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testSingleExprTemplateArgument() throws Exception {
        String string = "group test;" + this.newline + "test(name) ::= \"<bold(name)>\"" + this.newline + "bold(item) ::= \"*<item>*\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("name", "Ter");
        String string2 = "*Ter*";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testSingleExprTemplateArgumentInApply() throws Exception {
        String string = "group test;" + this.newline + "test(names,x) ::= \"<names:bold(x)>\"" + this.newline + "bold(item) ::= \"*<item>*\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("x", "ick");
        String string2 = "*ick**ick*";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testSoleFormalTemplateArgumentInMultiApply() throws Exception {
        String string = "group test;" + this.newline + "test(names) ::= \"<names:bold(),italics()>\"" + this.newline + "bold(x) ::= \"*<x>*\"" + this.newline + "italics(y) ::= \"_<y>_\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string2 = "*Ter*_Tom_";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testSingleExprTemplateArgumentError() throws Exception {
        String string = "group test;" + this.newline + "test(name) ::= \"<bold(name)>\"" + this.newline + "bold(item,ick) ::= \"*<item>*\"" + this.newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("name", "Ter");
        String string2 = stringTemplate.toString();
        String string3 = "template bold must have exactly one formal arg in template context [test <invoke bold arg context>]";
        this.assertEqual(((Object)errorBuffer).toString(), string3);
    }

    public void testInvokeIndirectTemplateWithSingleFormalArgs() throws Exception {
        String string = "group test;" + this.newline + "test(templateName,arg) ::= \"<(templateName)(arg)>\"" + this.newline + "bold(x) ::= <<*<x>*>>" + this.newline + "italics(y) ::= <<_<y>_>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("templateName", "italics");
        stringTemplate.setAttribute("arg", "Ter");
        String string2 = "_Ter_";
        String string3 = stringTemplate.toString();
        this.assertEqual(string3, string2);
    }

    public void testParallelAttributeIteration() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$\n}$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        stringTemplate.setAttribute("salaries", "huge");
        String string = "Ter@1: big" + this.newline + "Tom@2: huge" + this.newline;
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testParallelAttributeIterationHasI() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{n,p,s | $i0$. $n$@$p$: $s$\n}$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        stringTemplate.setAttribute("salaries", "huge");
        String string = "0. Ter@1: big" + this.newline + "1. Tom@2: huge" + this.newline;
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testParallelAttributeIterationWithDifferentSizes() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$}; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        String string = "Ter@1: big, Tom@2: , Sriram@: ";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testParallelAttributeIterationWithSingletons() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$}; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("salaries", "big");
        String string = "Ter@1: big";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testParallelAttributeIterationWithMismatchArgListSizes() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{n,p | $n$@$p$}; separator=\", \"$");
        stringTemplate.setErrorListener(errorBuffer);
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        String string = "Ter@1, Tom@2";
        this.assertEqual(stringTemplate.toString(), string);
        String string2 = "number of arguments [n, p] mismatch between attribute list and anonymous template in context [anonymous]";
        this.assertEqual(((Object)errorBuffer).toString(), string2);
    }

    public void testParallelAttributeIterationWithMissingArgs() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{$n$@$p$}; separator=\", \"$");
        stringTemplate.setErrorListener(errorBuffer);
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        stringTemplate.toString();
        String string = "missing arguments in anonymous template in context [anonymous]";
        this.assertEqual(((Object)errorBuffer).toString(), string);
    }

    public void testParallelAttributeIterationWithDifferentSizesTemplateRefInsideToo() throws Exception {
        String string = "group test;" + this.newline + "page(names,phones,salaries) ::= " + this.newline + "\t<<$names,phones,salaries:{n,p,s | $value(n)$@$value(p)$: $value(s)$}; separator=\", \"$>>" + this.newline + "value(x=\"n/a\") ::= \"$x$\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        String string2 = "Ter@1: big, Tom@2: n/a, Sriram@n/a: n/a";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testAnonTemplateOnLeftOfApply() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("${foo}:{($it$)}$");
        String string = "(foo)";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testOverrideThroughConditional() throws Exception {
        String string = "group base;" + this.newline + "body(ick) ::= \"<if(ick)>ick<f()><else><f()><endif>\"" + "f() ::= \"foo\"" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + this.newline + "f() ::= \"bar\"" + this.newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer, null, stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("body");
        String string3 = "bar";
        String string4 = stringTemplate.toString();
        this.assertEqual(string4, string3);
    }

    public void testNonPublicPropertyAccess() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$x.foo$:$x.bar$");
        Object object = new Object(){
            public int foo = 9;

            public int getBar() {
                return 34;
            }
        };
        stringTemplate.setAttribute("x", object);
        String string = "9:34";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testIndexVar() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        String string = System.getProperty("line.separator");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A:{$i$. $it$}; separator=\"\\n\"$");
        stringTemplate.setAttribute("A", "parrt");
        stringTemplate.setAttribute("A", "tombu");
        String string2 = "1. parrt" + string + "2. tombu";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testIndex0Var() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        String string = System.getProperty("line.separator");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A:{$i0$. $it$}; separator=\"\\n\"$");
        stringTemplate.setAttribute("A", "parrt");
        stringTemplate.setAttribute("A", "tombu");
        String string2 = "0. parrt" + string + "1. tombu";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testIndexVarWithMultipleExprs() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        String string = System.getProperty("line.separator");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A,B:{a,b|$i$. $a$@$b$}; separator=\"\\n\"$");
        stringTemplate.setAttribute("A", "parrt");
        stringTemplate.setAttribute("A", "tombu");
        stringTemplate.setAttribute("B", "x5707");
        stringTemplate.setAttribute("B", "x5000");
        String string2 = "1. parrt@x5707" + string + "2. tombu@x5000";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testIndex0VarWithMultipleExprs() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        String string = System.getProperty("line.separator");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A,B:{a,b|$i0$. $a$@$b$}; separator=\"\\n\"$");
        stringTemplate.setAttribute("A", "parrt");
        stringTemplate.setAttribute("A", "tombu");
        stringTemplate.setAttribute("B", "x5707");
        stringTemplate.setAttribute("B", "x5000");
        String string2 = "0. parrt@x5707" + string + "1. tombu@x5000";
        this.assertEqual(stringTemplate.toString(), string2);
    }

    public void testArgumentContext() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("main", "$foo(t={Hi, $name$}, name=\"parrt\")$");
        StringTemplate stringTemplate2 = stringTemplateGroup.defineTemplate("foo", "$t$");
        String string = "Hi, parrt";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNoDotsInAttributeNames() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$user.Name$");
        String string = null;
        try {
            stringTemplate.setAttribute("user.Name", "Kunle");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = illegalArgumentException.getMessage();
        }
        String string2 = "cannot have '.' in attribute names";
        this.assertEqual(string, string2);
    }

    public void testNoDotsInTemplateNames() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = "group test;" + this.newline + "a.b() ::= <<foo>>" + this.newline;
        Object var3_3 = null;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer, errorBuffer);
        String string2 = "template group parse error: line 2:1: unexpected token:";
        this.assertTrue(((Object)errorBuffer).toString().startsWith(string2));
    }

    public void testLineWrap() throws Exception {
        String string = "group test;" + this.newline + "array(values) ::= <<int[] a = { <values; wrap=\"\\n\", separator=\",\"> };>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("array");
        stringTemplate.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        String string2 = "int[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n2,1,6,32,5,6,77,4,9,20,2,1,4,63,9,20,2,1,\n4,6,32,5,6,77,6,32,5,6,77,3,9,20,2,1,4,6,\n32,5,6,77,888,1,6,32,5 };";
        this.assertEqual(stringTemplate.toString(40), string2);
    }

    public void testLineWrapAnchored() throws Exception {
        String string = "group test;" + this.newline + "array(values) ::= <<int[] a = { <values; anchor, wrap=\"\\n\", separator=\",\"> };>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("array");
        stringTemplate.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        String string2 = "int[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n            2,1,6,32,5,6,77,4,9,20,2,1,4,\n            63,9,20,2,1,4,6,32,5,6,77,6,\n            32,5,6,77,3,9,20,2,1,4,6,32,\n            5,6,77,888,1,6,32,5 };";
        this.assertEqual(stringTemplate.toString(40), string2);
    }

    public void testFortranLineWrap() throws Exception {
        String string = "group test;" + this.newline + "func(args) ::= <<       FUNCTION line( <args; wrap=\"\\n      c\", separator=\",\"> )>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("func");
        stringTemplate.setAttribute("args", (Object)new String[]{"a", "b", "c", "d", "e", "f"});
        String string2 = "       FUNCTION line( a,b,c,d,\n      ce,f )";
        this.assertEqual(stringTemplate.toString(30), string2);
    }

    public void testLineWrapWithDiffAnchor() throws Exception {
        String string = "group test;" + this.newline + "array(values) ::= <<int[] a = { <{1,9,2,<values; wrap, separator=\",\">}; anchor> };>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("array");
        stringTemplate.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6});
        String string2 = "int[] a = { 1,9,2,3,9,20,2,1,4,\n            6,32,5,6,77,888,2,\n            1,6,32,5,6,77,4,9,\n            20,2,1,4,63,9,20,2,\n            1,4,6 };";
        this.assertEqual(stringTemplate.toString(30), string2);
    }

    public void testLineWrapEdgeCase() throws Exception {
        String string = "group test;" + this.newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String string2 = "abc\nde";
        this.assertEqual(stringTemplate.toString(3), string2);
    }

    public void testLineWrapLastCharIsNewline() throws Exception {
        String string = "group test;" + this.newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("chars", (Object)new String[]{"a", "b", "\n", "d", "e"});
        String string2 = "ab\nde";
        this.assertEqual(stringTemplate.toString(3), string2);
    }

    public void testLineWrapCharAfterWrapIsNewline() throws Exception {
        String string = "group test;" + this.newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("chars", (Object)new String[]{"a", "b", "c", "\n", "d", "e"});
        String string2 = "abc\n\nde";
        this.assertEqual(stringTemplate.toString(3), string2);
    }

    public void testLineWrapForAnonTemplate() throws Exception {
        String string = "group test;" + this.newline + "duh(data) ::= <<!<data:{v|[<v>]}; wrap>!>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        String string2 = "![1][2][3]\n[4][5][6]\n[7][8][9]!";
        this.assertEqual(stringTemplate.toString(9), string2);
    }

    public void testLineWrapForAnonTemplateAnchored() throws Exception {
        String string = "group test;" + this.newline + "duh(data) ::= <<!<data:{v|[<v>]}; anchor, wrap>!>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        String string2 = "![1][2][3]\n [4][5][6]\n [7][8][9]!";
        this.assertEqual(stringTemplate.toString(9), string2);
    }

    public void testLineWrapForAnonTemplateComplicatedWrap() throws Exception {
        String string = "group test;" + this.newline + "top(s) ::= <<  <s>.>>" + "str(data) ::= <<!<data:{v|[<v>]}; wrap=\"!+\\n!\">!>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("str");
        stringTemplate2.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        stringTemplate.setAttribute("s", stringTemplate2);
        String string2 = "  ![1][2]!+\n  ![3][4]!+\n  ![5][6]!+\n  ![7][8]!+\n  ![9]!.";
        this.assertEqual(stringTemplate.toString(9), string2);
    }

    public void testIndentBeyondLineWidth() throws Exception {
        String string = "group test;" + this.newline + "duh(chars) ::= <<    <chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String string2 = "    a\n    b\n    c\n    d\n    e";
        this.assertEqual(stringTemplate.toString(2), string2);
    }

    public void testIndentedExpr() throws Exception {
        String string = "group test;" + this.newline + "duh(chars) ::= <<    <chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String string2 = "    ab\n    cd\n    e";
        this.assertEqual(stringTemplate.toString(6), string2);
    }

    public void testNestedIndentedExpr() throws Exception {
        String string = "group test;" + this.newline + "top(d) ::= <<  <d>!>>" + this.newline + "duh(chars) ::= <<  <chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate2.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        stringTemplate.setAttribute("d", stringTemplate2);
        String string2 = "    ab\n    cd\n    e!";
        this.assertEqual(stringTemplate.toString(6), string2);
    }

    public void testNestedWithIndentAndTrackStartOfExpr() throws Exception {
        String string = "group test;" + this.newline + "top(d) ::= <<  <d>!>>" + this.newline + "duh(chars) ::= <<x: <chars; anchor, wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate2.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        stringTemplate.setAttribute("d", stringTemplate2);
        String string2 = "  x: ab\n     cd\n     e!";
        this.assertEqual(stringTemplate.toString(7), string2);
    }

    public void testLineDoesNotWrapDueToLiteral() throws Exception {
        String string = "group test;" + this.newline + "m(args,body) ::= <<public void foo(<args; wrap=\"\\n\",separator=\", \">) throws Ick { <body> }>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("m");
        stringTemplate.setAttribute("args", (Object)new String[]{"a", "b", "c"});
        stringTemplate.setAttribute("body", "i=3;");
        int n = "public void foo(a, b, c".length();
        String string2 = "public void foo(a, b, c) throws Ick { i=3; }";
        this.assertEqual(stringTemplate.toString(n), string2);
    }

    public void testSingleValueWrap() throws Exception {
        String string = "group test;" + this.newline + "m(args,body) ::= <<{ <body; anchor, wrap=\"\\n\"> }>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("m");
        stringTemplate.setAttribute("body", "i=3;");
        String string2 = "{ \n  i=3; }";
        this.assertEqual(stringTemplate.toString(2), string2);
    }

    public void testLineWrapInNestedExpr() throws Exception {
        String string = "group test;" + this.newline + "top(arrays) ::= <<Arrays: <arrays>done>>" + this.newline + "array(values) ::= <<int[] a = { <values; anchor, wrap=\"\\n\", separator=\",\"> };<\\n\\>>>" + this.newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("array");
        stringTemplate2.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        stringTemplate.setAttribute("arrays", stringTemplate2);
        stringTemplate.setAttribute("arrays", stringTemplate2);
        String string2 = "Arrays: int[] a = { 3,9,20,2,1,4,6,32,5,\n                    6,77,888,2,1,6,32,5,\n                    6,77,4,9,20,2,1,4,63,\n                    9,20,2,1,4,6,32,5,6,\n                    77,6,32,5,6,77,3,9,20,\n                    2,1,4,6,32,5,6,77,888,\n                    1,6,32,5 };\nint[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n            2,1,6,32,5,6,77,4,9,20,2,1,4,\n            63,9,20,2,1,4,6,32,5,6,77,6,\n            32,5,6,77,3,9,20,2,1,4,6,32,\n            5,6,77,888,1,6,32,5 };\ndone";
        this.assertEqual(stringTemplate.toString(40), string2);
    }

    public void testEscapeEscape() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "\\\\$v$");
        stringTemplate.setAttribute("v", "Joe");
        String string = "\\Joe";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testEscapeEscapeNestedAngle() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<v:{a|\\\\<a>}>");
        stringTemplate.setAttribute("v", "Joe");
        String string = "\\Joe";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testListOfIntArrays() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data:array()>");
        stringTemplateGroup.defineTemplate("array", "[<it:element(); separator=\",\">]");
        stringTemplateGroup.defineTemplate("element", "<it>");
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        arrayList.add(new int[]{1, 2, 3});
        arrayList.add(new int[]{10, 20, 30});
        stringTemplate.setAttribute("data", arrayList);
        String string = "[1,2,3][10,20,30]";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNullOptionSingleNullValue() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data; null=\"0\">");
        String string = "0";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNullOptionHasEmptyNullValue() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data; null=\"\", separator=\", \">");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(null);
        arrayList.add(new Integer(1));
        stringTemplate.setAttribute("data", arrayList);
        String string = ", 1";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNullOptionSingleNullValueInList() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data; null=\"0\">");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "0";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNullValueInList() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data; null=\"-1\", separator=\", \">");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(null);
        arrayList.add(new Integer(1));
        arrayList.add(null);
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "-1, 1, -1, 3, 4, -1";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNullValueInListNoNullOption() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data; separator=\", \">");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(null);
        arrayList.add(new Integer(1));
        arrayList.add(null);
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "1, 3, 4";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNullValueInListWithTemplateApply() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        stringTemplateGroup.defineTemplate("array", "<it>");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(0));
        arrayList.add(null);
        arrayList.add(new Integer(2));
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "0, -1, 2, -1";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNullValueInListWithTemplateApplyNullFirstValue() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        stringTemplateGroup.defineTemplate("array", "<it>");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(null);
        arrayList.add(new Integer(0));
        arrayList.add(null);
        arrayList.add(new Integer(2));
        stringTemplate.setAttribute("data", arrayList);
        String string = "-1, 0, -1, 2";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNullSingleValueInListWithTemplateApply() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        stringTemplateGroup.defineTemplate("array", "<it>");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "-1";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testNullSingleValueWithTemplateApply() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        stringTemplateGroup.defineTemplate("array", "<it>");
        String string = "-1";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testLengthOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        String string = "3";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testLengthOpNull() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", (Object)null);
        String string = "0";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testLengthOpSingleValue() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        String string = "1";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testLengthOpPrimitive() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(ints)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("ints", (Object)new int[]{1, 2, 3, 4});
        String string = "4";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testLengthOpOfListWithNulls() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(data)$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Hi");
        arrayList.add(null);
        arrayList.add("mom");
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "4";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testStripOpOfListWithNulls() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$strip(data)$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Hi");
        arrayList.add(null);
        arrayList.add("mom");
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "Himom";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testStripOpOfSingleAlt() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$strip(data)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("data", "hi");
        String string = "hi";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testStripOpOfNull() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$strip(data)$");
        stringTemplate = stringTemplate.getInstanceOf();
        String string = "";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testLengthOpOfStrippedListWithNulls() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(strip(data))$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Hi");
        arrayList.add(null);
        arrayList.add("mom");
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "2";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testLengthOpOfStrippedListWithNullsFrontAndBack() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(strip(data))$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(null);
        arrayList.add(null);
        arrayList.add(null);
        arrayList.add("Hi");
        arrayList.add(null);
        arrayList.add(null);
        arrayList.add(null);
        arrayList.add("mom");
        arrayList.add(null);
        arrayList.add(null);
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "2";
        this.assertEqual(stringTemplate.toString(), string);
    }

    public void testMapKeys() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<aMap.keys:{k|<k>:<aMap.(k)>}; separator=\", \">");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("int", "0");
        linkedHashMap.put("float", "0.0");
        stringTemplate.setAttribute("aMap", linkedHashMap);
        this.assertEqual(stringTemplate.toString(), "int:0, float:0.0");
    }

    public void testMapValues() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer == null ? (class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = TestStringTemplate.class$("org.antlr.stringtemplate.language.AngleBracketTemplateLexer")) : class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<aMap.values; separator=\", \">");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("int", "0");
        linkedHashMap.put("float", "0.0");
        stringTemplate.setAttribute("aMap", linkedHashMap);
        this.assertEqual(stringTemplate.toString(), "0, 0.0");
    }

    public static void writeFile(String string, String string2, String string3) {
        try {
            File file = new File(string, string2);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string3);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("can't write file");
            iOException.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class NonPublicProperty {
    }

    public class DateRenderer2
    implements AttributeRenderer {
        public String toString(Object object) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
            return simpleDateFormat.format(((Calendar)object).getTime());
        }
    }

    public class DateRenderer
    implements AttributeRenderer {
        public String toString(Object object) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd");
            return simpleDateFormat.format(((Calendar)object).getTime());
        }
    }

    static class Duh {
        public List users = new ArrayList();

        Duh() {
        }
    }

    public static class Decl {
        String name;
        String type;

        public Decl(String string, String string2) {
            this.name = string;
            this.type = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public class Connector3 {
        public int[] getValues() {
            return new int[]{1, 2, 3};
        }

        public Map getStuff() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("a", "1");
            hashMap.put("b", "2");
            return hashMap;
        }
    }

    public static class Tree {
        protected List children = new LinkedList();
        protected String text;

        public Tree(String string) {
            this.text = string;
        }

        public String getText() {
            return this.text;
        }

        public void addChild(Tree tree) {
            this.children.add(tree);
        }

        public Tree getFirstChild() {
            if (this.children.size() == 0) {
                return null;
            }
            return (Tree)this.children.get(0);
        }

        public List getChildren() {
            return this.children;
        }
    }

    public class Connector2 {
        public int getID() {
            return 2;
        }

        public String getFirstName() {
            return "Tom";
        }

        public String getLastName() {
            return "Burns";
        }

        public String getEmail() {
            return "tombu@jguru.com";
        }

        public String getBio() {
            return "Superhero by day...";
        }

        public Boolean getCanEdit() {
            return new Boolean(true);
        }
    }

    public class Connector {
        public int getID() {
            return 1;
        }

        public String getFirstName() {
            return "Terence";
        }

        public String getLastName() {
            return "Parr";
        }

        public String getEmail() {
            return "parrt@jguru.com";
        }

        public String getBio() {
            return "Superhero by night...";
        }

        public boolean getCanEdit() {
            return false;
        }
    }

    static class ErrorBuffer
    implements StringTemplateErrorListener {
        StringBuffer errorOutput = new StringBuffer(500);
        int n = 0;

        ErrorBuffer() {
        }

        public void error(String string, Throwable throwable) {
            ++this.n;
            if (this.n > 1) {
                this.errorOutput.append('\n');
            }
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                this.errorOutput.append(string + ": " + stringWriter.toString());
            } else {
                this.errorOutput.append(string);
            }
        }

        public void warning(String string) {
            ++this.n;
            this.errorOutput.append(string);
        }

        public boolean equals(Object object) {
            String string = this.toString();
            String string2 = object.toString();
            return string.equals(string2);
        }

        public String toString() {
            return this.errorOutput.toString();
        }
    }
}

