/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.notifications;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.UserNotificationDefinition;
import com.liferay.portal.kernel.notifications.UserNotificationDeliveryType;
import com.liferay.portal.kernel.notifications.UserNotificationFeedEntry;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.UserNotificationDelivery;
import com.liferay.portal.model.UserNotificationEvent;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserNotificationDeliveryLocalServiceUtil;

public abstract class BaseUserNotificationHandler
implements UserNotificationHandler {
    private static Log _log = LogFactoryUtil.getLog(BaseUserNotificationHandler.class);
    private String _portletId;
    private String _selector = "";

    @Override
    public String getPortletId() {
        return this._portletId;
    }

    @Override
    public String getSelector() {
        return this._selector;
    }

    @Override
    public UserNotificationFeedEntry interpret(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws PortalException {
        try {
            UserNotificationFeedEntry userNotificationFeedEntry = this.doInterpret(userNotificationEvent, serviceContext);
            if (userNotificationFeedEntry != null) {
                userNotificationFeedEntry.setPortletId(this.getPortletId());
            }
            return userNotificationFeedEntry;
        }
        catch (Exception e) {
            _log.error("Unable to interpret notification", e);
            return null;
        }
    }

    @Override
    public boolean isDeliver(long userId, long classNameId, int notificationType, int deliveryType, ServiceContext serviceContext) throws PortalException, SystemException {
        UserNotificationDefinition userNotificationDefinition = UserNotificationManagerUtil.fetchUserNotificationDefinition(this._portletId, classNameId, notificationType);
        UserNotificationDeliveryType userNotificationDeliveryType = userNotificationDefinition.getUserNotificationDeliveryType(deliveryType);
        UserNotificationDelivery userNotificationDelivery = UserNotificationDeliveryLocalServiceUtil.getUserNotificationDelivery(userId, this._portletId, classNameId, notificationType, deliveryType, userNotificationDeliveryType.isDefault());
        return userNotificationDelivery.isDeliver();
    }

    protected UserNotificationFeedEntry doInterpret(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        String body = this.getBody(userNotificationEvent, serviceContext);
        if (Validator.isNull(body)) {
            return null;
        }
        String link = this.getLink(userNotificationEvent, serviceContext);
        return new UserNotificationFeedEntry(body, link);
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return "";
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return "";
    }

    protected void setPortletId(String portletId) {
        this._portletId = portletId;
    }

    protected void setSelector(String selector) {
        this._selector = selector;
    }
}

