/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process;

import com.liferay.portal.kernel.process.ConsumerOutputProcessor;
import com.liferay.portal.kernel.process.LoggingOutputProcessor;
import com.liferay.portal.kernel.process.OutputProcessor;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ProcessUtil {
    public static final ConsumerOutputProcessor CONSUMER_OUTPUT_PROCESSOR = new ConsumerOutputProcessor();
    public static final LoggingOutputProcessor LOGGING_OUTPUT_PROCESSOR = new LoggingOutputProcessor();
    private static volatile ExecutorService _executorService;

    public static <O, E> Future<ObjectValuePair<O, E>> execute(OutputProcessor<O, E> outputProcessor, List<String> arguments) throws ProcessException {
        if (outputProcessor == null) {
            throw new NullPointerException("Output processor is null");
        }
        if (arguments == null) {
            throw new NullPointerException("Arguments is null");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        try {
            Process process = processBuilder.start();
            ExecutorService executorService = ProcessUtil._getExecutorService();
            try {
                Future<O> stdOutFuture = executorService.submit(new ProcessStdOutCallable<O>(outputProcessor, process));
                Future<E> stdErrFuture = executorService.submit(new ProcessStdErrCallable<E>(outputProcessor, process));
                return new BindedFuture<O, E>(stdOutFuture, stdErrFuture, process);
            }
            catch (RejectedExecutionException ree) {
                process.destroy();
                throw new ProcessException("Cancelled execution because of a concurrent destroy", ree);
            }
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
    }

    public static <O, E> Future<ObjectValuePair<O, E>> execute(OutputProcessor<O, E> outputProcessor, String ... arguments) throws ProcessException {
        return ProcessUtil.execute(outputProcessor, Arrays.asList(arguments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (_executorService == null) {
            return;
        }
        Class<ProcessUtil> clazz = ProcessUtil.class;
        synchronized (ProcessUtil.class) {
            if (_executorService != null) {
                _executorService.shutdownNow();
                _executorService = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService _getExecutorService() {
        if (_executorService != null) {
            return _executorService;
        }
        Class<ProcessUtil> clazz = ProcessUtil.class;
        synchronized (ProcessUtil.class) {
            if (_executorService == null) {
                _executorService = Executors.newCachedThreadPool(new NamedThreadFactory(ProcessUtil.class.getName(), 1, PortalClassLoaderUtil.getClassLoader()));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _executorService;
        }
    }

    private static class BindedFuture<O, E>
    implements Future<ObjectValuePair<O, E>> {
        private final Future<E> _stdErrFuture;
        private final Future<O> _stdOutFuture;
        private final Process _process;

        public BindedFuture(Future<O> stdOutFuture, Future<E> stdErrFuture, Process process) {
            this._stdOutFuture = stdOutFuture;
            this._stdErrFuture = stdErrFuture;
            this._process = process;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this._stdOutFuture.isCancelled() || this._stdOutFuture.isDone()) {
                return false;
            }
            this._stdErrFuture.cancel(true);
            this._stdOutFuture.cancel(true);
            this._process.destroy();
            return true;
        }

        @Override
        public ObjectValuePair<O, E> get() throws ExecutionException, InterruptedException {
            E stdErrResult = this._stdErrFuture.get();
            O stdOutResult = this._stdOutFuture.get();
            return new ObjectValuePair<O, E>(stdOutResult, stdErrResult);
        }

        @Override
        public ObjectValuePair<O, E> get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            long startTime = System.currentTimeMillis();
            E stdErrResult = this._stdErrFuture.get(timeout, unit);
            long elapseTime = System.currentTimeMillis() - startTime;
            long secondTimeout = timeout - unit.convert(elapseTime, TimeUnit.MILLISECONDS);
            O stdOutResult = this._stdOutFuture.get(secondTimeout, unit);
            return new ObjectValuePair<O, E>(stdOutResult, stdErrResult);
        }

        @Override
        public boolean isCancelled() {
            return this._stdOutFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this._stdOutFuture.isDone();
        }
    }

    private static class ProcessStdErrCallable<T>
    implements Callable<T> {
        private final OutputProcessor<?, T> _outputProcessor;
        private final Process _process;

        public ProcessStdErrCallable(OutputProcessor<?, T> outputProcessor, Process process) {
            this._outputProcessor = outputProcessor;
            this._process = process;
        }

        @Override
        public T call() throws Exception {
            return this._outputProcessor.processStdErr(this._process.getErrorStream());
        }
    }

    private static class ProcessStdOutCallable<T>
    implements Callable<T> {
        private final OutputProcessor<T, ?> _outputProcessor;
        private final Process _process;

        public ProcessStdOutCallable(OutputProcessor<T, ?> outputProcessor, Process process) {
            this._outputProcessor = outputProcessor;
            this._process = process;
        }

        @Override
        public T call() throws Exception {
            try {
                T t = this._outputProcessor.processStdOut(this._process.getInputStream());
                return t;
            }
            finally {
                try {
                    int exitCode = this._process.waitFor();
                    if (exitCode != 0) {
                        throw new ProcessException("Subprocess terminated with exit code " + exitCode);
                    }
                }
                catch (InterruptedException ie) {
                    this._process.destroy();
                    throw new ProcessException("Forcibly killed subprocess on interruption", ie);
                }
            }
        }
    }
}

