/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQuery;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQueryFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.RowMapper;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.BasePersistence;
import com.liferay.portal.service.persistence.impl.TableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;

public class TableMapperImpl<L extends BaseModel<L>, R extends BaseModel<R>>
implements TableMapper<L, R> {
    protected SqlUpdate addTableMappingSqlUpdate;
    protected SqlUpdate deleteLeftPrimaryKeyTableMappingsSqlUpdate;
    protected SqlUpdate deleteRightPrimaryKeyTableMappingsSqlUpdate;
    protected SqlUpdate deleteTableMappingSqlUpdate;
    protected MappingSqlQuery<Long> getLeftPrimaryKeysSqlQuery;
    protected MappingSqlQuery<Long> getRightPrimaryKeysSqlQuery;
    protected BasePersistence<L> leftBasePersistence;
    protected String leftColumnName;
    protected PortalCache<Long, long[]> leftToRightPortalCache;
    protected TableMapper<R, L> reverseTableMapper;
    protected BasePersistence<R> rightBasePersistence;
    protected String rightColumnName;
    protected PortalCache<Long, long[]> rightToLeftPortalCache;

    public TableMapperImpl(String tableName, String leftColumnName, String rightColumnName, BasePersistence<L> leftBasePersistence, BasePersistence<R> rightBasePersistence) {
        this.leftColumnName = leftColumnName;
        this.rightColumnName = rightColumnName;
        this.leftBasePersistence = leftBasePersistence;
        this.rightBasePersistence = rightBasePersistence;
        DataSource dataSource = leftBasePersistence.getDataSource();
        this.addTableMappingSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, "INSERT INTO " + tableName + " (" + leftColumnName + ", " + rightColumnName + ") VALUES (?, ?)", new int[]{-5, -5});
        this.deleteLeftPrimaryKeyTableMappingsSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, "DELETE FROM " + tableName + " WHERE " + leftColumnName + " = ?", new int[]{-5});
        this.deleteRightPrimaryKeyTableMappingsSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, "DELETE FROM " + tableName + " WHERE " + rightColumnName + " = ?", new int[]{-5});
        this.deleteTableMappingSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, "DELETE FROM " + tableName + " WHERE " + leftColumnName + " = ? AND " + rightColumnName + " = ?", new int[]{-5, -5});
        this.getLeftPrimaryKeysSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, "SELECT " + leftColumnName + " FROM " + tableName + " WHERE " + rightColumnName + " = ?", new int[]{-5}, RowMapper.PRIMARY_KEY);
        this.getRightPrimaryKeysSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, "SELECT " + rightColumnName + " FROM " + tableName + " WHERE " + leftColumnName + " = ?", new int[]{-5}, RowMapper.PRIMARY_KEY);
        this.leftToRightPortalCache = MultiVMPoolUtil.getCache(String.valueOf(TableMapper.class.getName()) + "-" + tableName + "-LeftToRight");
        this.rightToLeftPortalCache = MultiVMPoolUtil.getCache(String.valueOf(TableMapper.class.getName()) + "-" + tableName + "-RightToLeft");
    }

    @Override
    public boolean addTableMapping(long leftPrimaryKey, long rightPrimaryKey) throws SystemException {
        ModelListener<L>[] leftModelListeners;
        if (this.containsTableMapping(leftPrimaryKey, rightPrimaryKey, false)) {
            return false;
        }
        this.leftToRightPortalCache.remove(leftPrimaryKey);
        this.rightToLeftPortalCache.remove(rightPrimaryKey);
        Class<R> rightModelClass = this.rightBasePersistence.getModelClass();
        ModelListener<L>[] modelListenerArray = leftModelListeners = this.leftBasePersistence.getListeners();
        int n = leftModelListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ModelListener<L> leftModelListener = modelListenerArray[n2];
            leftModelListener.onBeforeAddAssociation(leftPrimaryKey, rightModelClass.getName(), rightPrimaryKey);
            ++n2;
        }
        Class<L> leftModelClass = this.leftBasePersistence.getModelClass();
        ModelListener<R>[] rightModelListeners = this.rightBasePersistence.getListeners();
        ModelListener<Object>[] modelListenerArray2 = rightModelListeners;
        int n3 = rightModelListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            ModelListener<R> rightModelListener = modelListenerArray2[n4];
            rightModelListener.onBeforeAddAssociation(rightPrimaryKey, leftModelClass.getName(), leftPrimaryKey);
            ++n4;
        }
        try {
            this.addTableMappingSqlUpdate.update(leftPrimaryKey, rightPrimaryKey);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        modelListenerArray2 = leftModelListeners;
        n3 = leftModelListeners.length;
        n4 = 0;
        while (n4 < n3) {
            ModelListener<Object> leftModelListener = modelListenerArray2[n4];
            leftModelListener.onAfterAddAssociation(leftPrimaryKey, rightModelClass.getName(), rightPrimaryKey);
            ++n4;
        }
        modelListenerArray2 = rightModelListeners;
        n3 = rightModelListeners.length;
        n4 = 0;
        while (n4 < n3) {
            ModelListener<Object> rightModelListener = modelListenerArray2[n4];
            rightModelListener.onAfterAddAssociation(rightPrimaryKey, leftModelClass.getName(), leftPrimaryKey);
            ++n4;
        }
        return true;
    }

    @Override
    public boolean containsTableMapping(long leftPrimaryKey, long rightPrimaryKey) throws SystemException {
        return this.containsTableMapping(leftPrimaryKey, rightPrimaryKey, true);
    }

    @Override
    public int deleteLeftPrimaryKeyTableMappings(long leftPrimaryKey) throws SystemException {
        return TableMapperImpl.deleteTableMappings(this.leftBasePersistence, this.rightBasePersistence, this.leftToRightPortalCache, this.rightToLeftPortalCache, this.getRightPrimaryKeysSqlQuery, this.deleteLeftPrimaryKeyTableMappingsSqlUpdate, leftPrimaryKey);
    }

    @Override
    public int deleteRightPrimaryKeyTableMappings(long rightPrimaryKey) throws SystemException {
        return TableMapperImpl.deleteTableMappings(this.rightBasePersistence, this.leftBasePersistence, this.rightToLeftPortalCache, this.leftToRightPortalCache, this.getLeftPrimaryKeysSqlQuery, this.deleteRightPrimaryKeyTableMappingsSqlUpdate, rightPrimaryKey);
    }

    @Override
    public boolean deleteTableMapping(long leftPrimaryKey, long rightPrimaryKey) throws SystemException {
        ModelListener<R>[] rightModelListeners;
        ModelListener<L>[] leftModelListeners;
        if (!this.containsTableMapping(leftPrimaryKey, rightPrimaryKey, false)) {
            return false;
        }
        this.leftToRightPortalCache.remove(leftPrimaryKey);
        this.rightToLeftPortalCache.remove(rightPrimaryKey);
        Class<R> rightModelClass = this.rightBasePersistence.getModelClass();
        ModelListener<L>[] modelListenerArray = leftModelListeners = this.leftBasePersistence.getListeners();
        int n = leftModelListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ModelListener<L> leftModelListener = modelListenerArray[n2];
            leftModelListener.onBeforeRemoveAssociation(leftPrimaryKey, rightModelClass.getName(), rightPrimaryKey);
            ++n2;
        }
        Class<L> leftModelClass = this.leftBasePersistence.getModelClass();
        ModelListener<R>[] modelListenerArray2 = rightModelListeners = this.rightBasePersistence.getListeners();
        int n3 = rightModelListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            ModelListener<R> rightModelListener = modelListenerArray2[n4];
            rightModelListener.onBeforeRemoveAssociation(rightPrimaryKey, leftModelClass.getName(), leftPrimaryKey);
            ++n4;
        }
        int rowCount = 0;
        try {
            rowCount = this.deleteTableMappingSqlUpdate.update(leftPrimaryKey, rightPrimaryKey);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        if (rowCount > 0) {
            ModelListener<Object>[] modelListenerArray3 = leftModelListeners;
            int n5 = leftModelListeners.length;
            n3 = 0;
            while (n3 < n5) {
                ModelListener<L> leftModelListener = modelListenerArray3[n3];
                leftModelListener.onAfterRemoveAssociation(leftPrimaryKey, rightModelClass.getName(), rightPrimaryKey);
                ++n3;
            }
            modelListenerArray3 = rightModelListeners;
            n5 = rightModelListeners.length;
            n3 = 0;
            while (n3 < n5) {
                ModelListener<Object> rightModelListener = modelListenerArray3[n3];
                rightModelListener.onAfterRemoveAssociation(rightPrimaryKey, leftModelClass.getName(), leftPrimaryKey);
                ++n3;
            }
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        MultiVMPoolUtil.removeCache(this.leftToRightPortalCache.getName());
        MultiVMPoolUtil.removeCache(this.rightToLeftPortalCache.getName());
    }

    @Override
    public List<L> getLeftBaseModels(long rightPrimaryKey, int start, int end, OrderByComparator obc) throws SystemException {
        return TableMapperImpl.getBaseModels(this.rightToLeftPortalCache, this.getLeftPrimaryKeysSqlQuery, rightPrimaryKey, this.leftBasePersistence, start, end, obc);
    }

    @Override
    public long[] getLeftPrimaryKeys(long rightPrimaryKey) throws SystemException {
        return TableMapperImpl.getPrimaryKeys(this.rightToLeftPortalCache, this.getLeftPrimaryKeysSqlQuery, rightPrimaryKey, true);
    }

    @Override
    public TableMapper<R, L> getReverseTableMapper() {
        return this.reverseTableMapper;
    }

    @Override
    public List<R> getRightBaseModels(long leftPrimaryKey, int start, int end, OrderByComparator obc) throws SystemException {
        return TableMapperImpl.getBaseModels(this.leftToRightPortalCache, this.getRightPrimaryKeysSqlQuery, leftPrimaryKey, this.rightBasePersistence, start, end, obc);
    }

    @Override
    public long[] getRightPrimaryKeys(long leftPrimaryKey) throws SystemException {
        return TableMapperImpl.getPrimaryKeys(this.leftToRightPortalCache, this.getRightPrimaryKeysSqlQuery, leftPrimaryKey, true);
    }

    @Override
    public boolean matches(String leftColumnName, String rightColumnName) {
        return this.leftColumnName.equals(leftColumnName) && this.rightColumnName.equals(rightColumnName);
    }

    public void setReverseTableMapper(TableMapper<R, L> reverseTableMapper) {
        this.reverseTableMapper = reverseTableMapper;
    }

    protected static <M extends BaseModel<M>, S extends BaseModel<S>> int deleteTableMappings(BasePersistence<M> masterBasePersistence, BasePersistence<S> slaveBasePersistence, PortalCache<Long, long[]> masterToSlavePortalCache, PortalCache<Long, long[]> slaveToMasterPortalCache, MappingSqlQuery<Long> mappingSqlQuery, SqlUpdate deleteSqlUpdate, long masterPrimaryKey) throws SystemException {
        int n;
        long slavePrimaryKey;
        int n2;
        int n3;
        long[] lArray;
        ModelListener<M>[] masterModelListeners = masterBasePersistence.getListeners();
        ModelListener<S>[] slaveModelListeners = slaveBasePersistence.getListeners();
        long[] slavePrimaryKeys = TableMapperImpl.getPrimaryKeys(masterToSlavePortalCache, mappingSqlQuery, masterPrimaryKey, false);
        Class<M> masterModelClass = null;
        Class<S> slaveModelClass = null;
        if (masterModelListeners.length > 0 || slaveModelListeners.length > 0) {
            masterModelClass = masterBasePersistence.getModelClass();
            slaveModelClass = slaveBasePersistence.getModelClass();
            lArray = slavePrimaryKeys;
            n3 = slavePrimaryKeys.length;
            n2 = 0;
            while (n2 < n3) {
                slavePrimaryKey = lArray[n2];
                ModelListener<Object>[] modelListenerArray = masterModelListeners;
                n = masterModelListeners.length;
                int n4 = 0;
                while (n4 < n) {
                    ModelListener<M> masterModelListener = modelListenerArray[n4];
                    masterModelListener.onBeforeRemoveAssociation(masterPrimaryKey, slaveModelClass.getName(), slavePrimaryKey);
                    ++n4;
                }
                modelListenerArray = slaveModelListeners;
                n = slaveModelListeners.length;
                n4 = 0;
                while (n4 < n) {
                    ModelListener<Object> slaveModelListener = modelListenerArray[n4];
                    slaveModelListener.onBeforeRemoveAssociation(slavePrimaryKey, masterModelClass.getName(), masterPrimaryKey);
                    ++n4;
                }
                ++n2;
            }
        }
        masterToSlavePortalCache.remove(masterPrimaryKey);
        lArray = slavePrimaryKeys;
        n3 = slavePrimaryKeys.length;
        n2 = 0;
        while (n2 < n3) {
            slavePrimaryKey = lArray[n2];
            slaveToMasterPortalCache.remove(slavePrimaryKey);
            ++n2;
        }
        int rowCount = 0;
        try {
            rowCount = deleteSqlUpdate.update(masterPrimaryKey);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        if (masterModelListeners.length > 0 || slaveModelListeners.length > 0) {
            long[] lArray2 = slavePrimaryKeys;
            int n5 = slavePrimaryKeys.length;
            n3 = 0;
            while (n3 < n5) {
                long slavePrimaryKey2 = lArray2[n3];
                ModelListener<Object>[] modelListenerArray = masterModelListeners;
                int n6 = masterModelListeners.length;
                n = 0;
                while (n < n6) {
                    ModelListener<M> masterModelListener = modelListenerArray[n];
                    masterModelListener.onAfterRemoveAssociation(masterPrimaryKey, slaveModelClass.getName(), slavePrimaryKey2);
                    ++n;
                }
                modelListenerArray = slaveModelListeners;
                n6 = slaveModelListeners.length;
                n = 0;
                while (n < n6) {
                    ModelListener<Object> slaveModelListener = modelListenerArray[n];
                    slaveModelListener.onAfterRemoveAssociation(slavePrimaryKey2, masterModelClass.getName(), masterPrimaryKey);
                    ++n;
                }
                ++n3;
            }
        }
        return rowCount;
    }

    protected static <T extends BaseModel<T>> List<T> getBaseModels(PortalCache<Long, long[]> portalCache, MappingSqlQuery<Long> mappingSqlQuery, long masterPrimaryKey, BasePersistence<T> slaveBasePersistence, int start, int end, OrderByComparator obc) throws SystemException {
        long[] slavePrimaryKeys = TableMapperImpl.getPrimaryKeys(portalCache, mappingSqlQuery, masterPrimaryKey, true);
        if (slavePrimaryKeys.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> slaveBaseModels = new ArrayList<T>(slavePrimaryKeys.length);
        try {
            long[] lArray = slavePrimaryKeys;
            int n = slavePrimaryKeys.length;
            int n2 = 0;
            while (n2 < n) {
                long slavePrimaryKey = lArray[n2];
                slaveBaseModels.add(slaveBasePersistence.findByPrimaryKey(Long.valueOf(slavePrimaryKey)));
                ++n2;
            }
        }
        catch (NoSuchModelException nsme) {
            throw new SystemException(nsme);
        }
        if (obc != null) {
            Collections.sort(slaveBaseModels, obc);
        }
        return ListUtil.subList(slaveBaseModels, start, end);
    }

    protected static long[] getPrimaryKeys(PortalCache<Long, long[]> portalCache, MappingSqlQuery<Long> mappingSqlQuery, long masterPrimaryKey, boolean updateCache) throws SystemException {
        long[] primaryKeys = portalCache.get(masterPrimaryKey);
        if (primaryKeys == null) {
            List<Long> primaryKeysList = null;
            try {
                primaryKeysList = mappingSqlQuery.execute(masterPrimaryKey);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            primaryKeys = new long[primaryKeysList.size()];
            int i = 0;
            while (i < primaryKeys.length) {
                primaryKeys[i] = primaryKeysList.get(i);
                ++i;
            }
            Arrays.sort(primaryKeys);
            if (updateCache) {
                portalCache.put(masterPrimaryKey, primaryKeys);
            }
        }
        return primaryKeys;
    }

    protected boolean containsTableMapping(long leftPrimaryKey, long rightPrimaryKey, boolean updateCache) throws SystemException {
        long[] rightPrimaryKeys = TableMapperImpl.getPrimaryKeys(this.leftToRightPortalCache, this.getRightPrimaryKeysSqlQuery, leftPrimaryKey, updateCache);
        return Arrays.binarySearch(rightPrimaryKeys, rightPrimaryKey) >= 0;
    }
}

