/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.theme;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class NavItem
implements Serializable {
    private List<NavItem> _children;
    private Layout _layout;
    private HttpServletRequest _request;
    private Template _template;
    private ThemeDisplay _themeDisplay;

    public static List<NavItem> fromLayouts(HttpServletRequest request, List<Layout> layouts, Template template) {
        if (layouts == null) {
            return null;
        }
        ArrayList<NavItem> navItems = new ArrayList<NavItem>(layouts.size());
        for (Layout layout : layouts) {
            navItems.add(new NavItem(request, layout, template));
        }
        return navItems;
    }

    public NavItem(HttpServletRequest request, Layout layout, Template template) {
        this._request = request;
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._layout = layout;
        this._template = template;
    }

    public List<NavItem> getChildren() throws Exception {
        if (this._children == null) {
            List<Layout> layouts = this._layout.getChildren(this._themeDisplay.getPermissionChecker());
            this._children = NavItem.fromLayouts(this._request, layouts, this._template);
        }
        return this._children;
    }

    public Layout getLayout() {
        return this._layout;
    }

    public long getLayoutId() {
        return this._layout.getLayoutId();
    }

    public String getName() {
        return HtmlUtil.escape(this.getUnescapedName());
    }

    public String getRegularFullURL() throws Exception {
        String portalURL = PortalUtil.getPortalURL(this._request);
        String regularURL = this.getRegularURL();
        if (StringUtil.startsWith(regularURL, portalURL) || Validator.isUrl(regularURL)) {
            return regularURL;
        }
        return portalURL.concat(regularURL);
    }

    public String getRegularURL() throws Exception {
        return this._layout.getRegularURL(this._request);
    }

    public String getResetLayoutURL() throws Exception {
        return this._layout.getResetLayoutURL(this._request);
    }

    public String getResetMaxStateURL() throws Exception {
        return this._layout.getResetMaxStateURL(this._request);
    }

    public String getTarget() {
        return this._layout.getTarget();
    }

    public String getTitle() {
        return this._layout.getTitle(this._themeDisplay.getLocale());
    }

    public String getUnescapedName() {
        return this._layout.getName(this._themeDisplay.getLocale());
    }

    public String getURL() throws Exception {
        return HtmlUtil.escapeHREF(this.getRegularFullURL());
    }

    public boolean hasChildren() throws Exception {
        return this.getChildren().size() > 0;
    }

    public void icon() throws Exception {
        Object velocityTaglib = this._template.get("theme");
        Method method = (Method)this._template.get("velocityTaglib_layoutIcon");
        method.invoke(velocityTaglib, this._layout);
    }

    public boolean isChildSelected() throws PortalException, SystemException {
        return this._layout.isChildSelected(this._themeDisplay.isTilesSelectable(), this._themeDisplay.getLayout());
    }

    public boolean isSelected() throws Exception {
        return this._layout.isSelected(this._themeDisplay.isTilesSelectable(), this._themeDisplay.getLayout(), this._themeDisplay.getLayout().getAncestorPlid());
    }
}

