/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.compat.portal.kernel.notifications;

import com.liferay.compat.portal.kernel.notifications.BaseUserNotificationHandler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserNotificationEvent;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.UserNotificationEventLocalServiceUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import java.util.Locale;

public abstract class BaseModelUserNotificationHandler
extends BaseUserNotificationHandler {
    protected AssetRenderer getAssetRenderer(JSONObject jsonObject) {
        String className = jsonObject.getString("className");
        long classPK = jsonObject.getLong("classPK");
        return this.getAssetRenderer(className, classPK);
    }

    protected AssetRenderer getAssetRenderer(String className, long classPK) {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null) {
            return null;
        }
        AssetRenderer assetRenderer = null;
        try {
            assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
        }
        catch (Exception exception) {}
        return assetRenderer;
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
        AssetRenderer assetRenderer = this.getAssetRenderer(jsonObject);
        if (assetRenderer == null) {
            UserNotificationEventLocalServiceUtil.deleteUserNotificationEvent((long)userNotificationEvent.getUserNotificationEventId());
            return null;
        }
        return StringUtil.replace((String)this.getBodyTemplate(), (String[])new String[]{"[$BODY$]", "[$TITLE$]"}, (String[])new String[]{HtmlUtil.escape((String)StringUtil.shorten((String)jsonObject.getString("entryTitle"), (int)70)), this.getTitle(jsonObject, assetRenderer, serviceContext)});
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
        return jsonObject.getString("entryURL");
    }

    protected String getTitle(JSONObject jsonObject, AssetRenderer assetRenderer, ServiceContext serviceContext) throws Exception {
        String message = "";
        String typeName = ResourceActionsUtil.getModelResource((Locale)serviceContext.getLocale(), (String)assetRenderer.getClassName());
        int notificationType = jsonObject.getInt("notificationType");
        if (notificationType == 0) {
            message = "x-added-a-new-x";
        } else if (notificationType == 1) {
            message = "x-updated-a-x";
        }
        String userName = assetRenderer.getUserName();
        long userId = jsonObject.getLong("userId");
        if (userId > 0L) {
            User user = UserLocalServiceUtil.getUser((long)userId);
            userName = user.getFullName();
        }
        return serviceContext.translate(message, new Object[]{HtmlUtil.escape((String)userName), StringUtil.toLowerCase((String)HtmlUtil.escape((String)typeName))});
    }
}

